/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.workflow.impl.bonita;

import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.exoplatform.services.workflow.Task;
import org.ow2.bonita.facade.runtime.ActivityInstance;
import org.ow2.bonita.facade.runtime.TaskInstance;
import org.ow2.bonita.util.AccessorUtil;
import org.ow2.bonita.util.BonitaException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskData
implements Task {
    private String actorId = null;
    private String description = null;
    private String id = null;
    private String processId = null;
    private String processInstanceId = null;
    private String taskName = null;
    private Date end = null;
    private static Logger log = Logger.getLogger(TaskData.class.getName());

    public TaskData(ActivityInstance<TaskInstance> task) {
        if (((TaskInstance)task.getBody()).isTaskAssigned()) {
            this.actorId = ((TaskInstance)task.getBody()).getTaskUser();
        } else {
            this.actorId = "";
            boolean separator = false;
            for (String candidat : ((TaskInstance)task.getBody()).getTaskCandidates()) {
                if (separator) {
                    this.actorId = this.actorId + " , ";
                } else {
                    separator = true;
                }
                this.actorId = this.actorId + candidat;
            }
        }
        try {
            this.description = AccessorUtil.getQueryAPIAccessor().getQueryDefinitionAPI().getProcessActivity(task.getProcessDefinitionUUID(), task.getActivityId()).getDescription();
            this.id = ((TaskInstance)task.getBody()).getUUID().toString();
            this.processInstanceId = task.getProcessInstanceUUID().toString();
            this.taskName = task.getActivityId();
            this.processId = task.getProcessDefinitionUUID().toString();
            this.end = ((TaskInstance)task.getBody()).getEndedDate();
        }
        catch (BonitaException e) {
            log.log(Level.WARNING, e.getMessage(), e);
        }
        if (log.isLoggable(Level.INFO)) {
            log.info("New task created [taskId,taskName,actorId,processId,instanceId,description,end]:[" + this.id + "," + this.taskName + "," + this.actorId + "," + this.processId + "," + this.processInstanceId + "," + this.description + "," + this.end);
        }
    }

    public String getActorId() {
        return this.actorId;
    }

    public String getDescription() {
        return this.description;
    }

    public String getId() {
        return this.id;
    }

    public String getProcessId() {
        return this.processId;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public Date getEnd() {
        return this.end;
    }
}

