/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.workflow.impl.bonita;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.exoplatform.commons.utils.IOUtil;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.ExoResourceBundle;
import org.exoplatform.services.resources.XMLResourceBundleParser;
import org.exoplatform.services.workflow.FileDefinition;
import org.ow2.bonita.util.Misc;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BARFileDefinition
implements FileDefinition {
    private byte[] barFile;
    protected Hashtable<String, byte[]> entries;
    private Element formDefinition;
    private static final String XPDL_NAMESPACE_URI = "http://www.wfmc.org/2002/XPDL1.0";
    private static final Log LOG = ExoLogger.getLogger(BARFileDefinition.class);

    public void deploy() throws Exception {
    }

    public String getProcessModelName() {
        XPath xPath = XPathFactory.newInstance().newXPath();
        String expression = "/xpdl:Package/xpdl:WorkflowProcesses/xpdl:WorkflowProcess/@Name";
        try {
            NamespaceResolver namespaceContext = new NamespaceResolver();
            namespaceContext.setNamespace("xpdl", XPDL_NAMESPACE_URI);
            xPath.setNamespaceContext(namespaceContext);
            return xPath.evaluate("/xpdl:Package/xpdl:WorkflowProcesses/xpdl:WorkflowProcess/@Name", new InputSource(new ByteArrayInputStream(this.getXPDLDefinition())));
        }
        catch (Exception e) {
            throw new RuntimeException("Error while getting the process model name", e);
        }
    }

    public ResourceBundle getResourceBundle(String stateName, Locale locale) {
        String bundleName = this.getResourceBundleName(stateName);
        ClassLoader cl = this.getClass().getClassLoader();
        String content = "";
        URL url = cl.getResource(bundleName + "_" + locale.getLanguage() + ".xml");
        if (url == null) {
            url = cl.getResource(bundleName + ".xml");
        }
        if (url != null) {
            try {
                Properties props = XMLResourceBundleParser.asProperties((InputStream)url.openStream());
                StringBuilder sb = new StringBuilder();
                for (Map.Entry<Object, Object> entry : props.entrySet()) {
                    sb.append(entry.getKey());
                    sb.append('=');
                    sb.append(entry.getValue());
                    sb.append('\n');
                }
                content = sb.toString();
            }
            catch (Exception e) {
                throw new RuntimeException("Error while parsing the XML File", e);
            }
        }
        if (content.length() == 0) {
            String fileName = bundleName + "_" + locale.getLanguage() + ".properties";
            url = cl.getResource(fileName);
            if (url == null) {
                url = cl.getResource(bundleName + ".properties");
            }
            if (url != null) {
                try {
                    InputStream is = url.openStream();
                    byte[] buf = IOUtil.getStreamContentAsBytes((InputStream)is);
                    content = new String(buf, "UTF-8");
                    is.close();
                }
                catch (Exception e) {
                    throw new RuntimeException("Error while parsing the XML File", e);
                }
            }
        }
        return new ExoResourceBundle(content);
    }

    public String getCustomizedView(String stateName) {
        XPath xPath = XPathFactory.newInstance().newXPath();
        String expression = "/forms/form[state-name=\"" + stateName + "\"]/customized-view/text()";
        try {
            return xPath.evaluate(expression, this.getFormsDefinition());
        }
        catch (Exception e) {
            throw new RuntimeException("Error while getting the Customized View of Form " + stateName, e);
        }
    }

    public byte[] getEntry(String path) throws Exception {
        byte[] entry = this.entries.get(path);
        if (entry == null) {
            throw new Exception("The specified entry is not found");
        }
        return entry;
    }

    public Element getForm(String stateName) {
        XPath xPath = XPathFactory.newInstance().newXPath();
        String expression = "/forms/form[state-name=\"" + stateName + "\"]";
        try {
            return (Element)xPath.evaluate(expression, this.getFormsDefinition(), XPathConstants.NODE);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while getting the Form " + stateName, e);
        }
    }

    public Element getFormsDefinition() {
        Element ret = null;
        byte[] xpdlDefinition = this.entries.get("forms.xml");
        try {
            if (xpdlDefinition == null) {
                throw new Exception("The XPDL definition file was not retrieved.");
            }
            if (this.formDefinition == null) {
                ByteArrayInputStream inputStream = new ByteArrayInputStream(xpdlDefinition);
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                this.formDefinition = builder.parse(inputStream).getDocumentElement();
            }
            ret = this.formDefinition;
        }
        catch (Exception e) {
            throw new RuntimeException("Error while parsing the XPDL Definition", e);
        }
        return ret;
    }

    public String getResourceBundleName(String stateName) {
        XPath xPath = XPathFactory.newInstance().newXPath();
        String expression = "/forms/form[state-name=\"" + stateName + "\"]/resource-bundle/text()";
        try {
            return (String)xPath.evaluate(expression, this.getFormsDefinition(), XPathConstants.STRING);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while getting the Bundle name of Form " + stateName, e);
        }
    }

    public List<Map<String, Object>> getVariables(String stateName) {
        ArrayList<Map<String, Object>> ret = new ArrayList<Map<String, Object>>();
        XPath xPath = XPathFactory.newInstance().newXPath();
        String expression = "/forms/form[state-name=\"" + stateName + "\"]/variable";
        try {
            NodeList nodeSet = (NodeList)xPath.evaluate(expression, this.getFormsDefinition(), XPathConstants.NODESET);
            for (int i = 0; i < nodeSet.getLength(); ++i) {
                Attr visiable;
                Attr mandatory;
                Attr editable;
                Attr component;
                Element element = (Element)nodeSet.item(i);
                HashMap<String, String> attributes = new HashMap<String, String>();
                Attr name = element.getAttributeNode("name");
                if (name != null) {
                    attributes.put("name", name.getValue());
                }
                if ((component = element.getAttributeNode("component")) != null) {
                    attributes.put("component", component.getValue());
                }
                if ((editable = element.getAttributeNode("editable")) != null) {
                    attributes.put("editable", editable.getValue());
                }
                if ((mandatory = element.getAttributeNode("mandatory")) != null) {
                    attributes.put("mandatory", mandatory.getValue());
                }
                if ((visiable = element.getAttributeNode("visiable")) != null) {
                    attributes.put("visiable", visiable.getValue());
                }
                ret.add(attributes);
            }
            return ret;
        }
        catch (Exception e) {
            throw new RuntimeException("Error while retrieving variables of Form " + stateName, e);
        }
    }

    public byte[] getXPDLDefinition() {
        for (String key : this.entries.keySet()) {
            if (!key.matches(".*\\.xpdl$|")) continue;
            return this.entries.get(key);
        }
        return null;
    }

    public boolean isDelegatedView(String stateName) {
        XPath xPath = XPathFactory.newInstance().newXPath();
        String expression = "/forms/form[state-name=\"" + stateName + "\"]/delegated-view/text()";
        try {
            return "true".equals((String)xPath.evaluate(expression, this.getFormsDefinition(), XPathConstants.STRING));
        }
        catch (Exception e) {
            throw new RuntimeException("Error while determining if the view of Form " + stateName + " is delegated", e);
        }
    }

    public boolean isFormDefined(String stateName) {
        return this.getForm(stateName) != null;
    }

    public Hashtable<String, byte[]> getEntries() {
        return this.entries;
    }

    public BARFileDefinition() {
    }

    public BARFileDefinition(InputStream inputStream) throws IOException {
        inputStream.mark(0);
        this.barFile = Misc.getAllContentFrom((InputStream)inputStream);
        inputStream.reset();
        JarInputStream jarInputStream = new JarInputStream(inputStream);
        this.entries = new Hashtable();
        byte[] buffer = new byte[8192];
        JarEntry entry = null;
        while ((entry = jarInputStream.getNextJarEntry()) != null) {
            String entryName = entry.getName();
            if (!entryName.toLowerCase().matches(".*\\.xpdl$|forms.xml|.*\\.properties$|.*\\.vm$|.*\\.gtmpl$|.*\\.gif$|.*\\.class$")) continue;
            BufferedInputStream in = new BufferedInputStream(jarInputStream);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int count = 0;
            while ((count = in.read(buffer, 0, buffer.length)) >= 0) {
                out.write(buffer, 0, count);
            }
            this.entries.put(entryName, out.toByteArray());
        }
    }

    public BARFileDefinition(Node node) {
        block4: {
            this.entries = new Hashtable();
            byte[] buffer = new byte[8192];
            try {
                QueryManager qm = node.getSession().getWorkspace().getQueryManager();
                String nodePath = node.getPath();
                Query q = qm.createQuery("select * from nt:base where jcr:path like '" + nodePath + "/%'", "sql");
                QueryResult result = q.execute();
                NodeIterator it = result.getNodes();
                while (it.hasNext()) {
                    Node n = it.nextNode();
                    if (!n.getName().equals("jcr:content")) continue;
                    Property data = n.getProperty("jcr:data");
                    InputStream stream = data.getStream();
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    int read = 0;
                    while ((read = stream.read(buffer)) > 0) {
                        out.write(buffer, 0, read);
                    }
                    String name_ = n.getPath().substring(node.getPath().length() + 1);
                    String name = name_.substring(0, name_.length() - "jcr:content/".length());
                    this.entries.put(name, out.toByteArray());
                }
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) break block4;
                LOG.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private class NamespaceResolver
    implements NamespaceContext {
        private Map<String, String> map = new HashMap<String, String>();

        private NamespaceResolver() {
        }

        public String getNamespaceURI(String prefix) {
            return this.map.get(prefix);
        }

        public String getPrefix(String namespaceURI) {
            Set<String> keys = this.map.keySet();
            for (String prefix : keys) {
                String uri = this.map.get(prefix);
                if (!uri.equals(namespaceURI)) continue;
                return prefix;
            }
            return null;
        }

        public Iterator getPrefixes(String namespaceURI) {
            ArrayList<String> prefixes = new ArrayList<String>();
            Set<String> keys = this.map.keySet();
            for (String prefix : keys) {
                String uri = this.map.get(prefix);
                if (!uri.equals(namespaceURI)) continue;
                prefixes.add(prefix);
            }
            return prefixes.iterator();
        }

        public void setNamespace(String prefix, String namespaceURI) {
            this.map.put(prefix, namespaceURI);
        }
    }
}

