/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.workflow.impl.bonita;

import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.exoplatform.container.RootContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.jaas.BasicCallbackHandler;
import org.exoplatform.services.workflow.Form;
import org.exoplatform.services.workflow.impl.bonita.AutomaticFormBundle;
import org.ow2.bonita.facade.QueryDefinitionAPI;
import org.ow2.bonita.facade.def.dataType.DataTypeDefinition;
import org.ow2.bonita.facade.def.dataType.EnumerationTypeDefinition;
import org.ow2.bonita.facade.def.majorElement.DataFieldDefinition;
import org.ow2.bonita.facade.exception.ActivityDefNotFoundException;
import org.ow2.bonita.facade.exception.ProcessNotFoundException;
import org.ow2.bonita.facade.uuid.ActivityDefinitionUUID;
import org.ow2.bonita.facade.uuid.UUIDFactory;
import org.ow2.bonita.identity.auth.BonitaPrincipal;
import org.ow2.bonita.util.AccessorUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutomaticFormImpl
implements Form {
    private ResourceBundle bundle;
    private String activity;
    private List<Map<String, Object>> submitButtons;
    private Hashtable<String, Map<String, Object>> variables;
    private static final Log LOG = ExoLogger.getExoLogger(AutomaticFormImpl.class);

    public AutomaticFormImpl(String processId, String activity, Locale locale) {
        block4: {
            try {
                if ("".equals(activity)) {
                    this.activity = "";
                    this.bundle = new AutomaticFormBundle("start");
                    this.variables = new Hashtable();
                    this.submitButtons = new ArrayList<Map<String, Object>>();
                    ((AutomaticFormBundle)this.bundle).addDefaultButton();
                    this.initializeProjectVariables(processId);
                } else {
                    this.activity = activity;
                    this.bundle = new AutomaticFormBundle(this.activity);
                    this.variables = new Hashtable();
                    this.submitButtons = new ArrayList<Map<String, Object>>();
                    HashMap<String, Object> attributes = new HashMap<String, Object>();
                    attributes.put("name", "submit");
                    attributes.put("transition", "");
                    this.submitButtons.add(attributes);
                    ((AutomaticFormBundle)this.bundle).addButton(attributes);
                    this.initializeNodeVariables(processId, activity);
                    this.initializeProjectVariables(processId);
                }
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) break block4;
                LOG.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public String getCustomizedView() {
        return null;
    }

    public String getIconURL() {
        return "";
    }

    public ResourceBundle getResourceBundle() {
        return this.bundle;
    }

    public String getStateImageURL() {
        return "";
    }

    public String getStateName() {
        return this.activity;
    }

    public List getSubmitButtons() {
        return this.submitButtons;
    }

    public List getVariables() {
        ArrayList<Map<String, Object>> ret = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> attributes : this.variables.values()) {
            ret.add(attributes);
        }
        return ret;
    }

    private void initializeNodeVariables(String processId, String activityId) {
        block4: {
            this.commit();
            try {
                QueryDefinitionAPI qAPI = AccessorUtil.getQueryAPIAccessor().getQueryDefinitionAPI();
                ActivityDefinitionUUID aUUID = qAPI.getProcessActivityId(UUIDFactory.getProcessDefinitionUUID(processId), activityId);
                Set vList = qAPI.getActivityDataFields(aUUID);
                this.initializeVariables(vList);
            }
            catch (ProcessNotFoundException e) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)e.getMessage(), (Throwable)e);
                }
            }
            catch (ActivityDefNotFoundException e) {
                if (!LOG.isWarnEnabled()) break block4;
                LOG.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private void initializeProjectVariables(String processId) {
        block2: {
            this.commit();
            try {
                Set vList = AccessorUtil.getQueryAPIAccessor().getQueryDefinitionAPI().getProcessDataFields(UUIDFactory.getProcessDefinitionUUID(processId));
                this.initializeVariables(vList);
            }
            catch (ProcessNotFoundException e) {
                if (!LOG.isWarnEnabled()) break block2;
                LOG.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private void initializeVariables(Set<DataFieldDefinition> vList) {
        for (DataFieldDefinition key : vList) {
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put("name", key.getDataFieldId());
            attributes.put("editable", "true");
            attributes.put("mandatory", "false");
            attributes.put("visiable", "true");
            if (key.getDataType().getType().equals((Object)DataTypeDefinition.Type.EnumerationType)) {
                attributes.put("component", "select");
                attributes.put("possible-values", ((EnumerationTypeDefinition)key.getDataType().getValue()).getEnumerationValues());
            } else {
                attributes.put("component", "text");
            }
            this.variables.put(key.getDataFieldId(), attributes);
            ((AutomaticFormBundle)this.bundle).addVariable(attributes);
        }
    }

    public boolean isCustomizedView() {
        return false;
    }

    public boolean isDelegatedView() {
        return false;
    }

    public String getMessage() {
        return null;
    }

    public boolean hasMessage() {
        return false;
    }

    private void commit() {
        block7: {
            LoginContext lc = null;
            OrganizationService organizationService = (OrganizationService)RootContainer.getComponent(OrganizationService.class);
            try {
                Identity identity = ConversationState.getCurrent().getIdentity();
                if (identity.getSubject() != null) {
                    Subject s = new Subject();
                    s.getPrincipals().add((Principal)new BonitaPrincipal(identity.getUserId()));
                    try {
                        lc = new LoginContext("Bonita", s);
                    }
                    catch (LoginException le) {
                        if (LOG.isWarnEnabled()) {
                            LOG.warn((Object)le.getMessage(), (Throwable)le);
                        }
                    }
                } else {
                    UserHandler userHandler = organizationService.getUserHandler();
                    User user = userHandler.findUserByName(identity.getUserId());
                    char[] password = user.getPassword().toCharArray();
                    BasicCallbackHandler handler = new BasicCallbackHandler(identity.getUserId(), password);
                    lc = new LoginContext("gatein-domain", (CallbackHandler)handler);
                }
                lc.login();
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) break block7;
                LOG.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
    }
}

