/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecms.upgrade.plugins;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;

public class DriveDataUpgradePlugin
extends UpgradeProductPlugin {
    private static final Log LOG = ExoLogger.getLogger((String)DriveDataUpgradePlugin.class.getName());
    private NodeHierarchyCreator nodeHierarchyCreator;
    private RepositoryService repoService;
    private OrganizationService organService;

    public DriveDataUpgradePlugin(RepositoryService repoService, NodeHierarchyCreator nodeHierarchyCreator, OrganizationService organizationService, InitParams initParams) {
        super(initParams);
        this.nodeHierarchyCreator = nodeHierarchyCreator;
        this.repoService = repoService;
        this.organService = organizationService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUpgrade(String oldVersion, String newVersion) {
        SessionProvider sessionProvider = null;
        long time1 = System.currentTimeMillis();
        try {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Start " + ((Object)((Object)this)).getClass().getName() + "............."));
            }
            RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
            sessionProvider = SessionProvider.createSystemProvider();
            ManageableRepository repo = this.repoService.getCurrentRepository();
            Session session = sessionProvider.getSession(repo.getConfiguration().getDefaultWorkspaceName(), repo);
            String groupsPath = this.nodeHierarchyCreator.getJcrPath("groupsPath");
            NodeIterator subNodes = session.getWorkspace().getQueryManager().createQuery("SELECT * FROM nt:unstructured WHERE jcr:path like '" + groupsPath + "/%' " + "ORDER BY exo:name", "sql").execute().getNodes();
            int count = 0;
            while (subNodes.hasNext()) {
                Group group;
                Node subNode = subNodes.nextNode();
                String groupId = subNode.getPath().substring(groupsPath.length());
                if (groupId.endsWith("/")) {
                    groupId = groupId.substring(0, groupId.length() - 1);
                }
                if ((group = this.organService.getGroupHandler().findGroupById(groupId)) == null) continue;
                if (!subNode.isNodeType("exo:driveMetadata")) {
                    subNode.addMixin("exo:driveMetadata");
                    subNode.setProperty("exo:driveLabel", group.getLabel());
                    subNode.save();
                }
                if (++count % 100 != 0 || !LOG.isInfoEnabled()) continue;
                LOG.info((Object)(count + " groups processed..."));
            }
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)(((Object)((Object)this)).getClass().getName() + " failed:"), (Throwable)e);
            }
        }
        finally {
            RequestLifeCycle.end();
            if (sessionProvider != null) {
                sessionProvider.close();
            }
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("End " + ((Object)((Object)this)).getClass().getName() + "............."));
                LOG.info((Object)("Total execution time = " + (double)(System.currentTimeMillis() - time1) / 1000.0 + "(s)........................."));
            }
        }
    }

    public boolean shouldProceedToUpgrade(String previousVersion, String newVersion) {
        return true;
    }
}

