/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecms.upgrade.plugins;

import java.util.HashMap;
import java.util.List;
import javax.jcr.Node;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cms.JcrInputProperty;
import org.exoplatform.services.cms.actions.ActionServiceContainer;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class FavoriteActionUpgradePlugin
extends UpgradeProductPlugin {
    private Log log = ExoLogger.getLogger(((Object)((Object)this)).getClass());
    private static final String FAVORITE_ALIAS = "userPrivateFavorites";
    private static final String ADD_TO_FAVORITE_ACTION = "addToFavorite";
    private ActionServiceContainer actionServiceContainer;
    private TemplateService templateService;
    private NodeHierarchyCreator nodeHierarchyCreator;
    private OrganizationService organizationService;

    public FavoriteActionUpgradePlugin(ActionServiceContainer actionServiceContainer, TemplateService templateService, NodeHierarchyCreator nodeHierarchyCreator, OrganizationService organizationService, InitParams initParams) {
        super(initParams);
        this.nodeHierarchyCreator = nodeHierarchyCreator;
        this.organizationService = organizationService;
        this.actionServiceContainer = actionServiceContainer;
        this.templateService = templateService;
    }

    public boolean shouldProceedToUpgrade(String previousVersion, String newVersion) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUpgrade(String oldVersion, String newVersion) {
        try {
            this.log.info((Object)("Start " + ((Object)((Object)this)).getClass().getName() + "............."));
            RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
            SessionProvider sessionProvider = WCMCoreUtils.getSystemSessionProvider();
            ListAccess userListAccess = this.organizationService.getUserHandler().findAllUsers();
            List userList = WCMCoreUtils.getAllElementsOfListAccess((ListAccess)userListAccess);
            for (User user : userList) {
                String favoritePath;
                Node userNode = this.nodeHierarchyCreator.getUserNode(sessionProvider, user.getUserName());
                Node favoriteNode = userNode.getNode(favoritePath = this.nodeHierarchyCreator.getJcrPath(FAVORITE_ALIAS));
                if (this.actionServiceContainer.getAction(favoriteNode, ADD_TO_FAVORITE_ACTION) != null) continue;
                this.applyAddToFavoriteAction(favoriteNode);
            }
            this.log.info((Object)("End " + ((Object)((Object)this)).getClass().getName() + "............."));
        }
        catch (Exception e) {
            this.log.error((Object)(((Object)((Object)this)).getClass().getName() + " failed:"), (Throwable)e);
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    private void applyAddToFavoriteAction(Node favoriteNode) throws Exception {
        HashMap<String, JcrInputProperty> mappings = new HashMap<String, JcrInputProperty>();
        JcrInputProperty nodeTypeInputProperty = new JcrInputProperty();
        nodeTypeInputProperty.setJcrPath("/node");
        nodeTypeInputProperty.setValue((Object)ADD_TO_FAVORITE_ACTION);
        mappings.put("/node", nodeTypeInputProperty);
        JcrInputProperty nameInputProperty = new JcrInputProperty();
        nameInputProperty.setJcrPath("/node/exo:name");
        nameInputProperty.setValue((Object)ADD_TO_FAVORITE_ACTION);
        mappings.put("/node/exo:name", nameInputProperty);
        JcrInputProperty lifeCycleInputProperty = new JcrInputProperty();
        lifeCycleInputProperty.setJcrPath("/node/exo:lifecyclePhase");
        lifeCycleInputProperty.setValue((Object)new String[]{"node_added"});
        mappings.put("/node/exo:lifecyclePhase", lifeCycleInputProperty);
        JcrInputProperty deepInputProperty = new JcrInputProperty();
        deepInputProperty.setJcrPath("/node/exo:isDeep");
        deepInputProperty.setValue((Object)true);
        mappings.put("/node/exo:isDeep", deepInputProperty);
        JcrInputProperty descriptionInputProperty = new JcrInputProperty();
        descriptionInputProperty.setJcrPath("/node/exo:description");
        descriptionInputProperty.setValue((Object)"auto Add favorite when new document node created at favorite");
        mappings.put("/node/exo:description", descriptionInputProperty);
        this.actionServiceContainer.addAction(favoriteNode, "exo:addToFavoriteAction", mappings);
        Node actionNode = this.actionServiceContainer.getAction(favoriteNode, ADD_TO_FAVORITE_ACTION);
        actionNode.addMixin("mix:affectedNodeTypes");
        actionNode.setProperty("exo:affectedNodeTypeNames", this.templateService.getAllDocumentNodeTypes().toArray(new String[0]));
        actionNode.save();
    }
}

