/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.upgrade;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.services.cms.metadata.MetadataService;
import org.exoplatform.services.cms.metadata.impl.MetadataServiceImpl;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.cms.templates.impl.TemplateServiceImpl;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;

public class NodeTypeTemplateMigrationService
implements Startable {
    private static final Log LOG = ExoLogger.getLogger((String)NodeTypeTemplateMigrationService.class.getName());
    private RepositoryService repoService_;
    private TemplateService templateService_;
    private MetadataService metadataService_;

    public NodeTypeTemplateMigrationService(RepositoryService repositoryService, TemplateService templateService, MetadataService metadataService) {
        this.repoService_ = repositoryService;
        this.templateService_ = templateService;
        this.metadataService_ = metadataService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        String migratedNodeTypes;
        block17: {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Start " + this.getClass().getName() + "............."));
            }
            migratedNodeTypes = null;
            try {
                Properties prop = new Properties();
                InputStream in = this.getClass().getResourceAsStream("/conf/emcs-upgrade.properties");
                prop.load(in);
                migratedNodeTypes = prop.getProperty("migrate-nodetype-templates");
                in.close();
            }
            catch (IOException e) {
                if (!LOG.isErrorEnabled()) break block17;
                LOG.error((Object)"An unexpected problem occurs when loading nodetype templates from properties file");
            }
        }
        if (StringUtils.isEmpty(migratedNodeTypes)) {
            return;
        }
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        try {
            ManageableRepository repository = this.repoService_.getCurrentRepository();
            HashSet<String> migratedNodeTypeSet = new HashSet<String>();
            ArrayList<Node> removedNodes = new ArrayList<Node>();
            ArrayList<String> removedMetadataNodes = new ArrayList<String>();
            List configuredNodeTypeSet = this.templateService_.getAllDocumentNodeTypes(repository.getConfiguration().getName());
            List configuredMetadataNodeTypeSet = this.metadataService_.getMetadataList(repository.getConfiguration().getName());
            for (String migratedNodeType : migratedNodeTypes.split(",")) {
                migratedNodeTypeSet.add(migratedNodeType.trim());
            }
            Node templateHomeNode = this.templateService_.getTemplatesHome(repository.getConfiguration().getName(), sessionProvider);
            NodeIterator iter = templateHomeNode.getNodes();
            while (iter.hasNext()) {
                Node templateNode = iter.nextNode();
                if (!configuredNodeTypeSet.contains(templateNode.getName()) || !migratedNodeTypeSet.contains(templateNode.getName())) continue;
                removedNodes.add(templateNode);
            }
            for (String migratedNodeType : migratedNodeTypeSet) {
                if (!configuredMetadataNodeTypeSet.contains(migratedNodeType)) continue;
                removedMetadataNodes.add(migratedNodeType);
            }
            for (Node removedNode : removedNodes) {
                try {
                    removedNode.remove();
                    templateHomeNode.save();
                }
                catch (Exception e) {
                    if (!LOG.isErrorEnabled() || !LOG.isErrorEnabled()) continue;
                    LOG.error((Object)"An unexpected problem occurs when migrating templates to new structure", (Throwable)e);
                }
            }
            for (String removedMetadaNode : removedMetadataNodes) {
                this.metadataService_.removeMetadata(removedMetadaNode, repository.getConfiguration().getName());
            }
            ((TemplateServiceImpl)this.templateService_).start();
            ((MetadataServiceImpl)this.metadataService_).start();
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"An unexpected problem occurs when migrating templates to new structure", (Throwable)e);
            }
        }
        finally {
            sessionProvider.close();
        }
    }

    public void stop() {
    }
}

