/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.persist.spi;

public class Complex {
    private final Object _first;
    private final Object _second;
    private final Object[] _all;
    private final int _size;
    private int _hashCode;

    public Complex(Object o) {
        this._size = 1;
        this._first = o;
        this._second = null;
        this._all = null;
        this._hashCode = this._first.hashCode();
    }

    public Complex(int length, Object[] o) {
        this._size = length;
        if (length == 1) {
            this._first = o[0];
            this._second = null;
            this._all = null;
            this._hashCode = this._first == null ? 0 : this._first.hashCode();
        } else if (length == 2) {
            this._first = o[0];
            this._second = o[1];
            this._all = null;
            this._hashCode = this._first == null ? 0 : this._first.hashCode();
            this._hashCode += this._second == null ? 0 : this._second.hashCode();
        } else if (length <= o.length && length > 0) {
            this._first = null;
            this._second = null;
            this._all = new Object[this._size];
            System.arraycopy(o, 0, this._all, 0, this._size);
            this._hashCode = 0;
            int i = 1;
            while (i < this._size) {
                this._hashCode += this._all[i] == null ? 0 : this._all[i].hashCode();
                ++i;
            }
        } else {
            throw new IllegalArgumentException("Invalid Complex object");
        }
    }

    public Complex(Object o1, Object o2) {
        this._size = 2;
        this._first = o1;
        this._second = o2;
        this._all = null;
        this._hashCode = this._first == null ? 0 : this._first.hashCode();
        this._hashCode += this._second == null ? 0 : this._second.hashCode();
    }

    public Complex(Object[] o) {
        if (o == null || o.length == 0) {
            throw new NullPointerException();
        }
        if (o.length == 1) {
            this._size = 1;
            this._first = o[0];
            this._second = null;
            this._all = null;
            this._hashCode = this._first.hashCode();
        } else if (o.length == 2) {
            this._size = 2;
            this._first = o[0];
            this._second = o[1];
            this._all = null;
            this._hashCode = this._first.hashCode();
            this._hashCode += this._second == null ? 0 : this._second.hashCode();
        } else {
            this._size = o.length;
            this._first = null;
            this._second = null;
            this._all = new Object[this._size];
            System.arraycopy(o, 0, this._all, 0, this._size);
            this._hashCode = 0;
            int i = 1;
            while (i < this._size) {
                this._hashCode += this._all[i] == null ? 0 : this._all[i].hashCode();
                ++i;
            }
        }
    }

    public Complex(Complex complex) {
        if (complex == null || complex.size() == 0) {
            throw new NullPointerException();
        }
        int dim = complex.size();
        if (dim == 1) {
            this._size = 1;
            this._first = complex.get(0);
            this._second = null;
            this._all = null;
            this._hashCode = this._first.hashCode();
        } else if (dim == 2) {
            this._first = complex.get(0);
            this._second = complex.get(1);
            this._all = null;
            this._size = 2;
            this._hashCode = this._first.hashCode();
            this._hashCode += this._second == null ? 0 : this._second.hashCode();
        } else {
            this._size = dim;
            this._first = null;
            this._second = null;
            this._all = new Object[this._size];
            System.arraycopy(complex, 0, this._all, 0, this._size);
            this._hashCode = 0;
            int i = 1;
            while (i < this._size) {
                this._hashCode += this._all[i] == null ? 0 : this._all[i].hashCode();
                ++i;
            }
        }
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof Complex)) {
            return false;
        }
        Complex comp = (Complex)other;
        if (comp.size() != this._size) {
            return false;
        }
        int i = 0;
        while (i < this._size) {
            if (this.get(i) == null ? comp.get(i) != null : !this.get(i).equals(comp.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int size() {
        return this._size;
    }

    public boolean hasSomePartsNull() {
        int i = 0;
        while (i < this._size) {
            if (this.get(i) == null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int hashCode() {
        return this._hashCode;
    }

    public Object get(int i) {
        if (i >= this._size && i < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (this._size <= 2) {
            if (i == 0) {
                return this._first;
            }
            return this._second;
        }
        return this._all[i];
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<");
        int i = 0;
        while (i < this._size) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append(this.get(i));
            sb.append("(" + this.get(i).hashCode() + ")");
            ++i;
        }
        sb.append(">");
        return sb.toString();
    }
}

