/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.drivers;

import java.util.Enumeration;
import java.util.Vector;
import org.exolab.castor.jdo.drivers.JDBCQueryExpression;
import org.exolab.castor.persist.spi.PersistenceFactory;

public final class InformixQueryExpression
extends JDBCQueryExpression {
    public InformixQueryExpression(PersistenceFactory factory) {
        super(factory);
    }

    public String getStatement(boolean lock) {
        StringBuffer sql = new StringBuffer(128);
        this.addSelectClause(sql);
        this.addFromClause(sql);
        boolean first = this.addJoinClause(sql);
        this.addWhereClause(sql, first);
        this.addOrderByClause(sql);
        this.addForUpdateClause(sql, lock);
        return sql.toString();
    }

    private void addSelectClause(StringBuffer buffer) {
        buffer.append("SELECT ");
        if (this._distinct) {
            buffer.append(" DISTINCT ");
        }
        buffer.append(this.getColumnList());
    }

    private void addFromClause(StringBuffer buffer) {
        buffer.append(" FROM ");
        Enumeration tables = this.getFromTables();
        while (tables.hasMoreElements()) {
            buffer.append((String)tables.nextElement());
            if (!tables.hasMoreElements()) continue;
            buffer.append(",");
        }
    }

    private Enumeration getFromTables() {
        Vector<String> vector = new Vector<String>();
        Vector outerTables = this.getOuterTables();
        Object table = null;
        Enumeration enumeration = this._tables.keys();
        while (enumeration.hasMoreElements()) {
            String tableAlias = (String)enumeration.nextElement();
            String tableName = (String)this._tables.get(tableAlias);
            StringBuffer tmp = outerTables.contains(tableAlias) ? new StringBuffer("OUTER ") : new StringBuffer();
            if (tableAlias.equals(tableName)) {
                tmp.append(this._factory.quoteName(tableName));
            } else {
                tmp.append(this._factory.quoteName(tableName) + " " + this._factory.quoteName(tableAlias));
            }
            vector.addElement(this._factory.quoteName(tmp.toString()));
        }
        return vector.elements();
    }

    private Vector getOuterTables() {
        Vector<String> tables = new Vector<String>();
        JDBCQueryExpression.Join join = null;
        int i = 0;
        while (i < this._joins.size()) {
            join = (JDBCQueryExpression.Join)this._joins.elementAt(i);
            if (join.outer) {
                tables.addElement(join.rightTable);
            }
            ++i;
        }
        return tables;
    }

    private boolean addJoinClause(StringBuffer buffer) {
        boolean first = true;
        int i = 0;
        while (i < this._joins.size()) {
            if (first) {
                buffer.append(" WHERE ");
                first = false;
            } else {
                buffer.append(" AND ");
            }
            this.addJoin(buffer, (JDBCQueryExpression.Join)this._joins.elementAt(i));
            ++i;
        }
        return first;
    }

    private void addJoin(StringBuffer buffer, JDBCQueryExpression.Join join) {
        int j = 0;
        while (j < join.leftColumns.length) {
            if (j > 0) {
                buffer.append(" AND ");
            }
            buffer.append(this.quoteTableAndColumn(join.leftTable, join.leftColumns[j]));
            buffer.append("=");
            buffer.append(this.quoteTableAndColumn(join.rightTable, join.rightColumns[j]));
            ++j;
        }
    }

    private String quoteTableAndColumn(String table, String column) {
        return this._factory.quoteName(table + "." + column);
    }

    private void addOrderByClause(StringBuffer buffer) {
        if (this._order != null) {
            buffer.append(" ORDER BY ").append(this._order);
        }
    }

    private void addForUpdateClause(StringBuffer buffer, boolean lock) {
        if (lock) {
            buffer.append(" FOR UPDATE");
        }
    }
}

