/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javadoc;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ConstructorDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.SourcePosition;
import com.sun.tools.javac.v8.code.Scope;
import com.sun.tools.javac.v8.code.Symbol;
import com.sun.tools.javac.v8.code.Type;
import com.sun.tools.javac.v8.comp.Env;
import com.sun.tools.javac.v8.tree.Tree;
import com.sun.tools.javac.v8.tree.TreeInfo;
import com.sun.tools.javac.v8.util.List;
import com.sun.tools.javac.v8.util.ListBuffer;
import com.sun.tools.javac.v8.util.Name;
import com.sun.tools.javadoc.ConstructorDocImpl;
import com.sun.tools.javadoc.DocEnv;
import com.sun.tools.javadoc.FieldDocImpl;
import com.sun.tools.javadoc.MethodDocImpl;
import com.sun.tools.javadoc.PackageDocImpl;
import com.sun.tools.javadoc.ProgramElementDocImpl;
import com.sun.tools.javadoc.SerializedForm;
import com.sun.tools.javadoc.SourcePositionImpl;
import com.sun.tools.javadoc.TypeMaker;
import java.io.File;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Set;

public class ClassDocImpl
extends ProgramElementDocImpl
implements ClassDoc {
    protected final Type.ClassType type;
    protected final Symbol.ClassSymbol tsym;
    Tree.ClassDef tree = null;
    boolean isIncluded = false;
    private SerializedForm serializedForm;

    public int modifierSpecifier() {
        int n = this.getModifiers();
        return this.isInterface() ? n & 0xFFFFFBFF : n;
    }

    protected long getFlags() {
        while (true) {
            try {
                return this.tsym.flags();
            }
            catch (Symbol.CompletionFailure completionFailure) {
                continue;
            }
            break;
        }
    }

    public boolean definesSerializableFields() {
        if (!this.isSerializable() || this.isExternalizable()) {
            return false;
        }
        if (this.serializedForm == null) {
            this.serializedForm = new SerializedForm(this.env, this.tsym, this);
        }
        return this.serializedForm.definesSerializableFields();
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.getModifiers());
    }

    public boolean isArrayType() {
        return false;
    }

    public boolean isClass() {
        return !Modifier.isInterface(this.getModifiers());
    }

    public boolean isError() {
        if (Modifier.isInterface(this.getModifiers())) {
            return false;
        }
        Type type = this.type;
        while (type.tag == 10) {
            if (type.tsym == this.env.syms.errorType.tsym) {
                return true;
            }
            type = ((Type)type).supertype();
        }
        return false;
    }

    public boolean isException() {
        if (Modifier.isInterface(this.getModifiers())) {
            return false;
        }
        Type type = this.type;
        while (type.tag == 10) {
            if (type.tsym == this.env.syms.exceptionType.tsym) {
                return true;
            }
            type = ((Type)type).supertype();
        }
        return false;
    }

    public boolean isExternalizable() {
        try {
            return this.type.isSubType(this.env.externalizableSym.type);
        }
        catch (Symbol.CompletionFailure completionFailure) {
            return false;
        }
    }

    public boolean isIncluded() {
        if (this.isIncluded) {
            return true;
        }
        if (this.tsym.type != this.type) {
            return false;
        }
        if (this.env.shouldDocument(this.tsym)) {
            if (this.containingPackage().isIncluded()) {
                this.isIncluded = true;
                return true;
            }
            ClassDoc classDoc = this.containingClass();
            if (classDoc != null && classDoc.isIncluded()) {
                this.isIncluded = true;
                return true;
            }
        }
        return false;
    }

    public boolean isInterface() {
        return Modifier.isInterface(this.getModifiers());
    }

    public boolean isOrdinaryClass() {
        if (Modifier.isInterface(this.getModifiers())) {
            return false;
        }
        Type type = this.type;
        while (type.tag == 10) {
            if (type.tsym == this.env.syms.errorType.tsym || type.tsym == this.env.syms.exceptionType.tsym) {
                return false;
            }
            type = ((Type)type).supertype();
        }
        return true;
    }

    public boolean isPrimitiveJavaType() {
        return false;
    }

    boolean isRuntimeException() {
        return this.tsym.isSubClass(this.env.syms.runtimeExceptionType.tsym);
    }

    public boolean isSerializable() {
        try {
            return this.type.isSubType(this.env.syms.serializableType);
        }
        catch (Symbol.CompletionFailure completionFailure) {
            return false;
        }
    }

    public boolean isSynthetic() {
        return (this.getFlags() & 0x10000L) != 0L;
    }

    public boolean isThrowable() {
        if (Modifier.isInterface(this.getModifiers())) {
            return false;
        }
        Type type = this.type;
        while (type.tag == 10) {
            if (type.tsym == this.env.syms.throwableType.tsym) {
                return true;
            }
            type = ((Type)type).supertype();
        }
        return false;
    }

    public ClassDoc asClassDoc() {
        return this;
    }

    public ClassDoc superclass() {
        if (this.isInterface()) {
            return null;
        }
        if (this.tsym == this.env.syms.objectType.tsym) {
            return null;
        }
        Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)this.type.supertype().tsym;
        if (classSymbol == null) {
            classSymbol = (Symbol.ClassSymbol)this.env.syms.objectType.tsym;
        }
        return this.env.getClassDoc(classSymbol);
    }

    public ClassDoc[] importedClasses() {
        if (this.tsym.sourcefile == null) {
            return new ClassDoc[0];
        }
        ListBuffer listBuffer = new ListBuffer();
        Env env = this.env.enter.getEnv(this.tsym);
        if (env == null) {
            return new ClassDocImpl[0];
        }
        Name name = this.tsym.name.table.asterisk;
        List list = env.toplevel.defs;
        while (list.nonEmpty()) {
            Tree tree;
            Tree tree2 = (Tree)list.head;
            if (tree2.tag == 2 && TreeInfo.name(tree = ((Tree.Import)tree2).qualid) != name) {
                listBuffer.append(this.env.getClassDoc((Symbol.ClassSymbol)tree.type.tsym));
            }
            list = list.tail;
        }
        return (ClassDoc[])listBuffer.toArray(new ClassDocImpl[listBuffer.length()]);
    }

    public ClassDoc[] innerClasses() {
        return this.innerClasses(true);
    }

    public ClassDoc[] interfaces() {
        ListBuffer listBuffer = new ListBuffer();
        List list = this.type.interfaces();
        while (list.nonEmpty()) {
            listBuffer.append(this.env.getClassDoc((Symbol.ClassSymbol)((Type.ClassType)list.head).tsym));
            list = list.tail;
        }
        return (ClassDoc[])listBuffer.toArray(new ClassDocImpl[listBuffer.length()]);
    }

    public boolean subclassOf(ClassDoc classDoc) {
        return this.tsym.isSubClass(((ClassDocImpl)classDoc).tsym);
    }

    public ClassDoc[] innerClasses(boolean bl) {
        ListBuffer listBuffer = new ListBuffer();
        Scope.Entry entry = this.tsym.members().elems;
        while (entry != null) {
            if (entry.sym != null && entry.sym.kind == 2) {
                Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)entry.sym;
                if ((classSymbol.flags_field & 0x10000L) == 0L && (!bl || this.env.isVisible(classSymbol))) {
                    listBuffer.prepend(this.env.getClassDoc(classSymbol));
                }
            }
            entry = entry.sibling;
        }
        return (ClassDoc[])listBuffer.toArray(new ClassDocImpl[listBuffer.length()]);
    }

    public ConstructorDoc[] constructors() {
        return this.constructors(true);
    }

    public ConstructorDoc[] constructors(boolean bl) {
        Name.Table table = this.tsym.name.table;
        List list = new List();
        Scope.Entry entry = this.tsym.members().elems;
        while (entry != null) {
            if (entry.sym != null && entry.sym.kind == 16 && entry.sym.name == table.init) {
                Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)entry.sym;
                if (!bl || this.env.shouldDocument(methodSymbol)) {
                    list = list.prepend(this.env.getConstructorDoc(methodSymbol));
                }
            }
            entry = entry.sibling;
        }
        return (ConstructorDoc[])list.toArray(new ConstructorDocImpl[list.length()]);
    }

    public FieldDoc[] fields() {
        return this.fields(true);
    }

    public FieldDoc[] serializableFields() {
        if (this.serializedForm == null) {
            this.serializedForm = new SerializedForm(this.env, this.tsym, this);
        }
        return this.serializedForm.fields();
    }

    public FieldDoc[] fields(boolean bl) {
        List list = new List();
        Scope.Entry entry = this.tsym.members().elems;
        while (entry != null) {
            if (entry.sym != null && entry.sym.kind == 4) {
                Symbol.VarSymbol varSymbol = (Symbol.VarSymbol)entry.sym;
                if (!bl || this.env.shouldDocument(varSymbol)) {
                    list = list.prepend(this.env.getFieldDoc(varSymbol));
                }
            }
            entry = entry.sibling;
        }
        return (FieldDoc[])list.toArray(new FieldDocImpl[list.length()]);
    }

    public MethodDoc[] methods() {
        return this.methods(true);
    }

    public MethodDoc[] serializationMethods() {
        if (this.serializedForm == null) {
            this.serializedForm = new SerializedForm(this.env, this.tsym, this);
        }
        return this.serializedForm.methods();
    }

    public MethodDoc[] methods(boolean bl) {
        Name.Table table = this.tsym.name.table;
        List list = new List();
        Scope.Entry entry = this.tsym.members().elems;
        while (entry != null) {
            if (entry.sym != null && entry.sym.kind == 16 && entry.sym.name != table.init) {
                Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)entry.sym;
                if (!bl || this.env.shouldDocument(methodSymbol)) {
                    list = list.prepend(this.env.getMethodDoc(methodSymbol));
                }
            }
            entry = entry.sibling;
        }
        return (MethodDoc[])list.toArray(new MethodDocImpl[list.length()]);
    }

    public PackageDoc containingPackage() {
        File file;
        PackageDocImpl packageDocImpl = this.env.getPackageDoc(this.tsym.packge());
        SourcePosition sourcePosition = this.position();
        if (sourcePosition != null && packageDocImpl.docPath == null && packageDocImpl.zipDocPath == null && (file = sourcePosition.file().getParentFile()) != null && new File(file, "package.html").exists()) {
            packageDocImpl.setDocPath(file.getPath());
        }
        return packageDocImpl;
    }

    public PackageDoc[] importedPackages() {
        if (this.tsym.sourcefile == null) {
            return new PackageDoc[0];
        }
        ListBuffer listBuffer = new ListBuffer();
        Name.Table table = this.tsym.name.table;
        listBuffer.append(this.env.getPackageDoc(this.env.reader.enterPackage(table.java_lang)));
        Env env = this.env.enter.getEnv(this.tsym);
        if (env == null) {
            return new PackageDocImpl[0];
        }
        List list = env.toplevel.defs;
        while (list.nonEmpty()) {
            Tree tree;
            Tree tree2 = (Tree)list.head;
            if (tree2.tag == 2 && TreeInfo.name(tree = ((Tree.Import)tree2).qualid) == table.asterisk) {
                Tree.Select select = (Tree.Select)tree;
                Symbol.TypeSymbol typeSymbol = select.selected.type.tsym;
                PackageDocImpl packageDocImpl = this.env.getPackageDoc(typeSymbol.packge());
                if (!listBuffer.contains(packageDocImpl)) {
                    listBuffer.append(packageDocImpl);
                }
            }
            list = list.tail;
        }
        return (PackageDoc[])listBuffer.toArray(new PackageDocImpl[listBuffer.length()]);
    }

    public SourcePosition position() {
        if (this.tsym.sourcefile == null) {
            return null;
        }
        return SourcePositionImpl.make(this.tsym.sourcefile.toString(), this.tree == null ? 0 : this.tree.pos);
    }

    protected Symbol.ClassSymbol getContainingClass() {
        return this.tsym.owner.enclClass();
    }

    void addAllClasses(ListBuffer listBuffer, boolean bl) {
        if (this.tsym.type != this.type) {
            return;
        }
        try {
            if (this.isSynthetic()) {
                return;
            }
            if (bl && !this.env.shouldDocument(this.tsym)) {
                return;
            }
            if (listBuffer.contains(this)) {
                return;
            }
            listBuffer.append(this);
            List list = new List();
            Scope.Entry entry = this.tsym.members().elems;
            while (entry != null) {
                Symbol.ClassSymbol classSymbol;
                ClassDocImpl classDocImpl;
                if (entry.sym != null && entry.sym.kind == 2 && !(classDocImpl = this.env.getClassDoc(classSymbol = (Symbol.ClassSymbol)entry.sym)).isSynthetic() && classDocImpl != null) {
                    list = list.prepend(classDocImpl);
                }
                entry = entry.sibling;
            }
            while (list.nonEmpty()) {
                ((ClassDocImpl)list.head).addAllClasses(listBuffer, bl);
                list = list.tail;
            }
        }
        catch (Symbol.CompletionFailure completionFailure) {
            // empty catch block
        }
    }

    public String dimension() {
        return "";
    }

    private String genericArgs() {
        return this.type.typarams().nonEmpty() ? "<" + this.type.typarams() + ">" : "";
    }

    public String modifiers() {
        return Modifier.toString(this.modifierSpecifier());
    }

    public String name() {
        String string = this.tsym.name.toString();
        Symbol.ClassSymbol classSymbol = this.tsym.owner.enclClass();
        while (classSymbol != null) {
            string = classSymbol.name.toString() + "." + string;
            classSymbol = classSymbol.owner.enclClass();
        }
        return string + this.genericArgs();
    }

    public String qualifiedName() {
        return this.tsym.fullName().toString() + this.genericArgs();
    }

    public String qualifiedTypeName() {
        return this.qualifiedName();
    }

    public String typeName() {
        return this.name();
    }

    public ClassDoc findClass(String string) {
        Object object;
        Name.Table table = this.tsym.name.table;
        ClassDoc classDoc = this.env.lookupClass(string);
        if (classDoc != null) {
            return classDoc;
        }
        ClassDoc[] classDocArray = this.innerClasses();
        for (int i = 0; i < classDocArray.length; ++i) {
            if (classDocArray[i].name().equals(string) || classDocArray[i].name().endsWith(string)) {
                return classDocArray[i];
            }
            object = classDocArray[i].findClass(string);
            if (object == null) continue;
            return object;
        }
        classDoc = this.containingPackage().findClass(string);
        if (classDoc != null) {
            return classDoc;
        }
        if (this.tsym.completer != null) {
            this.tsym.complete();
        }
        if (this.tsym.sourcefile != null) {
            ClassDocImpl classDocImpl;
            Env env = this.env.enter.getEnv(this.tsym);
            if (env == null) {
                return null;
            }
            object = env.toplevel.namedImportScope;
            Scope.Entry entry = ((Scope)object).lookup(table.fromString(string));
            while (entry != null) {
                if (entry.sym != null && entry.sym.kind == 2 && (classDocImpl = this.env.getClassDoc((Symbol.ClassSymbol)entry.sym)).name().equals(string)) {
                    return classDocImpl;
                }
                entry = entry.shadowed;
            }
            object = env.toplevel.starImportScope;
            entry = ((Scope)object).lookup(table.fromString(string));
            while (entry != null) {
                if (entry.sym != null && entry.sym.kind == 2 && (classDocImpl = this.env.getClassDoc((Symbol.ClassSymbol)entry.sym)).name().equals(string)) {
                    return classDocImpl;
                }
                entry = entry.shadowed;
            }
        }
        return null;
    }

    public FieldDoc findField(String string) {
        return this.searchField(string, new HashSet());
    }

    public ClassDocImpl(DocEnv docEnv, Symbol.ClassSymbol classSymbol) {
        this(docEnv, classSymbol, null, null);
    }

    public ClassDocImpl(DocEnv docEnv, Type.ClassType classType) {
        super(docEnv, null);
        this.type = classType;
        this.tsym = (Symbol.ClassSymbol)classType.tsym;
    }

    private boolean hasParameterTypes(Symbol.MethodSymbol methodSymbol, String[] stringArray) {
        if (stringArray == null) {
            return true;
        }
        int n = 0;
        List list = methodSymbol.type.argtypes();
        if (stringArray.length != list.length()) {
            return false;
        }
        while (list.nonEmpty()) {
            if (!ClassDocImpl.hasTypeName((Type)list.head, stringArray[n])) {
                return false;
            }
            ++n;
            list = list.tail;
        }
        return true;
    }

    private static boolean hasTypeName(Type type, String string) {
        return string.equals(TypeMaker.getTypeName(type, true)) || string.equals(TypeMaker.getTypeName(type, false));
    }

    public ConstructorDoc findConstructor(String string, String[] stringArray) {
        Name.Table table = this.tsym.name.table;
        Scope.Entry entry = this.tsym.members().lookup(table.fromString("<init>"));
        while (entry != null) {
            if (entry.sym != null && entry.sym.kind == 16 && entry.sym.name == table.init && this.hasParameterTypes((Symbol.MethodSymbol)entry.sym, stringArray) && this.env.shouldDocument((Symbol.MethodSymbol)entry.sym)) {
                return this.env.getConstructorDoc((Symbol.MethodSymbol)entry.sym);
            }
            entry = entry.shadowed;
        }
        return null;
    }

    private FieldDocImpl searchField(String string, Set set) {
        Object object;
        Name.Table table = this.tsym.name.table;
        if (set.contains(this)) {
            return null;
        }
        set.add(this);
        Object object2 = this.tsym.members().lookup(table.fromString(string));
        while (object2 != null) {
            if (((Scope.Entry)object2).sym != null && ((Scope.Entry)object2).sym.kind == 4 && ((Scope.Entry)object2).sym.name.toString().equals(string) && this.env.shouldDocument((Symbol.VarSymbol)((Scope.Entry)object2).sym)) {
                return this.env.getFieldDoc((Symbol.VarSymbol)((Scope.Entry)object2).sym);
            }
            object2 = ((Scope.Entry)object2).shadowed;
        }
        object2 = (ClassDocImpl)this.containingClass();
        if (object2 != null && (object = super.searchField(string, set)) != null) {
            return object;
        }
        object2 = (ClassDocImpl)this.superclass();
        if (object2 != null && (object = super.searchField(string, set)) != null) {
            return object;
        }
        object = this.interfaces();
        for (int i = 0; i < ((ClassDoc[])object).length; ++i) {
            object2 = (ClassDocImpl)object[i];
            FieldDocImpl fieldDocImpl = super.searchField(string, set);
            if (fieldDocImpl == null) continue;
            return fieldDocImpl;
        }
        return null;
    }

    public MethodDocImpl findMethod(String string, String[] stringArray) {
        return this.searchMethod(string, stringArray, new HashSet());
    }

    public ClassDocImpl(DocEnv docEnv, Symbol.ClassSymbol classSymbol, String string, Tree.ClassDef classDef) {
        super(docEnv, string);
        this.type = (Type.ClassType)classSymbol.type;
        this.tsym = classSymbol;
        this.tree = classDef;
    }

    private MethodDocImpl searchMethod(String string, String[] stringArray, Set set) {
        MethodDocImpl methodDocImpl;
        ClassDocImpl classDocImpl;
        Object object;
        if (set.contains(this)) {
            return null;
        }
        set.add(this);
        Name.Table table = this.tsym.name.table;
        Scope.Entry entry = this.tsym.members().lookup(table.fromString(string));
        if (stringArray == null) {
            object = null;
            while (entry != null) {
                if (entry.sym != null && entry.sym.kind == 16 && entry.sym.name != table.init && entry.sym.name.toString().equals(string) && this.env.shouldDocument((Symbol.MethodSymbol)entry.sym)) {
                    object = (Symbol.MethodSymbol)entry.sym;
                }
                entry = entry.shadowed;
            }
            if (object != null) {
                return this.env.getMethodDoc((Symbol.MethodSymbol)object);
            }
        } else {
            while (entry != null) {
                if (entry.sym != null && entry.sym.kind == 16 && entry.sym.name != table.init && entry.sym.name.toString().equals(string) && this.hasParameterTypes((Symbol.MethodSymbol)entry.sym, stringArray) && this.env.shouldDocument((Symbol.MethodSymbol)entry.sym)) {
                    return this.env.getMethodDoc((Symbol.MethodSymbol)entry.sym);
                }
                entry = entry.shadowed;
            }
        }
        if ((classDocImpl = (ClassDocImpl)this.superclass()) != null && (methodDocImpl = classDocImpl.searchMethod(string, stringArray, set)) != null) {
            return methodDocImpl;
        }
        object = this.interfaces();
        for (int i = 0; i < ((ClassDoc[])object).length; ++i) {
            classDocImpl = (ClassDocImpl)object[i];
            methodDocImpl = classDocImpl.searchMethod(string, stringArray, set);
            if (methodDocImpl == null) continue;
            return methodDocImpl;
        }
        classDocImpl = (ClassDocImpl)this.containingClass();
        if (classDocImpl != null && (methodDocImpl = classDocImpl.searchMethod(string, stringArray, set)) != null) {
            return methodDocImpl;
        }
        return null;
    }
}

