/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.LongValue;
import com.sun.jdi.Type;
import com.sun.jdi.VirtualMachine;
import com.sun.tools.jdi.PrimitiveValueImpl;

public class LongValueImpl
extends PrimitiveValueImpl
implements LongValue {
    private long value;

    public byte byteValue() {
        return (byte)this.value;
    }

    byte checkedByteValue() throws InvalidTypeException {
        if (this.value > 127L || this.value < -128L) {
            throw new InvalidTypeException("Can't convert " + this.value + " to byte");
        }
        return super.checkedByteValue();
    }

    byte typeValueKey() {
        return 74;
    }

    public char charValue() {
        return (char)this.value;
    }

    char checkedCharValue() throws InvalidTypeException {
        if (this.value > 65535L || this.value < 0L) {
            throw new InvalidTypeException("Can't convert " + this.value + " to char");
        }
        return super.checkedCharValue();
    }

    public double doubleValue() {
        return this.value;
    }

    public float floatValue() {
        return this.value;
    }

    int checkedIntValue() throws InvalidTypeException {
        if (this.value > Integer.MAX_VALUE || this.value < Integer.MIN_VALUE) {
            throw new InvalidTypeException("Can't convert " + this.value + " to int");
        }
        return super.checkedIntValue();
    }

    public int hashCode() {
        return this.intValue();
    }

    public int intValue() {
        return (int)this.value;
    }

    public long longValue() {
        return this.value;
    }

    public long value() {
        return this.value;
    }

    short checkedShortValue() throws InvalidTypeException {
        if (this.value > 32767L || this.value < -32768L) {
            throw new InvalidTypeException("Can't convert " + this.value + " to short");
        }
        return super.checkedShortValue();
    }

    public short shortValue() {
        return (short)this.value;
    }

    public boolean booleanValue() {
        return this.value != 0L;
    }

    public Type type() {
        return this.vm.theLongType();
    }

    LongValueImpl(VirtualMachine virtualMachine, long l) {
        super(virtualMachine);
        this.value = l;
    }

    public int compareTo(Object object) {
        long l = ((LongValue)object).value();
        if (this.value() < l) {
            return -1;
        }
        if (this.value() == l) {
            return 0;
        }
        return 1;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof LongValue) {
            return this.value == ((LongValue)object).value() && super.equals(object);
        }
        return false;
    }

    public String toString() {
        return "" + this.value;
    }
}

