/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.jabber;

import com.echomine.common.ParseException;
import com.echomine.jabber.JabberCode;
import com.echomine.jabber.JabberIQMessage;
import com.echomine.jabber.JabberMessage;
import com.echomine.jabber.JabberMessageParser;
import org.jdom.Element;

public class LastIQMessage
extends JabberIQMessage {
    private long seconds;
    private String msg;

    public LastIQMessage(String type) {
        super(type);
        this.getDOM().addContent(new Element("query", JabberCode.XMLNS_IQ_LAST));
    }

    public LastIQMessage() {
        this("get");
    }

    public JabberMessage parse(JabberMessageParser parser, Element msgTree) throws ParseException {
        super.parse(parser, msgTree);
        Element query = msgTree.getChild("query", JabberCode.XMLNS_IQ_LAST);
        if (query != null) {
            String secs = msgTree.getChild("query", JabberCode.XMLNS_IQ_LAST).getAttributeValue("seconds");
            this.msg = msgTree.getChildText("query", JabberCode.XMLNS_IQ_LAST);
            if (secs != null) {
                this.seconds = Long.parseLong(secs);
            }
        }
        return this;
    }

    public long getSeconds() {
        return this.seconds;
    }

    public String getMessage() {
        return this.msg;
    }

    public void setSeconds(long seconds) {
        this.seconds = seconds;
        this.getDOM().getChild("query", JabberCode.XMLNS_IQ_LAST).setAttribute("seconds", String.valueOf(seconds));
    }

    public int getMessageType() {
        return 17;
    }
}

