/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.net;

import com.echomine.net.ConnectionEvent;
import com.echomine.net.ConnectionFailedException;
import com.echomine.net.ConnectionModel;
import com.echomine.net.ConnectionVetoException;
import com.echomine.net.SocketHandler;
import com.echomine.net.TimeableConnection;
import com.echomine.util.IOUtil;
import java.io.IOException;
import java.net.Socket;

public class SocketConnector
extends TimeableConnection {
    private SocketHandler socketHandler;

    public SocketConnector(SocketHandler socketHandler) {
        this.socketHandler = socketHandler;
    }

    public SocketConnector() {
    }

    public void connect(ConnectionModel connectionModel) throws ConnectionFailedException {
        this.connect(this.socketHandler, connectionModel);
    }

    public void connect(SocketHandler socketHandler, ConnectionModel connectionModel) throws ConnectionFailedException {
        Socket socket = null;
        try {
            ConnectionEvent event = new ConnectionEvent(connectionModel, 4);
            ConnectionEvent vetoEvent = new ConnectionEvent(connectionModel, 5);
            this.fireConnectionStarting(event, vetoEvent);
            socketHandler.start();
            socket = new Socket(connectionModel.getHost(), connectionModel.getPort());
            try {
                try {
                    event = new ConnectionEvent(connectionModel, 1);
                    this.fireConnectionEstablished(event);
                    socketHandler.handle(socket);
                    event = new ConnectionEvent(connectionModel, 2);
                    this.fireConnectionClosed(event);
                }
                catch (IOException ex) {
                    event = new ConnectionEvent(connectionModel, 3, "Error while handling connection: " + ex.getMessage());
                    this.fireConnectionClosed(event);
                }
                Object var9_10 = null;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                IOUtil.closeSocket(socket);
                throw throwable;
            }
            IOUtil.closeSocket(socket);
        }
        catch (IOException ex) {
            ConnectionEvent event = new ConnectionEvent(connectionModel, 3, "Error connecting to host: " + ex.getMessage());
            this.fireConnectionClosed(event);
            throw new ConnectionFailedException("Cannot Connect to remote host");
        }
        catch (ConnectionVetoException ex) {
            // empty catch block
        }
    }

    public void aconnect(ConnectionModel connectionModel) {
        this.aconnect(this.socketHandler, connectionModel);
    }

    public void aconnect(SocketHandler socketHandler, ConnectionModel connectionModel) {
        Thread thread = new Thread(new _1(this, connectionModel, socketHandler));
        thread.start();
    }

    public SocketHandler getSocketHandler() {
        return this.socketHandler;
    }

    public void setSocketHandler(SocketHandler socketHandler) {
        this.socketHandler = socketHandler;
    }

    class _1
    implements Runnable {
        private final SocketConnector this$SocketConnector;
        final SocketHandler val$socketHandler;
        final ConnectionModel val$connectionModel;

        public void run() {
            Socket socket = null;
            try {
                ConnectionEvent event = new ConnectionEvent(this.val$connectionModel, 4);
                ConnectionEvent vetoEvent = new ConnectionEvent(this.val$connectionModel, 5);
                this.val$socketHandler.start();
                this.this$SocketConnector.fireConnectionStarting(event, vetoEvent);
                socket = new Socket(this.val$connectionModel.getHost(), this.val$connectionModel.getPort());
                try {
                    try {
                        event = new ConnectionEvent(this.val$connectionModel, 1);
                        this.this$SocketConnector.fireConnectionEstablished(event);
                        this.val$socketHandler.handle(socket);
                        event = new ConnectionEvent(this.val$connectionModel, 2);
                        this.this$SocketConnector.fireConnectionClosed(event);
                    }
                    catch (IOException ex) {
                        event = new ConnectionEvent(this.val$connectionModel, 3, "Error while handling connection: " + ex.getMessage());
                        this.this$SocketConnector.fireConnectionClosed(event);
                    }
                    Object var7_8 = null;
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    IOUtil.closeSocket(socket);
                    throw throwable;
                }
                IOUtil.closeSocket(socket);
            }
            catch (IOException ex) {
                ConnectionEvent event = new ConnectionEvent(this.val$connectionModel, 3, "Error..." + ex.getMessage());
                this.this$SocketConnector.fireConnectionClosed(event);
            }
            catch (ConnectionVetoException connectionVetoException) {
                // empty catch block
            }
        }

        _1(SocketConnector enclosing$instance, ConnectionModel val$connectionModel, SocketHandler val$socketHandler) {
            this.this$SocketConnector = enclosing$instance;
            this.val$connectionModel = val$connectionModel;
            this.val$socketHandler = val$socketHandler;
        }
    }
}

