/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.javasource;

import java.util.Vector;
import org.exolab.javasource.JCodeStatement;
import org.exolab.javasource.JSourceWriter;

public class JSourceCode {
    private Vector source = null;
    private short indentSize;
    private short currentIndent = this.indentSize = (short)4;

    public JSourceCode() {
        this.source = new Vector();
    }

    public JSourceCode(String sourceCode) {
        this();
        this.source.addElement(new JCodeStatement(sourceCode, this.currentIndent));
    }

    public void add(String statement) {
        JCodeStatement jcs = new JCodeStatement(statement, this.currentIndent);
        this.source.addElement(jcs);
    }

    public void add(String statement, short indentSize) {
        JCodeStatement jcs = new JCodeStatement(statement, indentSize);
        this.source.addElement(jcs);
    }

    public void addIndented(String statement) {
        this.indent();
        JCodeStatement jcs = new JCodeStatement(statement, this.currentIndent);
        this.source.addElement(jcs);
        this.unindent();
    }

    public void append(String segment) {
        if (this.source.isEmpty()) {
            this.add(segment);
        } else {
            JCodeStatement jcs = (JCodeStatement)this.source.lastElement();
            jcs.append(segment);
        }
    }

    public void clear() {
        this.source.removeAllElements();
    }

    public void copyInto(JSourceCode jsc) {
        int i = 0;
        while (i < this.source.size()) {
            jsc.addCodeStatement((JCodeStatement)this.source.elementAt(i));
            ++i;
        }
    }

    public void indent() {
        this.currentIndent = (short)(this.currentIndent + this.indentSize);
    }

    public boolean isEmpty() {
        return this.source.isEmpty();
    }

    public void print(JSourceWriter jsw) {
        int i = 0;
        while (i < this.source.size()) {
            jsw.writeln(this.source.elementAt(i).toString());
            ++i;
        }
    }

    public void unindent() {
        this.currentIndent = (short)(this.currentIndent - this.indentSize);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        String lineSeparator = System.getProperty("line.separator");
        int i = 0;
        while (i < this.source.size()) {
            sb.append(this.source.elementAt(i).toString());
            sb.append(lineSeparator);
            ++i;
        }
        return sb.toString();
    }

    private void addCodeStatement(JCodeStatement jcs) {
        short indent = (short)(jcs.getIndent() + this.currentIndent - JCodeStatement.DEFAULT_INDENTSIZE);
        this.source.addElement(new JCodeStatement(jcs.getStatement(), indent));
    }
}

