/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.drivers;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Properties;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.persist.spi.KeyGenerator;
import org.exolab.castor.persist.spi.PersistenceFactory;
import org.exolab.castor.persist.spi.QueryExpression;
import org.exolab.castor.util.Messages;

public class HighLowKeyGenerator
implements KeyGenerator {
    private static final BigDecimal ONE = new BigDecimal(1.0);
    private static final String SEQ_TABLE = "table";
    private static final String SEQ_KEY = "key-column";
    private static final String SEQ_VALUE = "value-column";
    private static final String GRAB_SIZE = "grab-size";
    private static final String SAME_CONNECTION = "same-connection";
    private static final String GLOBAL = "global";
    private final PersistenceFactory _factory;
    private final int _sqlType;
    private final String _seqTable;
    private final String _seqKey;
    private final String _seqValue;
    private int _grabSizeI;
    private boolean _sameConnection;
    private BigDecimal _grabSizeD;
    private Hashtable _lastValues = new Hashtable();
    private Hashtable _maxValues = new Hashtable();
    private boolean _global;

    public HighLowKeyGenerator(PersistenceFactory factory, Properties params, int sqlType) throws MappingException {
        this._factory = factory;
        this._sqlType = sqlType;
        if (sqlType != 4 && sqlType != 2 && sqlType != 3 && sqlType != -5) {
            throw new MappingException(Messages.format("mapping.keyGenSQLType", this.getClass().getName(), new Integer(sqlType)));
        }
        this._seqTable = params.getProperty(SEQ_TABLE);
        if (this._seqTable == null) {
            throw new MappingException(Messages.format("mapping.KeyGenParamNotSet", SEQ_TABLE, this.getClass().getName()));
        }
        this._seqKey = params.getProperty(SEQ_KEY);
        if (this._seqKey == null) {
            throw new MappingException(Messages.format("mapping.KeyGenParamNotSet", SEQ_KEY, this.getClass().getName()));
        }
        this._seqValue = params.getProperty(SEQ_VALUE);
        if (this._seqValue == null) {
            throw new MappingException(Messages.format("mapping.KeyGenParamNotSet", SEQ_VALUE, this.getClass().getName()));
        }
        String factorStr = params.getProperty(GRAB_SIZE, "10");
        try {
            this._grabSizeI = Integer.parseInt(factorStr);
        }
        catch (NumberFormatException except) {
            this._grabSizeI = 0;
        }
        if (this._grabSizeI <= 0) {
            throw new MappingException(Messages.format("mapping.wrongKeyGenParam", factorStr, GRAB_SIZE, this.getClass().getName()));
        }
        this._grabSizeD = new BigDecimal((double)this._grabSizeI);
        this._sameConnection = "true".equals(params.getProperty(SAME_CONNECTION));
        this._global = "true".equals(params.getProperty(GLOBAL));
    }

    /*
     * Loose catch block
     */
    public synchronized Object generateKey(Connection conn, String tableName, String primKeyName, Properties props) throws PersistenceException {
        boolean inRange;
        Object max;
        Object last;
        block47: {
            Statement stmt2;
            Statement stmt;
            if (this._global) {
                tableName = "<GLOBAL>";
            }
            last = this._lastValues.get(tableName);
            max = this._maxValues.get(tableName);
            if (last != null) {
                last = this._sqlType == 4 ? (Number)new Integer((Integer)last + 1) : (Number)(this._sqlType == -5 ? new Long((Long)last + 1L) : ((BigDecimal)last).add(ONE));
            } else {
                SQLException ex22;
                block46: {
                    stmt = null;
                    stmt2 = null;
                    if (!this._sameConnection) {
                        conn.rollback();
                    }
                    QueryExpression query = this._factory.getQueryExpression();
                    query.addColumn(this._seqTable, this._seqValue);
                    query.addCondition(this._seqTable, this._seqKey, "=", "?");
                    String sql = query.getStatement(true);
                    String sql2 = "UPDATE " + this._seqTable + " SET " + this._seqValue + "=" + "?" + " WHERE " + this._seqKey + "=" + "?" + " AND " + this._seqValue + "=" + "?";
                    stmt = conn.prepareStatement(sql);
                    stmt.setString(1, tableName);
                    stmt2 = conn.prepareStatement(sql2);
                    stmt2.setString(2, tableName);
                    boolean success = false;
                    int i = 0;
                    while (!success && i < 7) {
                        ResultSet rs = stmt.executeQuery();
                        if (rs.next()) {
                            if (this._sqlType == 4) {
                                int value = rs.getInt(1);
                                stmt2.setInt(3, value);
                                last = new Integer(value + 1);
                                int maxVal = value + this._grabSizeI;
                                max = new Integer(maxVal);
                                stmt2.setInt(1, maxVal);
                            } else if (this._sqlType == -5) {
                                long value = rs.getLong(1);
                                stmt2.setLong(3, value);
                                last = new Long(value + 1L);
                                long maxVal = value + (long)this._grabSizeI;
                                max = new Long(maxVal);
                                stmt2.setLong(1, maxVal);
                            } else {
                                BigDecimal value = rs.getBigDecimal(1);
                                stmt2.setBigDecimal(3, value);
                                last = value.add(ONE);
                                BigDecimal maxVal = value.add(this._grabSizeD);
                                max = maxVal;
                                stmt2.setBigDecimal(1, maxVal);
                            }
                            success = stmt2.executeUpdate() == 1;
                        } else {
                            stmt.close();
                            if (!this._global) {
                                stmt = conn.prepareStatement("SELECT MAX(" + primKeyName + ") FROM " + tableName);
                                rs = stmt.executeQuery();
                            }
                            if (this._sqlType == 4) {
                                int maxPK = 0;
                                if (!this._global && rs.next()) {
                                    maxPK = rs.getInt(1);
                                }
                                last = new Integer(maxPK + 1);
                                max = new Integer(maxPK + this._grabSizeI);
                            } else if (this._sqlType == -5) {
                                long maxPK = 0L;
                                if (!this._global && rs.next()) {
                                    maxPK = rs.getLong(1);
                                }
                                last = new Long(maxPK + 1L);
                                max = new Long(maxPK + (long)this._grabSizeI);
                            } else {
                                BigDecimal maxPK = null;
                                if (!this._global && rs.next()) {
                                    maxPK = rs.getBigDecimal(1);
                                }
                                if (maxPK == null) {
                                    maxPK = new BigDecimal(0.0);
                                }
                                last = maxPK.add(ONE);
                                max = maxPK.add(this._grabSizeD);
                            }
                            stmt2.close();
                            stmt2 = conn.prepareStatement("INSERT INTO " + this._seqTable + " (" + this._seqKey + "," + this._seqValue + ") VALUES (?, ?)");
                            stmt2.setString(1, tableName);
                            stmt2.setObject(2, max);
                            stmt2.executeUpdate();
                            success = true;
                        }
                        ++i;
                    }
                    if (!this._sameConnection) {
                        if (success) {
                            conn.commit();
                        } else {
                            conn.rollback();
                        }
                    }
                    if (!success) {
                        throw new PersistenceException(Messages.message("persist.keyGenFailed"));
                    }
                    Object var22_25 = null;
                    if (stmt == null) break block46;
                    try {
                        stmt.close();
                    }
                    catch (SQLException ex22) {
                        // empty catch block
                    }
                }
                if (stmt2 != null) {
                    try {
                        stmt2.close();
                    }
                    catch (SQLException ex22) {}
                }
            }
            break block47;
            {
                catch (SQLException ex) {
                    if (!this._sameConnection) {
                        try {
                            conn.rollback();
                        }
                        catch (SQLException ex2) {
                            // empty catch block
                        }
                    }
                    throw new PersistenceException(Messages.format("persist.keyGenSQL", ex.toString()), ex);
                }
            }
            catch (Throwable throwable) {
                SQLException ex22;
                Object var22_26 = null;
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException ex22) {
                        // empty catch block
                    }
                }
                if (stmt2 != null) {
                    try {
                        stmt2.close();
                    }
                    catch (SQLException ex22) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        if (this._sqlType == 4) {
            inRange = (Integer)last < (Integer)max;
        } else if (this._sqlType == -5) {
            inRange = (Long)last < (Long)max;
        } else {
            boolean bl = inRange = ((BigDecimal)last).compareTo((BigDecimal)max) < 0;
        }
        if (inRange) {
            this._lastValues.put(tableName, last);
            this._maxValues.put(tableName, max);
        } else {
            this._lastValues.remove(tableName);
            this._maxValues.remove(tableName);
        }
        return last;
    }

    public final byte getStyle() {
        return -1;
    }

    public final String patchSQL(String insert, String primKeyName) throws MappingException {
        return insert;
    }

    public final boolean isInSameConnection() {
        return this._sameConnection;
    }
}

