/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.asm;

import java.io.DataOutputStream;
import java.io.IOException;
import sun.tools.asm.ConstantPool;
import sun.tools.asm.ConstantPoolData;
import sun.tools.java.Environment;

final class NumberConstantData
extends ConstantPoolData {
    Number num;

    int order() {
        return this.width() == 1 ? 0 : 3;
    }

    int width() {
        return this.num instanceof Double || this.num instanceof Long ? 2 : 1;
    }

    NumberConstantData(ConstantPool constantPool, Number number) {
        this.num = number;
    }

    void write(Environment environment, DataOutputStream dataOutputStream, ConstantPool constantPool) throws IOException {
        if (this.num instanceof Integer) {
            dataOutputStream.writeByte(3);
            dataOutputStream.writeInt(this.num.intValue());
        } else if (this.num instanceof Long) {
            dataOutputStream.writeByte(5);
            dataOutputStream.writeLong(this.num.longValue());
        } else if (this.num instanceof Float) {
            dataOutputStream.writeByte(4);
            dataOutputStream.writeFloat(this.num.floatValue());
        } else if (this.num instanceof Double) {
            dataOutputStream.writeByte(6);
            dataOutputStream.writeDouble(this.num.doubleValue());
        }
    }
}

