/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.ExprValue;
import tcl.lang.Expression;
import tcl.lang.Interp;
import tcl.lang.TclDouble;
import tcl.lang.TclException;
import tcl.lang.TclObject;
import tcl.lang.UnaryMathFunction;

class SinhFunction
extends UnaryMathFunction {
    SinhFunction() {
    }

    ExprValue apply(Interp interp, TclObject[] tclObjectArray) throws TclException {
        double d = TclDouble.get(interp, tclObjectArray[0]);
        double d2 = Math.pow(Math.E, d);
        double d3 = Math.pow(Math.E, -d);
        Expression.checkDoubleRange(interp, d2);
        Expression.checkDoubleRange(interp, d3);
        return new ExprValue((d2 - d3) / 2.0);
    }
}

