/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.jabber;

import com.echomine.common.ParseException;
import com.echomine.jabber.ErrorMessage;
import com.echomine.jabber.JabberJDOMMessage;
import com.echomine.jabber.JabberMessage;
import com.echomine.jabber.JabberMessageParser;
import org.jdom.Element;

public abstract class AbstractJabberMessage
extends JabberJDOMMessage {
    private String type;
    private String to;
    private String from;
    public static final String TYPE_ERROR = "error";

    public AbstractJabberMessage(String type, Element root) {
        super(root);
        this.setType(type);
        this.getDOM().setAttribute("id", this.getMessageID());
    }

    protected AbstractJabberMessage() {
    }

    public JabberMessage parse(JabberMessageParser parser, Element msgTree) throws ParseException {
        super.parse(parser, msgTree);
        this.type = msgTree.getAttributeValue("type");
        this.to = msgTree.getAttributeValue("to");
        this.from = msgTree.getAttributeValue("from");
        String msgid = msgTree.getAttributeValue("id");
        if (msgid != null) {
            this.setMessageID(msgid);
        }
        return this;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
        if (type != null) {
            this.getDOM().setAttribute("type", type);
        } else {
            this.getDOM().removeAttribute("type", this.getDOM().getNamespace());
        }
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
        if (to != null) {
            this.getDOM().setAttribute("to", to);
        } else {
            this.getDOM().removeAttribute("type", this.getDOM().getNamespace());
        }
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
        if (from != null) {
            this.getDOM().setAttribute("from", from);
        } else {
            this.getDOM().removeAttribute("type", this.getDOM().getNamespace());
        }
    }

    public boolean isError() {
        if (this.type.equals(TYPE_ERROR)) {
            return true;
        }
        AbstractJabberMessage reply = (AbstractJabberMessage)this.getReplyMessage();
        return reply != null && reply.isError();
    }

    public ErrorMessage getErrorMessage() {
        AbstractJabberMessage reply = (AbstractJabberMessage)this.getReplyMessage();
        if (!this.type.equals(TYPE_ERROR) && reply == null) {
            return null;
        }
        ErrorMessage error = null;
        if (this.type.equals(TYPE_ERROR)) {
            Element errorElem = this.getDOM().getChild(TYPE_ERROR, this.getDOM().getNamespace());
            if (errorElem == null) {
                return null;
            }
            String code = errorElem.getAttributeValue("code");
            String errmsg = errorElem.getText();
            int errcode = 0;
            if (code != null) {
                errcode = Integer.parseInt(code);
            }
            error = new ErrorMessage(errcode, errmsg);
        } else {
            if (reply != null && !reply.isError()) {
                return null;
            }
            error = reply.getErrorMessage();
        }
        return error;
    }
}

