/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.net.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;

public class URIUtils {
    private static final String FILE_PROTOCOL_PREFIX = "file:///";
    private static final char HREF_PATH_SEP = '/';
    private static final char DEVICE_SEP = '|';

    public static InputStream getInputStream(String href, String documentBase) throws FileNotFoundException, IOException {
        URL url = null;
        try {
            url = new URL(href);
            return url.openStream();
        }
        catch (MalformedURLException muex) {
            int idx;
            String xHref = null;
            xHref = documentBase != null && documentBase.length() > 0 ? ((idx = documentBase.lastIndexOf(47)) == documentBase.length() - 1 ? documentBase + href : documentBase + '/' + href) : href;
            try {
                url = new URL(xHref);
                return url.openStream();
            }
            catch (MalformedURLException muex2) {
                File iFile = new File(href);
                if (iFile.isAbsolute()) {
                    return new FileInputStream(iFile);
                }
                iFile = new File(xHref);
                return new FileInputStream(iFile);
            }
        }
    }

    public static Reader getReader(String href, String documentBase) throws FileNotFoundException, IOException {
        InputStream is = URIUtils.getInputStream(href, documentBase);
        return new InputStreamReader(is);
    }

    public static String getDocumentBase(String href) {
        int idx;
        String docBase;
        block4: {
            docBase = "";
            if (href == null) {
                return docBase;
            }
            idx = -1;
            try {
                URL url = new URL(href);
                url = null;
                idx = href.lastIndexOf(47);
            }
            catch (MalformedURLException muex) {
                int idx2 = href.lastIndexOf(47);
                idx = href.lastIndexOf(File.separator);
                if (idx2 <= idx) break block4;
                idx = idx2;
            }
        }
        if (idx >= 0) {
            docBase = href.substring(0, idx);
        }
        return docBase;
    }

    public static String getRelativeURI(String href) {
        int idx;
        block4: {
            if (href == null) {
                return href;
            }
            idx = -1;
            try {
                URL url = new URL(href);
                url = null;
                idx = href.lastIndexOf(47);
            }
            catch (MalformedURLException muex) {
                int idx2 = href.lastIndexOf(47);
                idx = href.lastIndexOf(File.separator);
                if (idx2 <= idx) break block4;
                idx = idx2;
            }
        }
        if (idx >= 0) {
            return href.substring(idx + 1);
        }
        return href;
    }

    public static String resolveAsString(String href, String documentBase) {
        try {
            URL url = new URL(href);
            url = null;
            return href;
        }
        catch (MalformedURLException muex) {
            int idx;
            String absolute = null;
            absolute = documentBase != null && documentBase.length() > 0 ? ((idx = documentBase.lastIndexOf(47)) == documentBase.length() - 1 ? documentBase + href : documentBase + '/' + href) : href;
            try {
                URL url = new URL(absolute);
                url = null;
                return absolute;
            }
            catch (MalformedURLException muex2) {
                int idx2 = absolute.indexOf(58);
                if (idx2 >= 0) {
                    String scheme = absolute.substring(0, idx2);
                    String error = "unknown protocol: " + scheme;
                    if (error.equals(muex2.getMessage())) {
                        return absolute;
                    }
                }
                String fileURL = absolute;
                File iFile = new File(href);
                if (iFile.isAbsolute()) {
                    fileURL = URIUtils.createFileURL(iFile.getAbsolutePath());
                } else {
                    iFile = new File(fileURL);
                    fileURL = URIUtils.createFileURL(iFile.getAbsolutePath());
                }
                try {
                    URL url = new URL(fileURL);
                    url = null;
                    return fileURL;
                }
                catch (MalformedURLException muex3) {
                    return absolute;
                }
            }
        }
    }

    private static String createFileURL(String filename) {
        if (filename == null) {
            return FILE_PROTOCOL_PREFIX;
        }
        int size = filename.length() + FILE_PROTOCOL_PREFIX.length();
        StringBuffer sb = new StringBuffer(size);
        sb.append(FILE_PROTOCOL_PREFIX);
        char[] chars = filename.toCharArray();
        int i = 0;
        while (i < chars.length) {
            char ch = chars[i];
            switch (ch) {
                case '\\': {
                    sb.append('/');
                    break;
                }
                default: {
                    sb.append(ch);
                }
            }
            ++i;
        }
        return sb.toString();
    }
}

