/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.util;

import org.apache.oro.text.perl.Perl5Util;

public class HTTPRangeHeader {
    private Perl5Util rangeRE = new Perl5Util();
    private long start;
    private long end;

    public boolean parse(String range) {
        if (!this.rangeRE.match("m#^bytes=(\\d+)?-(\\d+)?$#", range)) {
            return false;
        }
        String value = this.rangeRE.group(1);
        this.start = value == null ? -1L : Long.parseLong(value);
        value = this.rangeRE.group(2);
        this.end = value == null ? -1L : Long.parseLong(value);
        return true;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(30);
        buffer.append("Range: bytes=");
        if (this.start > -1L) {
            buffer.append(this.start);
        }
        buffer.append("-");
        if (this.end > -1L) {
            buffer.append(this.end);
        }
        buffer.append("\r\n");
        return buffer.toString();
    }

    public void setRange(long start, long end) {
        if (end < start) {
            end = -1L;
        }
        this.start = start;
        this.end = end;
    }
}

