/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.util.junit;

import java.io.IOException;
import java.io.InputStream;

public class StringStream
extends InputStream {
    byte[] data;
    int currentPos;

    public StringStream(String dataStr) {
        this.setString(dataStr);
    }

    public void setString(String dataStr) {
        this.data = dataStr.getBytes();
        this.currentPos = 0;
    }

    public boolean equals(byte[] inbuf, int offset, int length) {
        int i = offset;
        while (i < length) {
            if (inbuf[i] != this.data[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int read() throws IOException {
        byte[] d = new byte[1];
        if (this.read(d) == -1) {
            return -1;
        }
        return d[0];
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int diff = this.data.length - this.currentPos;
        int readLen = len - off;
        if (this.currentPos == this.data.length) {
            return -1;
        }
        if (diff < readLen) {
            System.arraycopy(this.data, this.currentPos, b, off, diff);
            this.currentPos += diff;
            return diff;
        }
        System.arraycopy(this.data, this.currentPos, b, off, readLen);
        this.currentPos += readLen;
        return readLen;
    }
}

