/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.persist;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import org.exolab.castor.jdo.DataObjectAccessException;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.mapping.TypeConvertor;
import org.exolab.castor.mapping.loader.Types;
import org.exolab.castor.mapping.xml.FieldMapping;
import org.exolab.castor.mapping.xml.types.DirtyType;
import org.exolab.castor.persist.ClassMolder;
import org.exolab.castor.persist.DatingService;
import org.exolab.castor.persist.LockEngine;
import org.exolab.castor.persist.SQLRelationLoader;
import org.exolab.castor.util.Messages;

public class FieldMolder {
    public static final short PRIMITIVE = 0;
    public static final short SERIALIZABLE = 1;
    public static final short PERSISTANCECAPABLE = 2;
    public static final short ONE_TO_MANY = 3;
    public static final short MANY_TO_MANY = 4;
    private boolean _lazy;
    private boolean _check;
    private boolean _store;
    private boolean _multi;
    private boolean _serial;
    private boolean _addable;
    private ClassMolder _eMold;
    private ClassMolder _fMold;
    private Class _colClass;
    private String _fType;
    private String _fieldName;
    private Object _default;
    private boolean _readonly;
    private HashMap _reflectServices;
    private ReflectService _defaultReflectService;
    private SQLRelationLoader _manyToManyLoader;
    private static CollectionInfo[] info = new CollectionInfo[]{new CollectionInfo("collection", class$java$util$Collection == null ? (class$java$util$Collection = FieldMolder.class$("java.util.Collection")) : class$java$util$Collection), new CollectionInfo("vector", class$java$util$Vector == null ? (class$java$util$Vector = FieldMolder.class$("java.util.Vector")) : class$java$util$Vector), new CollectionInfo("arraylist", class$java$util$ArrayList == null ? (class$java$util$ArrayList = FieldMolder.class$("java.util.ArrayList")) : class$java$util$ArrayList), new CollectionInfo("hashtable", class$java$util$Hashtable == null ? (class$java$util$Hashtable = FieldMolder.class$("java.util.Hashtable")) : class$java$util$Hashtable), new CollectionInfo("hashmap", class$java$util$HashMap == null ? (class$java$util$HashMap = FieldMolder.class$("java.util.HashMap")) : class$java$util$HashMap), new CollectionInfo("set", class$java$util$Set == null ? (class$java$util$Set = FieldMolder.class$("java.util.Set")) : class$java$util$Set), new CollectionInfo("hashset", class$java$util$HashSet == null ? (class$java$util$HashSet = FieldMolder.class$("java.util.HashSet")) : class$java$util$HashSet), new CollectionInfo("map", class$java$util$Map == null ? (class$java$util$Map = FieldMolder.class$("java.util.Map")) : class$java$util$Map), new CollectionInfo("array", array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = FieldMolder.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object)};
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$util$Vector;
    static /* synthetic */ Class class$java$util$ArrayList;
    static /* synthetic */ Class class$java$util$Hashtable;
    static /* synthetic */ Class class$java$util$HashMap;
    static /* synthetic */ Class class$java$util$Set;
    static /* synthetic */ Class class$java$util$HashSet;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class array$Ljava$lang$Object;
    static /* synthetic */ Class class$java$io$Serializable;

    public String toString() {
        return "FieldMolder of " + this._eMold.getName() + ".set" + this._fieldName + "(" + this._fType + " " + this._fieldName + ")";
    }

    public String getName() {
        return this._fieldName;
    }

    public short getFieldType() {
        if (!this.isPersistanceCapable()) {
            if (!this.isSerializable()) {
                return 0;
            }
            return 1;
        }
        if (!this.isMulti()) {
            return 2;
        }
        if (!this.isManyToMany()) {
            return 3;
        }
        return 4;
    }

    public SQLRelationLoader getRelationLoader() {
        return this._manyToManyLoader;
    }

    public boolean isStored() {
        return this._fMold == null || this._store;
    }

    public boolean isManyToMany() {
        return this._manyToManyLoader != null;
    }

    public boolean isDependent() {
        if (this._fMold == null) {
            return false;
        }
        ClassMolder extendPath = this._eMold;
        ClassMolder depends = this._fMold.getDepends();
        while (extendPath != null) {
            if (extendPath == depends) {
                return true;
            }
            extendPath = extendPath.getExtends();
        }
        return false;
    }

    public boolean isMulti() {
        return this._multi;
    }

    public boolean isPersistanceCapable() {
        return this._fMold != null;
    }

    public boolean isSerializable() {
        return this._serial;
    }

    public boolean isCheckDirty() {
        return this._check;
    }

    public boolean isLazy() {
        return this._lazy;
    }

    public boolean isAddable() {
        return this._addable;
    }

    void setFieldClassMolder(ClassMolder fMold) {
        this._fMold = fMold;
    }

    public ClassMolder getEnclosingClassMolder() {
        return this._eMold;
    }

    public ClassMolder getFieldClassMolder() {
        return this._fMold;
    }

    public LockEngine getFieldLockEngine() {
        return this._fMold == null ? null : this._fMold.getLockEngine();
    }

    public boolean isReadonly() {
        return this._readonly;
    }

    public Class getCollectionType() {
        return this._colClass;
    }

    public Object getValue(Object object, ClassLoader loader) {
        ReflectService rf = this.getContextReflectService(loader);
        try {
            if (rf._field != null) {
                return rf._field.get(object);
            }
            if (rf._getMethod != null) {
                if (rf._getSequence != null) {
                    int i = 0;
                    while (i < rf._getSequence.length) {
                        if ((object = rf._getSequence[i].invoke(object, null)) == null) break;
                        ++i;
                    }
                }
                if (object == null || rf._hasMethod != null && !((Boolean)rf._hasMethod.invoke(object, null)).booleanValue()) {
                    return null;
                }
                return rf._getMethod.invoke(object, null);
            }
            return null;
        }
        catch (IllegalAccessException except) {
            throw new DataObjectAccessException(Messages.format("mapping.schemaChangeNoAccess", this.toString()), except);
        }
        catch (InvocationTargetException except) {
            throw new DataObjectAccessException(Messages.format("mapping.schemaChangeInvocation", this.toString(), except));
        }
    }

    public void addValue(Object object, Object value, ClassLoader loader) {
        ReflectService rf = this.getContextReflectService(loader);
        try {
            if (rf._addMethod == null) {
                throw new DataObjectAccessException("No add method defined for this field");
            }
            if (value == null) {
                throw new NullPointerException("Adding null value is not allowed");
            }
            rf._addMethod.invoke(object, value);
        }
        catch (IllegalArgumentException e) {
            throw new DataObjectAccessException("Argument ," + value + ", cannot be added!", e);
        }
        catch (IllegalAccessException e) {
            throw new DataObjectAccessException("Field access error", e);
        }
        catch (InvocationTargetException e) {
            throw new DataObjectAccessException("Field invocation error", e);
        }
    }

    public void setValue(Object object, Object value, ClassLoader loader) {
        block13: {
            ReflectService rf = this.getContextReflectService(loader);
            try {
                if (rf._field != null) {
                    rf._field.set(object, value == null ? this._default : value);
                    break block13;
                }
                if (rf._setMethod != null) {
                    if (rf._getSequence != null) {
                        int i = 0;
                        while (i < rf._getSequence.length) {
                            Object last = object;
                            if ((object = rf._getSequence[i].invoke(object, null)) == null) {
                                if (value == null || rf._setSequence[i] == null) break;
                                object = Types.newInstance(rf._getSequence[i].getReturnType());
                                rf._setSequence[i].invoke(last, object);
                            }
                            ++i;
                        }
                    }
                    if (object != null) {
                        if (value == null && rf._deleteMethod != null) {
                            rf._deleteMethod.invoke(object, null);
                        } else {
                            rf._setMethod.invoke(object, value == null ? this._default : value);
                        }
                    }
                    break block13;
                }
                throw new DataObjectAccessException("no method to set value for field: " + this._fType + " in class: " + this._eMold);
            }
            catch (IllegalArgumentException except) {
                if (value == null) {
                    throw new DataObjectAccessException(Messages.format("mapping.typeConversionNull", this.toString()));
                }
                throw new DataObjectAccessException(Messages.format("mapping.typeConversion", this.toString(), value.getClass().getName()));
            }
            catch (IllegalAccessException except) {
                throw new DataObjectAccessException(Messages.format("mapping.schemaChangeNoAccess", this.toString()), except);
            }
            catch (InvocationTargetException except) {
                throw new DataObjectAccessException(Messages.format("mapping.schemaChangeInvocation", this.toString(), except.getMessage()), except);
            }
        }
    }

    public boolean isDefault(Object value) {
        if (this._default == value) {
            return true;
        }
        if (this._default == null) {
            return false;
        }
        return this._default.equals(value);
    }

    protected Class getCollectionType(String coll, boolean lazy) throws MappingException {
        int i = 0;
        while (i < info.length) {
            if (FieldMolder.info[i].name.equals(coll)) {
                return FieldMolder.info[i].type;
            }
            ++i;
        }
        return null;
    }

    public FieldMolder(DatingService ds, ClassMolder eMold, FieldMapping fieldMap, String manyTable, String[] idSQL, int[] idType, TypeConvertor[] idTo, TypeConvertor[] idFrom, String[] idParam, String[] relatedIdSQL, int[] relatedIdType, TypeConvertor[] ridTo, TypeConvertor[] ridFrom, String[] ridParam) throws MappingException {
        this(ds, eMold, fieldMap);
        this._manyToManyLoader = new SQLRelationLoader(manyTable, idSQL, idType, idTo, idFrom, idParam, relatedIdSQL, relatedIdType, ridTo, ridFrom, ridParam);
    }

    public FieldMolder(DatingService ds, ClassMolder eMold, FieldMapping fieldMap) throws MappingException {
        try {
            Class<?> javaClass;
            this._defaultReflectService = new ReflectService();
            this._reflectServices = new HashMap();
            this._eMold = eMold;
            this._lazy = fieldMap.getLazy();
            if (fieldMap.getSql() == null || fieldMap.getSql().getDirty() == null || !fieldMap.getSql().getDirty().equals(DirtyType.IGNORE)) {
                this._check = true;
            }
            if ("serializable".equals(fieldMap.getType())) {
                this._serial = true;
            }
            this._store = fieldMap.getSql() == null ? false : (fieldMap.getSql().getManyTable() != null ? false : fieldMap.getSql().getName().length != 0);
            if (fieldMap.getSql() != null) {
                this._readonly = fieldMap.getSql().getReadonly();
            }
            if (fieldMap.getCollection() != null) {
                this._multi = true;
            }
            if (fieldMap.getCollection() != null) {
                if ("array".equals(fieldMap.getCollection().toString())) {
                    String arrayClassName = "[L" + fieldMap.getType() + ";";
                    try {
                        this._colClass = ds.resolve(arrayClassName);
                    }
                    catch (ClassNotFoundException e) {
                        throw new MappingException("mapping.classNotFound", arrayClassName);
                    }
                } else {
                    this._colClass = this.getCollectionType(fieldMap.getCollection().toString(), this._lazy);
                }
                this._store = false;
            }
            this._fType = fieldMap.getType();
            try {
                javaClass = ds.resolve(eMold.getName());
            }
            catch (ClassNotFoundException e) {
                throw new MappingException("mapping.classNotFound", eMold.getName());
            }
            this._defaultReflectService._loader = javaClass.getClassLoader();
            if (null != this._defaultReflectService._loader) {
                this._reflectServices.put(this._defaultReflectService._loader, this._defaultReflectService);
            }
            String fieldName = fieldMap.getName();
            String fieldType = fieldMap.getType();
            Class declaredClass = null;
            if (fieldType != null) {
                try {
                    this._defaultReflectService._fClass = declaredClass = Types.typeFromName(javaClass.getClassLoader(), fieldType);
                }
                catch (ClassNotFoundException cnfe) {
                    throw new MappingException("mapping.classNotFound", declaredClass);
                }
            }
            if (fieldMap.getDirect()) {
                Class fieldClass = this._colClass != null ? this._colClass : null;
                this._defaultReflectService._field = this.findField(javaClass, fieldName, fieldClass);
                if (this._defaultReflectService._field == null) {
                    throw new MappingException(Messages.format("mapping.fieldNotAccessible", fieldName, javaClass.getName()));
                }
                this._defaultReflectService._fClass = this._defaultReflectService._field.getType();
                if (this._defaultReflectService._field.getModifiers() != 1 && this._defaultReflectService._field.getModifiers() != 65) {
                    throw new MappingException(Messages.format("mapping.fieldNotAccessible", this._defaultReflectService._field.getName(), this._defaultReflectService._field.getDeclaringClass().getName()));
                }
            } else if (fieldMap.getGetMethod() == null && fieldMap.getSetMethod() == null) {
                ArrayList<Method> getSeq = new ArrayList<Method>();
                ArrayList<Method> setSeq = new ArrayList<Method>();
                String name = fieldMap.getName();
                String methodName = null;
                try {
                    int point;
                    while ((point = name.indexOf(46)) >= 0) {
                        Class<?> last = javaClass;
                        methodName = "get" + this.capitalize(name.substring(0, point));
                        Method method = javaClass.getMethod(methodName, null);
                        name = name.substring(point + 1);
                        if ((method.getModifiers() & 0x400) != 0 || (method.getModifiers() & 8) != 0) {
                            throw new MappingException("mapping.accessorNotAccessible", methodName, javaClass.getName());
                        }
                        getSeq.add(method);
                        javaClass = method.getReturnType();
                        methodName = "set" + methodName.substring(3);
                        try {
                            method = last.getMethod(methodName, javaClass);
                            if ((method.getModifiers() & 0x400) != 0 || (method.getModifiers() & 8) != 0) {
                                method = null;
                            }
                        }
                        catch (Exception except) {
                            method = null;
                        }
                        setSeq.add(method);
                    }
                }
                catch (Exception ex) {
                    throw new MappingException("mapping.accessorNotFound", methodName, null, javaClass.getName());
                }
                if (getSeq.size() > 0) {
                    this._defaultReflectService._getSequence = getSeq.toArray(new Method[0]);
                    this._defaultReflectService._setSequence = setSeq.toArray(new Method[0]);
                }
                Class methodClass = this._colClass != null ? this._colClass : null;
                this._defaultReflectService._getMethod = FieldMolder.findAccessor(javaClass, "get" + this.capitalize(name), methodClass, true);
                if (this._defaultReflectService._getMethod == null) {
                    throw new MappingException("mapping.accessorNotFound", "get" + name, null, javaClass.getName());
                }
                if (this._colClass == null) {
                    this._defaultReflectService._fClass = this._defaultReflectService._getMethod.getReturnType();
                }
                this._defaultReflectService._setMethod = FieldMolder.findAccessor(javaClass, "set" + this.capitalize(name), methodClass, false);
                if (this._defaultReflectService._setMethod == null) {
                    this._defaultReflectService._addMethod = FieldMolder.findAccessor(javaClass, "add" + this.capitalize(name), null, false);
                }
                if (this._defaultReflectService._addMethod == null && name.endsWith("s")) {
                    this._defaultReflectService._addMethod = FieldMolder.findAccessor(javaClass, "add" + this.capitalize(name).substring(0, name.length() - 1), declaredClass, false);
                }
                if (this._defaultReflectService._setMethod == null && this._defaultReflectService._addMethod == null) {
                    throw new MappingException("mapping.accessorNotFound", "set/add" + this.capitalize(name), declaredClass, javaClass.getName());
                }
                if (this._defaultReflectService._addMethod != null) {
                    this._addable = true;
                }
            } else {
                Class methodClass = this._defaultReflectService._fClass;
                if (fieldMap.getGetMethod() != null) {
                    this._defaultReflectService._getMethod = this._colClass != null ? FieldMolder.findAccessor(javaClass, fieldMap.getGetMethod(), this._colClass, true) : FieldMolder.findAccessor(javaClass, fieldMap.getGetMethod(), methodClass, true);
                    if (this._defaultReflectService._getMethod == null) {
                        throw new MappingException("mapping.accessorNotFound", fieldMap.getGetMethod(), methodClass, javaClass.getName());
                    }
                    if (this._colClass == null) {
                        this._defaultReflectService._fClass = this._defaultReflectService._getMethod.getReturnType();
                    }
                } else {
                    throw new MappingException("mapping.getMethodMappingNotFound", this._colClass != null ? this._colClass : methodClass, javaClass.getName());
                }
                if (fieldMap.getSetMethod() != null) {
                    if (this._colClass != null) {
                        this._defaultReflectService._setMethod = FieldMolder.findAccessor(javaClass, fieldMap.getSetMethod(), this._colClass, false);
                        if (this._defaultReflectService._setMethod == null && !fieldMap.getLazy()) {
                            this._defaultReflectService._addMethod = FieldMolder.findAccessor(javaClass, fieldMap.getSetMethod(), methodClass, false);
                        }
                    } else {
                        this._defaultReflectService._setMethod = FieldMolder.findAccessor(javaClass, fieldMap.getSetMethod(), methodClass, false);
                    }
                    if (this._defaultReflectService._setMethod == null && this._defaultReflectService._addMethod == null) {
                        throw new MappingException("mapping.accessorNotFound", fieldMap.getSetMethod(), methodClass, javaClass.getName());
                    }
                    if (this._defaultReflectService._fClass == null) {
                        this._defaultReflectService._fClass = this._defaultReflectService._setMethod.getParameterTypes()[0];
                    }
                } else {
                    throw new MappingException("mapping.setMethodMappingNotFound", this._colClass != null ? this._colClass : methodClass, javaClass.getName());
                }
            }
            if (fieldMap.getCreateMethod() != null) {
                try {
                    this._defaultReflectService._createMethod = javaClass.getMethod(fieldMap.getCreateMethod(), null);
                }
                catch (Exception except) {
                    throw new MappingException("mapping.createMethodNotFound", fieldMap.getCreateMethod(), javaClass.getName());
                }
            }
            if (fieldMap.getName() != null && !Types.isSimpleType(this._defaultReflectService._fClass)) {
                try {
                    Method method;
                    this._defaultReflectService._createMethod = method = javaClass.getMethod("create" + this.capitalize(fieldMap.getName()), null);
                }
                catch (Exception except) {
                    // empty catch block
                }
            }
            if (fieldMap.getName() != null) {
                Method hasMethod = null;
                Method deleteMethod = null;
                try {
                    hasMethod = javaClass.getMethod("has" + this.capitalize(fieldMap.getName()), null);
                    if ((hasMethod.getModifiers() & 1) == 0 || (hasMethod.getModifiers() & 8) != 0) {
                        hasMethod = null;
                    }
                    try {
                        if ((hasMethod.getModifiers() & 1) == 0 || (hasMethod.getModifiers() & 8) != 0) {
                            deleteMethod = null;
                        }
                        deleteMethod = javaClass.getMethod("delete" + this.capitalize(fieldMap.getName()), null);
                    }
                    catch (Exception except) {
                        // empty catch block
                    }
                    this._defaultReflectService._hasMethod = hasMethod;
                    this._defaultReflectService._deleteMethod = deleteMethod;
                }
                catch (Exception except) {
                    // empty catch block
                }
            }
            if (this._defaultReflectService._field == null && this._defaultReflectService._setMethod == null && this._defaultReflectService._getMethod == null) {
                throw new MappingException("_field or _setMethod can't be created");
            }
            ds.pairFieldClass(this, this._fType);
        }
        catch (NullPointerException e) {
            throw new MappingException("Unexpected Null pointer!\n" + e);
        }
        this._fieldName = fieldMap.getName();
        this._default = Types.getDefault(this._defaultReflectService._fClass);
        if (!this._defaultReflectService._fClass.isPrimitive()) {
            this._default = null;
        }
    }

    private Field findField(Class javaClass, String fieldName, Class fieldType) throws MappingException {
        try {
            Field field = javaClass.getField(fieldName);
            if (field.getModifiers() != 1 && field.getModifiers() != 65) {
                throw new MappingException("mapping.fieldNotAccessible", fieldName, javaClass.getName());
            }
            if (fieldType == null) {
                fieldType = Types.typeFromPrimitive(field.getType());
            } else if (Types.typeFromPrimitive(fieldType) != Types.typeFromPrimitive(field.getType())) {
                throw new MappingException("mapping.fieldTypeMismatch", field, fieldType.getName());
            }
            return field;
        }
        catch (NoSuchFieldException except) {
        }
        catch (SecurityException except) {
            // empty catch block
        }
        return null;
    }

    private static Method findAccessor(Class javaClass, String methodName, Class fieldType, boolean getMethod) throws MappingException {
        try {
            Method method;
            if (getMethod) {
                method = javaClass.getMethod(methodName, new Class[0]);
                if (fieldType == null) {
                    fieldType = Types.typeFromPrimitive(method.getReturnType());
                } else if (!(fieldType == (class$java$io$Serializable == null ? (class$java$io$Serializable = FieldMolder.class$("java.io.Serializable")) : class$java$io$Serializable) && (class$java$io$Serializable == null ? (class$java$io$Serializable = FieldMolder.class$("java.io.Serializable")) : class$java$io$Serializable).isAssignableFrom(method.getReturnType()) || Types.typeFromPrimitive(fieldType).isAssignableFrom(Types.typeFromPrimitive(method.getReturnType())))) {
                    throw new MappingException("mapping.accessorReturnTypeMismatch", method, fieldType.getName());
                }
            } else if (fieldType != null) {
                try {
                    method = javaClass.getMethod(methodName, fieldType);
                }
                catch (Exception except) {
                    method = javaClass.getMethod(methodName, Types.typeFromPrimitive(fieldType));
                }
            } else {
                Method[] methods = javaClass.getMethods();
                method = null;
                int i = 0;
                while (i < methods.length) {
                    if (methods[i].getName().equals(methodName) && methods[i].getParameterTypes().length == 1) {
                        method = methods[i];
                        break;
                    }
                    ++i;
                }
                if (method == null) {
                    return null;
                }
            }
            if ((method.getModifiers() & 1) == 0 || (method.getModifiers() & 8) != 0) {
                throw new MappingException("mapping.accessorNotAccessible", methodName, javaClass.getName());
            }
            return method;
        }
        catch (MappingException except) {
            throw except;
        }
        catch (Exception except) {
            return null;
        }
    }

    private String capitalize(String name) {
        char first = name.charAt(0);
        if (Character.isUpperCase(first)) {
            return name;
        }
        return Character.toUpperCase(first) + name.substring(1);
    }

    private ReflectService getContextReflectService(ClassLoader loader) {
        if (null == loader || this._defaultReflectService._loader == loader) {
            return this._defaultReflectService;
        }
        ReflectService resultReflectService = (ReflectService)this._reflectServices.get(loader);
        if (null == resultReflectService) {
            resultReflectService = new ReflectService(this._defaultReflectService, loader);
        }
        return resultReflectService;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ReflectService {
        ClassLoader _loader;
        Class _fClass;
        Field _field;
        Method[] _getSequence;
        Method[] _setSequence;
        Method _getMethod;
        Method _setMethod;
        Method _addMethod;
        Method _hasMethod;
        Method _deleteMethod;
        Method _createMethod;

        ReflectService() {
        }

        ReflectService(ReflectService refSrv, ClassLoader loader) {
            this._loader = loader;
            this._fClass = this.cloneClass(refSrv._fClass);
            this._field = this.cloneField(refSrv._field);
            this._getSequence = this.cloneMethods(refSrv._getSequence);
            this._setSequence = this.cloneMethods(refSrv._setSequence);
            this._getMethod = this.cloneMethod(refSrv._getMethod);
            this._addMethod = this.cloneMethod(refSrv._addMethod);
            this._setMethod = this.cloneMethod(refSrv._setMethod);
            this._hasMethod = this.cloneMethod(refSrv._hasMethod);
            this._deleteMethod = this.cloneMethod(refSrv._deleteMethod);
            this._createMethod = this.cloneMethod(refSrv._createMethod);
        }

        private Field cloneField(Field originalField) {
            if (null == originalField) {
                return null;
            }
            Field resultField = null;
            try {
                resultField = originalField.getDeclaringClass().getField(originalField.getName());
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            return resultField;
        }

        private Method cloneMethod(Method originalMethod) {
            if (null == originalMethod) {
                return null;
            }
            Method resultMethod = null;
            try {
                Class newCls = this.loadClass(originalMethod.getDeclaringClass().getName());
                String methodName = originalMethod.getName();
                Class<?>[] methodParams = originalMethod.getParameterTypes();
                int i = 0;
                while (i < methodParams.length) {
                    if (!methodParams[i].isPrimitive()) {
                        methodParams[i] = this.loadClass(methodParams[i].getName());
                    }
                    ++i;
                }
                resultMethod = newCls.getMethod(methodName, methodParams);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            return resultMethod;
        }

        private Method[] cloneMethods(Method[] originalMethods) {
            if (null == originalMethods) {
                return null;
            }
            Method[] resultMethods = new Method[originalMethods.length];
            int i = 0;
            while (i < originalMethods.length) {
                resultMethods[i] = this.cloneMethod(originalMethods[i]);
                ++i;
            }
            return resultMethods;
        }

        private Class cloneClass(Class originalClass) {
            if (null == originalClass) {
                return null;
            }
            if (originalClass.isPrimitive()) {
                return originalClass;
            }
            return this.loadClass(originalClass.getName());
        }

        private Class loadClass(String name) {
            Class<?> resultClass = null;
            try {
                resultClass = null != this._loader ? this._loader.loadClass(name) : Class.forName(name);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            return resultClass;
        }
    }

    static class CollectionInfo {
        String name;
        Class type;

        CollectionInfo(String name, Class type) {
            this.name = name;
            this.type = type;
        }
    }
}

