/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.Util;

class LsearchCmd
implements Command {
    private static final String[] validCmds = new String[]{"-exact", "-glob", "-regexp"};
    static final int EXACT = 0;
    static final int GLOB = 1;
    static final int REGEXP = 2;

    LsearchCmd() {
    }

    public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
        int n = 1;
        TclObject tclObject = null;
        TclObject tclObject2 = null;
        if (tclObjectArray.length == 4) {
            n = TclIndex.get(interp, tclObjectArray[1], validCmds, "search mode", 0);
            tclObject2 = tclObjectArray[2];
            tclObject = tclObjectArray[3];
        } else if (tclObjectArray.length == 3) {
            tclObject2 = tclObjectArray[1];
            tclObject = tclObjectArray[2];
        } else {
            throw new TclNumArgsException(interp, 1, tclObjectArray, "?mode? list pattern");
        }
        boolean bl = false;
        int n2 = TclList.getLength(interp, tclObject2);
        int n3 = 0;
        while (n3 < n2) {
            TclObject tclObject3 = TclList.index(interp, tclObject2, n3);
            if (tclObject3 == tclObject || tclObject3.equals(tclObject)) {
                bl = true;
            } else {
                switch (n) {
                    case 0: {
                        bl = tclObject3.toString().compareTo(tclObject.toString()) == 0;
                        break;
                    }
                    case 1: {
                        bl = Util.stringMatch(tclObject3.toString(), tclObject.toString());
                        break;
                    }
                    case 2: {
                        bl = Util.regExpMatch(interp, tclObject3.toString(), tclObject);
                    }
                }
            }
            if (bl) {
                interp.setResult(n3);
                return;
            }
            ++n3;
        }
        interp.setResult(-1);
    }
}

