/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.jabber;

import com.echomine.common.ParseException;
import com.echomine.jabber.JIDType;
import com.echomine.jabber.JabberCode;
import com.echomine.jabber.JabberIQMessage;
import com.echomine.jabber.JabberMessage;
import com.echomine.jabber.JabberMessageParser;
import org.jdom.Element;

public class BrowseIQMessage
extends JabberIQMessage {
    private JIDType jidtype;

    public BrowseIQMessage(String type, String jtype) {
        super(type);
        this.jidtype = new JIDType(jtype);
        this.getDOM().addContent(new Element(this.jidtype.getCategory(), JabberCode.XMLNS_IQ_BROWSE));
    }

    public BrowseIQMessage() {
        this("get", "service/jabber");
    }

    public JIDType getJIDType() {
        return this.jidtype;
    }

    public void setJIDType(JIDType jidtype) {
        this.jidtype = jidtype;
    }

    public int getMessageType() {
        return 18;
    }

    public JabberMessage parse(JabberMessageParser parser, Element msgTree) throws ParseException {
        super.parse(parser, msgTree);
        Element browse = (Element)msgTree.getChildren().get(0);
        if (browse == null) {
            throw new ParseException("No browse message exists");
        }
        String category = browse.getName();
        String subtype = browse.getAttributeValue("type");
        this.jidtype = new JIDType(category, subtype);
        this.jidtype.parse(browse);
        return this;
    }

    public String encode() throws ParseException {
        if (this.jidtype != null) {
            this.getDOM().removeChildren();
            this.getDOM().addContent(this.jidtype.getDOM());
        }
        return super.encode();
    }
}

