/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.util;

import com.echomine.util.HTTPHeader;
import com.echomine.util.IOUtil;
import java.io.IOException;
import java.io.InputStream;
import org.apache.oro.text.perl.Perl5Util;

public class HTTPResponseHeader
extends HTTPHeader {
    private String protocol = "HTTP";
    private int code;
    private String statusMsg;
    private Perl5Util httpResponseRE = new Perl5Util();

    public void clear() {
        super.clear();
        this.code = 0;
        this.statusMsg = null;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(200);
        buffer.append(this.protocol).append(" ").append(this.code).append(" ").append(this.statusMsg).append("\r\n");
        buffer.append(super.toString());
        buffer.append("\r\n");
        return buffer.toString();
    }

    public void parse(InputStream is) throws IOException {
        int SOCKETBUF = 1024;
        byte[] bytebuf = new byte[SOCKETBUF];
        int bytesread = IOUtil.readToCRLF(is, bytebuf, 0, SOCKETBUF);
        String line = new String(bytebuf, 0, bytesread);
        if (!this.httpResponseRE.match("m#^(\\S+)\\s+(\\d+)(?:\\s+(.+))?#i", line)) {
            throw new IOException("Invalid HTTP response header");
        }
        this.protocol = this.httpResponseRE.group(1);
        this.code = Integer.parseInt(this.httpResponseRE.group(2));
        this.statusMsg = this.httpResponseRE.group(3);
        this.parseHeaders(is);
    }

    public void setStatus(int code, String msg) {
        this.code = code;
        this.statusMsg = msg;
    }

    public int getStatusCode() {
        return this.code;
    }

    public String getStatusMessage() {
        return this.statusMsg;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol == null ? "HTTP" : protocol;
    }
}

