/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.standard;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.RootDoc;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DeprecatedAPIListBuilder {
    private List deprecatedclasses = new ArrayList();
    private List deprecatedinterfaces = new ArrayList();
    private List deprecatedexceptions = new ArrayList();
    private List deprecatederrors = new ArrayList();
    private List deprecatedfields = new ArrayList();
    private List deprecatedmethods = new ArrayList();
    private List deprecatedconstructors = new ArrayList();

    private void sortDeprecatedLists() {
        Collections.sort(this.deprecatedclasses);
        Collections.sort(this.deprecatedinterfaces);
        Collections.sort(this.deprecatedexceptions);
        Collections.sort(this.deprecatederrors);
        Collections.sort(this.deprecatedfields);
        Collections.sort(this.deprecatedmethods);
        Collections.sort(this.deprecatedconstructors);
    }

    public DeprecatedAPIListBuilder(RootDoc rootDoc) {
        this.buildDeprecatedAPIInfo(rootDoc);
    }

    private void buildDeprecatedAPIInfo(RootDoc rootDoc) {
        ClassDoc[] classDocArray = rootDoc.classes();
        int n = 0;
        while (n < classDocArray.length) {
            ClassDoc classDoc = classDocArray[n];
            if (classDoc.tags("deprecated").length > 0) {
                if (classDoc.isOrdinaryClass()) {
                    this.deprecatedclasses.add(classDoc);
                } else if (classDoc.isInterface()) {
                    this.deprecatedinterfaces.add(classDoc);
                } else if (classDoc.isException()) {
                    this.deprecatedexceptions.add(classDoc);
                } else {
                    this.deprecatederrors.add(classDoc);
                }
            }
            this.composeDeprecatedList(this.deprecatedfields, classDoc.fields());
            this.composeDeprecatedList(this.deprecatedmethods, classDoc.methods());
            this.composeDeprecatedList(this.deprecatedconstructors, classDoc.constructors());
            ++n;
        }
        this.sortDeprecatedLists();
    }

    public List getDeprecatedClasses() {
        return this.deprecatedclasses;
    }

    public List getDeprecatedConstructors() {
        return this.deprecatedconstructors;
    }

    public List getDeprecatedErrors() {
        return this.deprecatederrors;
    }

    public List getDeprecatedExceptions() {
        return this.deprecatedexceptions;
    }

    public List getDeprecatedFields() {
        return this.deprecatedfields;
    }

    public List getDeprecatedInterfaces() {
        return this.deprecatedinterfaces;
    }

    public List getDeprecatedMethods() {
        return this.deprecatedmethods;
    }

    private void composeDeprecatedList(List list, MemberDoc[] memberDocArray) {
        int n = 0;
        while (n < memberDocArray.length) {
            if (memberDocArray[n].tags("deprecated").length > 0) {
                list.add(memberDocArray[n]);
            }
            ++n;
        }
    }
}

