/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.net;

import com.echomine.net.ConnectionEvent;
import com.echomine.net.ConnectionModel;
import com.echomine.net.ConnectionVetoException;
import com.echomine.net.HandshakeFailedException;
import com.echomine.net.HandshakeableSocketHandler;
import com.echomine.net.TimeableConnection;
import com.echomine.util.IOUtil;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;

public class HandshakeableSocketAcceptor
extends TimeableConnection {
    protected ServerSocket socket;
    private ConnectionModel connectionModel;

    public HandshakeableSocketAcceptor() {
    }

    public HandshakeableSocketAcceptor(ConnectionModel model) throws IOException {
        this(model, 20);
    }

    public HandshakeableSocketAcceptor(ConnectionModel model, int backlog) throws IOException {
        this.connectionModel = model;
        this.open(backlog);
    }

    public void open(int backlog) throws IOException {
        this.socket = this.connectionModel.getHost() == null ? new ServerSocket(this.connectionModel.getPort(), backlog) : new ServerSocket(this.connectionModel.getPort(), backlog, this.connectionModel.getHost());
    }

    public void accept(HandshakeableSocketHandler socketHandler) {
        try {
            Socket s = this.socket.accept();
            ConnectionModel model = new ConnectionModel(s.getInetAddress(), s.getPort());
            ConnectionEvent e = new ConnectionEvent(this.connectionModel, 4);
            ConnectionEvent vetoEvent = new ConnectionEvent(this.connectionModel, 5);
            try {
                try {
                    socketHandler.start();
                    this.fireConnectionStarting(e, vetoEvent);
                    e = new ConnectionEvent(this.connectionModel, 1);
                    socketHandler.handshake(s);
                    this.fireConnectionEstablished(e);
                    socketHandler.handle(s);
                    e = new ConnectionEvent(this.connectionModel, 2);
                    this.fireConnectionClosed(e);
                }
                catch (ConnectionVetoException ex) {
                }
                catch (HandshakeFailedException ex) {
                    e = new ConnectionEvent(this.connectionModel, 3, "Error during handshaking: " + ex.getMessage());
                    this.fireConnectionClosed(e);
                }
                catch (IOException ex) {
                    e = new ConnectionEvent(this.connectionModel, 3, "Error while handling connection: " + ex.getMessage());
                    this.fireConnectionClosed(e);
                }
                Object var11_10 = null;
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                IOUtil.closeSocket(s);
                throw throwable;
            }
            IOUtil.closeSocket(s);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void aaccept(HandshakeableSocketHandler socketHandler) {
        Thread thread = new Thread(new _1(this, socketHandler));
        thread.start();
    }

    public void close() {
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public ConnectionModel getConnectionModel() {
        return this.connectionModel;
    }

    public void setConnectionModel(ConnectionModel connectionModel) throws IOException {
        this.setConnectionModel(connectionModel, 20);
    }

    public void setConnectionModel(ConnectionModel connectionModel, int backlog) throws IOException {
        this.connectionModel = connectionModel;
        this.close();
        this.open(backlog);
    }

    static ConnectionModel access$8(HandshakeableSocketAcceptor obj$) {
        return obj$.connectionModel;
    }

    class _1
    implements Runnable {
        private final HandshakeableSocketAcceptor this$HandshakeableSocketAcceptor;
        final HandshakeableSocketHandler val$socketHandler;

        public void run() {
            try {
                Socket s = this.this$HandshakeableSocketAcceptor.socket.accept();
                ConnectionModel model = new ConnectionModel(s.getInetAddress(), s.getPort());
                ConnectionEvent e = new ConnectionEvent(HandshakeableSocketAcceptor.access$8(this.this$HandshakeableSocketAcceptor), 4);
                ConnectionEvent vetoEvent = new ConnectionEvent(HandshakeableSocketAcceptor.access$8(this.this$HandshakeableSocketAcceptor), 5);
                try {
                    try {
                        this.val$socketHandler.start();
                        this.this$HandshakeableSocketAcceptor.fireConnectionStarting(e, vetoEvent);
                        e = new ConnectionEvent(HandshakeableSocketAcceptor.access$8(this.this$HandshakeableSocketAcceptor), 1);
                        this.val$socketHandler.handshake(s);
                        this.this$HandshakeableSocketAcceptor.fireConnectionEstablished(e);
                        this.val$socketHandler.handle(s);
                        e = new ConnectionEvent(HandshakeableSocketAcceptor.access$8(this.this$HandshakeableSocketAcceptor), 2);
                        this.this$HandshakeableSocketAcceptor.fireConnectionClosed(e);
                    }
                    catch (HandshakeFailedException ex) {
                        e = new ConnectionEvent(HandshakeableSocketAcceptor.access$8(this.this$HandshakeableSocketAcceptor), 3, "Error during handshaking: " + ex.getMessage());
                        this.this$HandshakeableSocketAcceptor.fireConnectionClosed(e);
                    }
                    catch (IOException ex) {
                        e = new ConnectionEvent(HandshakeableSocketAcceptor.access$8(this.this$HandshakeableSocketAcceptor), 3, "Error while handling connection: " + ex.getMessage());
                        this.this$HandshakeableSocketAcceptor.fireConnectionClosed(e);
                    }
                    catch (ConnectionVetoException ex) {
                    }
                    Object var10_9 = null;
                }
                catch (Throwable throwable) {
                    Object var10_10 = null;
                    IOUtil.closeSocket(s);
                    throw throwable;
                }
                IOUtil.closeSocket(s);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        _1(HandshakeableSocketAcceptor enclosing$instance, HandshakeableSocketHandler val$socketHandler) {
            this.this$HandshakeableSocketAcceptor = enclosing$instance;
            this.val$socketHandler = val$socketHandler;
        }
    }
}

