/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.util.Vector;
import tcl.lang.FindElemResult;
import tcl.lang.InternalRep;
import tcl.lang.Interp;
import tcl.lang.QSort;
import tcl.lang.TclException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.Util;

public class TclList
extends InternalRep {
    private Vector vector;

    private TclList() {
        this.vector = new Vector();
    }

    private TclList(int n) {
        this.vector = new Vector(n);
    }

    protected void dispose() {
        int n = this.vector.size();
        int n2 = 0;
        while (n2 < n) {
            ((TclObject)this.vector.elementAt(n2)).release();
            ++n2;
        }
    }

    protected InternalRep duplicate() {
        int n = this.vector.size();
        TclList tclList = new TclList(n);
        int n2 = 0;
        while (n2 < n) {
            TclObject tclObject = (TclObject)this.vector.elementAt(n2);
            tclObject.preserve();
            tclList.vector.addElement(tclObject.takeExclusive());
            ++n2;
        }
        return tclList;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.vector.size();
        try {
            int n2 = 0;
            while (n2 < n) {
                Object e = this.vector.elementAt(n2);
                if (e != null) {
                    Util.appendElement(null, stringBuffer, e.toString());
                } else {
                    Util.appendElement(null, stringBuffer, "");
                }
                ++n2;
            }
        }
        catch (TclException tclException) {
            throw new TclRuntimeError("unexpected TclException: " + tclException);
        }
        return stringBuffer.toString();
    }

    public static TclObject newInstance() {
        return new TclObject(new TclList());
    }

    static void setListFromAny(Interp interp, TclObject tclObject) throws TclException {
        InternalRep internalRep = tclObject.getInternalRep();
        if (!(internalRep instanceof TclList)) {
            TclList tclList = new TclList();
            TclList.splitList(interp, tclList.vector, tclObject.toString());
            tclObject.setInternalRep(tclList);
        }
    }

    private static final void splitList(Interp interp, Vector vector, String string) throws TclException {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            FindElemResult findElemResult = Util.findElement(interp, string, n2, n);
            if (findElemResult == null) break;
            TclObject tclObject = TclString.newInstance(findElemResult.elem);
            tclObject.preserve();
            vector.addElement(tclObject);
            n2 = findElemResult.elemEnd;
        }
    }

    public static final void append(Interp interp, TclObject tclObject, TclObject tclObject2) throws TclException {
        TclList.setListFromAny(interp, tclObject);
        tclObject.invalidateStringRep();
        TclList tclList = (TclList)tclObject.getInternalRep();
        tclObject2.preserve();
        tclList.vector.addElement(tclObject2.takeExclusive());
    }

    public static final int getLength(Interp interp, TclObject tclObject) throws TclException {
        TclList.setListFromAny(interp, tclObject);
        TclList tclList = (TclList)tclObject.getInternalRep();
        return tclList.vector.size();
    }

    public static TclObject[] getElements(Interp interp, TclObject tclObject) throws TclException {
        TclList.setListFromAny(interp, tclObject);
        TclList tclList = (TclList)tclObject.getInternalRep();
        int n = tclList.vector.size();
        TclObject[] tclObjectArray = new TclObject[n];
        int n2 = 0;
        while (n2 < n) {
            tclObjectArray[n2] = (TclObject)tclList.vector.elementAt(n2);
            ++n2;
        }
        return tclObjectArray;
    }

    public static final TclObject index(Interp interp, TclObject tclObject, int n) throws TclException {
        TclList.setListFromAny(interp, tclObject);
        TclList tclList = (TclList)tclObject.getInternalRep();
        if (n < 0 || n >= tclList.vector.size()) {
            return null;
        }
        return (TclObject)tclList.vector.elementAt(n);
    }

    static final void insert(Interp interp, TclObject tclObject, int n, TclObject[] tclObjectArray, int n2, int n3) throws TclException {
        TclList.replace(interp, tclObject, n, 0, tclObjectArray, n2, n3);
    }

    public static final void replace(Interp interp, TclObject tclObject, int n, int n2, TclObject[] tclObjectArray, int n3, int n4) throws TclException {
        int n5;
        TclList.setListFromAny(interp, tclObject);
        tclObject.invalidateStringRep();
        TclList tclList = (TclList)tclObject.getInternalRep();
        int n6 = tclList.vector.size();
        if (n >= n6) {
            n = n6;
        } else {
            if (n < 0) {
                n = 0;
            }
            if (n2 > n6 - n) {
                n2 = n6 - n;
            }
            n5 = 0;
            while (n5 < n2) {
                TclObject tclObject2 = (TclObject)tclList.vector.elementAt(n);
                tclObject2.release();
                tclList.vector.removeElementAt(n);
                ++n5;
            }
        }
        n5 = n3;
        while (n5 <= n4) {
            tclObjectArray[n5].preserve();
            tclList.vector.insertElementAt(tclObjectArray[n5].takeExclusive(), n++);
            ++n5;
        }
    }

    static void sort(Interp interp, TclObject tclObject, int n, int n2, boolean bl, String string) throws TclException {
        TclList.setListFromAny(interp, tclObject);
        tclObject.invalidateStringRep();
        TclList tclList = (TclList)tclObject.getInternalRep();
        int n3 = tclList.vector.size();
        if (n3 <= 1) {
            return;
        }
        TclObject[] tclObjectArray = new TclObject[n3];
        int n4 = 0;
        while (n4 < n3) {
            tclObjectArray[n4] = (TclObject)tclList.vector.elementAt(n4);
            ++n4;
        }
        QSort qSort = new QSort();
        qSort.sort(interp, tclObjectArray, n, n2, bl, string);
        int n5 = 0;
        while (n5 < n3) {
            tclList.vector.setElementAt(tclObjectArray[n5], n5);
            tclObjectArray[n5] = null;
            ++n5;
        }
    }
}

