/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.standard;

import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.RootDoc;
import com.sun.tools.doclets.DocletAbortException;
import com.sun.tools.doclets.standard.AbstractPackageIndexWriter;
import com.sun.tools.doclets.standard.ConfigurationStandard;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class PackageIndexWriter
extends AbstractPackageIndexWriter {
    private RootDoc root;
    private Map groupPackageMap;
    private List groupList;

    protected void generateIndex() {
        int n = 0;
        while (n < this.groupList.size()) {
            String string = (String)this.groupList.get(n);
            List list = (List)this.groupPackageMap.get(string);
            if (list != null && list.size() > 0) {
                this.printIndexContents(list.toArray(new PackageDoc[list.size()]), string);
            }
            ++n;
        }
    }

    protected void printIndexFooter() {
        this.tableEnd();
        this.p();
        this.space();
    }

    protected void printNavigationBarFooter() {
        this.hr();
        this.navLinks(false);
        this.printBottom();
    }

    protected void printNavigationBarHeader() {
        this.navLinks(true);
        this.hr();
        this.printConfigurationTitle();
    }

    protected void printOverview() throws IOException {
        this.printOverviewComment();
        this.generateTagInfo(this.root);
    }

    protected void printOverviewComment() {
        if (this.root.inlineTags().length > 0) {
            this.anchor("overview_description");
            this.p();
            this.printInlineComment(this.root);
            this.p();
        }
    }

    protected void printOverviewHeader() {
        if (this.root.inlineTags().length > 0) {
            this.printSummaryComment(this.root);
            this.p();
            this.bold(this.getText("doclet.See"));
            this.br();
            this.printNbsps();
            this.printHyperLink("", "overview_description", this.getText("doclet.Description"), true);
            this.p();
        }
    }

    protected void printIndexRow(PackageDoc packageDoc) {
        if (packageDoc != null && packageDoc.name().length() > 0) {
            this.trBgcolorStyle("white", "TableRowColor");
            this.summaryRow(20);
            this.bold();
            this.printPackageLink(packageDoc);
            this.boldEnd();
            this.summaryRowEnd();
            this.summaryRow(0);
            this.printSummaryComment(packageDoc);
            this.summaryRowEnd();
            this.trEnd();
        }
    }

    public static void generate(ConfigurationStandard configurationStandard) {
        String string = "overview-summary.html";
        try {
            PackageIndexWriter packageIndexWriter = new PackageIndexWriter(configurationStandard, string);
            packageIndexWriter.generatePackageIndexFile(true);
            packageIndexWriter.close();
        }
        catch (IOException iOException) {
            configurationStandard.standardmessage.error("doclet.exception_encountered", iOException.toString(), string);
            throw new DocletAbortException();
        }
    }

    protected void printIndexHeader(String string) {
        this.tableIndexSummary();
        this.tableHeaderStart("#CCCCFF");
        this.bold(string);
        this.tableHeaderEnd();
    }

    public PackageIndexWriter(ConfigurationStandard configurationStandard, String string) throws IOException {
        super(configurationStandard, string);
        this.root = configurationStandard.root;
        this.groupPackageMap = configurationStandard.group.groupPackages(this.packages);
        this.groupList = configurationStandard.group.getGroupList();
    }
}

