/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javadoc;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.SeeTag;
import com.sun.tools.javac.v8.util.LayoutCharacters;
import com.sun.tools.javac.v8.util.ListBuffer;
import com.sun.tools.javadoc.ClassDocImpl;
import com.sun.tools.javadoc.DocImpl;
import com.sun.tools.javadoc.TagImpl;

class SeeTagImpl
extends TagImpl
implements SeeTag,
LayoutCharacters {
    private String where;
    private String what;
    private PackageDoc referencedPackage;
    private ClassDoc referencedClass;
    private MemberDoc referencedMember;
    String label = "";

    private void parseSeeString() {
        int n;
        int n2;
        int n3 = this.text.length();
        if (n3 == 0) {
            return;
        }
        switch (this.text.charAt(0)) {
            case '<': {
                if (this.text.charAt(n3 - 1) != '>') {
                    this.docenv().warning(this.holder, "tag.see.no_close_bracket_on_url", this.name, this.text);
                }
                return;
            }
            case '\"': {
                if (n3 == 1 || this.text.charAt(n3 - 1) != '\"') {
                    this.docenv().warning(this.holder, "tag.see.no_close_quote", this.name, this.text);
                }
                return;
            }
        }
        int n4 = 0;
        int n5 = 0;
        block11: for (int i = n2 = 0; i < n3; ++i) {
            char c = this.text.charAt(i);
            switch (c) {
                case '(': {
                    ++n4;
                    continue block11;
                }
                case ')': {
                    --n4;
                    continue block11;
                }
                case '#': 
                case '.': 
                case '[': 
                case ']': {
                    continue block11;
                }
                case ',': {
                    if (n4 > 0) continue block11;
                    this.docenv().warning(this.holder, "tag.see.malformed_see_tag", this.name, this.text);
                    return;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (n4 != 0) continue block11;
                    n5 = i;
                    i = n3;
                    continue block11;
                }
                default: {
                    if (Character.isJavaIdentifierPart(c)) continue block11;
                    this.docenv().warning(this.holder, "tag.see.illegal_character", this.name, "" + c, this.text);
                    return;
                }
            }
        }
        if (n4 != 0) {
            this.docenv().warning(this.holder, "tag.see.malformed_see_tag", this.name, this.text);
            return;
        }
        String string = "";
        String string2 = "";
        if (n5 > 0) {
            string = this.text.substring(n2, n5);
            string2 = this.text.substring(n5 + 1);
            for (n = 0; n < string2.length(); ++n) {
                char c = string2.charAt(n);
                if (c == ' ' || c == '\t' || c == '\n') continue;
                this.label = string2.substring(n);
                break;
            }
        } else {
            string = this.text;
            this.label = "";
        }
        if ((n = string.indexOf(35)) >= 0) {
            this.where = string.substring(0, n);
            this.what = string.substring(n + 1);
        } else if (string.indexOf(40) >= 0) {
            this.docenv().warning(this.holder, "tag.see.missing_sharp", this.name, this.text);
            this.where = "";
            this.what = string;
        } else {
            this.where = string;
            this.what = null;
        }
    }

    public ClassDoc referencedClass() {
        return this.referencedClass;
    }

    public MemberDoc referencedMember() {
        return this.referencedMember;
    }

    public PackageDoc referencedPackage() {
        return this.referencedPackage;
    }

    private void findReferenced(ClassDocImpl classDocImpl) {
        String string;
        if (this.where.length() > 0) {
            this.referencedClass = classDocImpl != null ? classDocImpl.findClass(this.where) : this.docenv().lookupClass(this.where);
            if (this.referencedClass == null) {
                this.referencedPackage = this.docenv().lookupPackage(this.where);
                return;
            }
        } else {
            if (classDocImpl == null) {
                this.docenv().warning(this.holder, "tag.see.class_not_specified", this.name, this.text);
                return;
            }
            this.referencedClass = classDocImpl;
        }
        this.where = this.referencedClass.qualifiedName();
        if (this.what == null) {
            return;
        }
        int n = this.what.indexOf(40);
        String string2 = string = n >= 0 ? this.what.substring(0, n) : this.what;
        if (n > 0) {
            String[] stringArray = new ParameterParseMachine(this.what.substring(n, this.what.length())).parseParameters();
            this.referencedMember = stringArray != null ? this.findExecutableMember(string, stringArray, this.referencedClass) : null;
        } else {
            this.referencedMember = this.findExecutableMember(string, null, this.referencedClass);
            FieldDoc fieldDoc = ((ClassDocImpl)this.referencedClass).findField(string);
            if (this.referencedMember == null || fieldDoc != null && fieldDoc.containingClass().subclassOf(this.referencedMember.containingClass())) {
                this.referencedMember = fieldDoc;
            }
        }
        if (this.referencedMember == null) {
            this.docenv().warning(this.holder, "tag.see.can_not_find_member", this.name, this.what, this.where);
        }
    }

    public String kind() {
        return "@see";
    }

    public String label() {
        return this.label;
    }

    public String referencedClassName() {
        return this.where;
    }

    public String referencedMemberName() {
        return this.what;
    }

    SeeTagImpl(DocImpl docImpl, String string, String string2) {
        super(docImpl, string, string2);
        this.parseSeeString();
        if (this.where != null) {
            ClassDocImpl classDocImpl = null;
            if (docImpl instanceof MemberDoc) {
                classDocImpl = (ClassDocImpl)((ProgramElementDoc)((Object)docImpl)).containingClass();
            } else if (docImpl instanceof ClassDoc) {
                classDocImpl = (ClassDocImpl)docImpl;
            }
            this.findReferenced(classDocImpl);
        }
    }

    private MemberDoc findExecutableMember(String string, String[] stringArray, ClassDoc classDoc) {
        if (string.equals(classDoc.name())) {
            return ((ClassDocImpl)classDoc).findConstructor(string, stringArray);
        }
        return ((ClassDocImpl)classDoc).findMethod(string, stringArray);
    }

    private MemberDoc findReferencedMethod(String string, String[] stringArray, ClassDoc classDoc) {
        MemberDoc memberDoc = this.findExecutableMember(string, stringArray, classDoc);
        ClassDoc[] classDocArray = classDoc.innerClasses();
        if (memberDoc == null) {
            for (int i = 0; i < classDocArray.length; ++i) {
                memberDoc = this.findReferencedMethod(string, stringArray, classDocArray[i]);
                if (memberDoc == null) continue;
                return memberDoc;
            }
        }
        return null;
    }

    class ParameterParseMachine {
        final int START = 0;
        final int TYPE = 1;
        final int NAME = 2;
        final int TNSPACE = 3;
        final int ARRAYDECORATION = 4;
        final int ARRAYSPACE = 5;
        String parameters;
        StringBuffer typeId;
        ListBuffer paramList;

        void addTypeToParamList() {
            if (this.typeId.length() > 0) {
                this.paramList.append(this.typeId.toString());
                this.typeId.setLength(0);
            }
        }

        public String[] parseParameters() {
            if (this.parameters.equals("()")) {
                return new String[0];
            }
            int n = 0;
            int n2 = 0;
            this.parameters = this.parameters.substring(1, this.parameters.length() - 1);
            char[] cArray = this.parameters.toCharArray();
            block7: for (int i = 0; i < cArray.length; ++i) {
                char c = cArray[i];
                switch (n) {
                    case 0: {
                        if (Character.isJavaIdentifierStart(c)) {
                            this.typeId.append(c);
                            n = 1;
                        }
                        n2 = 0;
                        continue block7;
                    }
                    case 1: {
                        if (Character.isJavaIdentifierPart(c) || c == '.') {
                            this.typeId.append(c);
                        } else if (c == '[') {
                            this.typeId.append(c);
                            n = 4;
                        } else if (Character.isWhitespace(c)) {
                            n = 3;
                        } else if (c == ',') {
                            this.addTypeToParamList();
                            n = 0;
                        }
                        n2 = 1;
                        continue block7;
                    }
                    case 3: {
                        if (Character.isJavaIdentifierStart(c)) {
                            if (n2 == 4) {
                                SeeTagImpl.this.docenv().warning(SeeTagImpl.this.holder, "tag.missing_comma_space", SeeTagImpl.this.name, "(" + this.parameters + ")");
                                return null;
                            }
                            this.addTypeToParamList();
                            n = 2;
                        } else if (c == '[') {
                            this.typeId.append(c);
                            n = 4;
                        } else if (c == ',') {
                            this.addTypeToParamList();
                            n = 0;
                        }
                        n2 = 3;
                        continue block7;
                    }
                    case 4: {
                        if (c == ']') {
                            this.typeId.append(c);
                            n = 3;
                        } else if (!Character.isWhitespace(c)) {
                            SeeTagImpl.this.docenv().warning(SeeTagImpl.this.holder, "tag.illegal_char_in_arr_dim", SeeTagImpl.this.name, "(" + this.parameters + ")");
                            return null;
                        }
                        n2 = 4;
                        continue block7;
                    }
                    case 2: {
                        if (c == ',') {
                            n = 0;
                        }
                        n2 = 2;
                    }
                }
            }
            if (n == 4 || n == 0 && n2 == 3) {
                SeeTagImpl.this.docenv().warning(SeeTagImpl.this.holder, "tag.illegal_see_tag", "(" + this.parameters + ")");
            }
            if (this.typeId.length() > 0) {
                this.paramList.append(this.typeId.toString());
            }
            return (String[])this.paramList.toArray(new String[this.paramList.length()]);
        }

        ParameterParseMachine(String string) {
            this.parameters = string;
            this.paramList = new ListBuffer();
            this.typeId = new StringBuffer();
        }
    }
}

