/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.transform;

import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.sax.SAXSource;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.output.SAXOutputter;
import org.jdom.output.XMLOutputter;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;

public class JDOMSource
extends SAXSource {
    public static final String JDOM_FEATURE = "http://org.jdom.transform.JDOMSource/feature";
    private XMLFilter xmlFilter = null;

    public JDOMSource(Document source) {
        this.setDocument(source);
    }

    public Document getDocument() {
        return ((JDOMInputSource)this.getInputSource()).getDocument();
    }

    public XMLReader getXMLReader() {
        XMLReader documentReader = new DocumentReader();
        if (this.xmlFilter != null) {
            XMLFilter root = this.xmlFilter;
            while (root.getParent() instanceof XMLFilter) {
                root = (XMLFilter)root.getParent();
            }
            root.setParent(documentReader);
            documentReader = this.xmlFilter;
        }
        return documentReader;
    }

    public void setDocument(Document source) {
        super.setInputSource(new JDOMInputSource(source));
    }

    public void setInputSource(InputSource inputSource) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void setXMLReader(XMLReader reader) throws UnsupportedOperationException {
        if (!(reader instanceof XMLFilter)) {
            throw new UnsupportedOperationException();
        }
        this.xmlFilter = (XMLFilter)reader;
    }

    private static class JDOMInputSource
    extends InputSource {
        private Document document = null;

        public JDOMInputSource(Document source) {
            this.setDocument(source);
        }

        public Reader getCharacterStream() {
            Document doc = this.getDocument();
            StringReader reader = null;
            if (doc != null) {
                reader = new StringReader(new XMLOutputter().outputString(doc));
            }
            return reader;
        }

        public Document getDocument() {
            return this.document;
        }

        public void setCharacterStream(Reader characterStream) throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        public void setDocument(Document source) {
            if (source == null) {
                throw new NullPointerException("source");
            }
            this.document = source;
        }
    }

    private static class DocumentReader
    implements XMLReader {
        private SAXOutputter saxOutputter = new SAXOutputter(new XMLFilterImpl());
        private ContentHandler contentHandler = null;
        private DTDHandler dtdHandler = null;
        private ErrorHandler errorHandler = null;
        private EntityResolver entityResolver = null;
        private Map features = new HashMap();

        public DocumentReader() {
            this.features.put("http://xml.org/sax/features/namespaces", Boolean.TRUE);
            this.features.put("http://xml.org/sax/features/namespace-prefixes", Boolean.FALSE);
        }

        public ContentHandler getContentHandler() {
            return this.contentHandler;
        }

        public DTDHandler getDTDHandler() {
            return this.dtdHandler;
        }

        public EntityResolver getEntityResolver() {
            return this.entityResolver;
        }

        public ErrorHandler getErrorHandler() {
            return this.errorHandler;
        }

        public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
            Boolean value = (Boolean)this.features.get(name);
            if (value != null) {
                return value;
            }
            throw new SAXNotRecognizedException(name);
        }

        public Object getProperty(String name) throws SAXNotRecognizedException {
            throw new SAXNotRecognizedException(name);
        }

        public void parse(String systemId) throws SAXNotSupportedException {
            throw new SAXNotSupportedException("Only JDOM Documents are supported as input");
        }

        public void parse(InputSource input) throws SAXException {
            if (input instanceof JDOMInputSource) {
                try {
                    this.saxOutputter.output(((JDOMInputSource)input).getDocument());
                }
                catch (JDOMException e) {
                    throw new SAXException(e.getMessage(), e);
                }
            } else {
                throw new SAXNotSupportedException("Only JDOM Documents are supported as input");
            }
        }

        public void setContentHandler(ContentHandler handler) {
            this.saxOutputter.setContentHandler(handler);
            this.contentHandler = handler;
        }

        public void setDTDHandler(DTDHandler handler) {
            if (handler == null) {
                throw new NullPointerException("handler");
            }
            this.saxOutputter.setDTDHandler(handler);
            this.dtdHandler = handler;
        }

        public void setEntityResolver(EntityResolver resolver) {
            if (resolver == null) {
                throw new NullPointerException("resolver");
            }
            this.saxOutputter.setEntityResolver(resolver);
            this.entityResolver = resolver;
        }

        public void setErrorHandler(ErrorHandler handler) {
            this.saxOutputter.setErrorHandler(handler);
            this.errorHandler = handler;
        }

        public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
            if (name.equals("http://xml.org/sax/features/namespace-prefixes")) {
                this.saxOutputter.setReportNamespaceDeclarations(value);
                this.features.put(name, new Boolean(value));
            } else if (name.equals("http://xml.org/sax/features/namespaces")) {
                if (!value) {
                    throw new SAXNotSupportedException(name);
                }
            } else {
                throw new SAXNotRecognizedException(name);
            }
        }

        public void setProperty(String name, Object value) throws SAXNotRecognizedException {
            throw new SAXNotRecognizedException(name);
        }
    }
}

