/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder;

import org.exolab.castor.builder.ClassInfo;
import org.exolab.castor.builder.CollectionInfo;
import org.exolab.castor.builder.FieldInfo;
import org.exolab.castor.builder.SGTypes;
import org.exolab.castor.builder.SourceGenerator;
import org.exolab.castor.builder.types.XSClass;
import org.exolab.castor.builder.types.XSList;
import org.exolab.castor.builder.types.XSType;
import org.exolab.castor.builder.util.DescriptorJClass;
import org.exolab.castor.xml.JavaNaming;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JConstructor;
import org.exolab.javasource.JField;
import org.exolab.javasource.JModifiers;
import org.exolab.javasource.JSourceCode;
import org.exolab.javasource.JType;

public class DescriptorSourceFactory {
    private static JClass _ClassDescriptorClass = new JClass("org.exolab.castor.mapping.ClassDescriptor");
    private static JClass _FieldDescriptorClass = new JClass("org.exolab.castor.mapping.FieldDescriptor");
    private static JClass fdImplClass = new JClass("org.exolab.castor.xml.util.XMLFieldDescriptorImpl");
    private static JClass fdClass = new JClass("org.exolab.castor.xml.XMLFieldDescriptor");
    private static JType fdArrayClass = fdClass.createArray();
    private static JClass gvrClass = new JClass("org.exolab.castor.xml.GroupValidationRule");
    private static JClass vrClass = new JClass("org.exolab.castor.xml.ValidationRule");
    private static final String DESCRIPTOR_NAME = "Descriptor";
    private static final String FIELD_VALIDATOR_NAME = "fieldValidator";

    public static JClass createSource(ClassInfo classInfo) {
        String xmlName;
        String nsURI;
        Object method = null;
        JSourceCode jsc = null;
        Object vcode = null;
        JClass jClass = classInfo.getJClass();
        String className = jClass.getName();
        String localClassName = jClass.getLocalName();
        String variableName = "_" + className;
        DescriptorJClass classDesc = new DescriptorJClass(className + DESCRIPTOR_NAME, jClass);
        JConstructor cons = classDesc.getConstructor(0);
        jsc = cons.getSourceCode();
        String nsPrefix = classInfo.getNamespacePrefix();
        if (nsPrefix != null && nsPrefix.length() > 0) {
            jsc.add("nsPrefix = \"");
            jsc.append(nsPrefix);
            jsc.append("\";");
        }
        if ((nsURI = classInfo.getNamespaceURI()) != null && nsURI.length() > 0) {
            jsc.add("nsURI = \"");
            jsc.append(nsURI);
            jsc.append("\";");
        }
        if ((xmlName = classInfo.getNodeName()) != null) {
            jsc.add("xmlName = \"");
            jsc.append(xmlName);
            jsc.append("\";");
        }
        if (classInfo.isChoice()) {
            jsc.add("");
            jsc.add("//-- set grouping compositor");
            jsc.add("setCompositorAsChoice();");
        } else if (classInfo.isSequence()) {
            jsc.add("");
            jsc.add("//-- set grouping compositor");
            jsc.add("setCompositorAsSequence();");
        }
        if (classInfo.getFieldCount() == 0) {
            return classDesc;
        }
        jsc.add("org.exolab.castor.xml.util.XMLFieldDescriptorImpl  desc           = null;");
        jsc.add("org.exolab.castor.xml.XMLFieldHandler              handler        = null;");
        jsc.add("org.exolab.castor.xml.FieldValidator               fieldValidator = null;");
        if (classInfo.allowContent()) {
            DescriptorSourceFactory.createDescriptor(classDesc, classInfo.getTextField(), localClassName, null, jsc);
        }
        ClassInfo base = classInfo.getBaseClass();
        FieldInfo[] atts = classInfo.getAttributeFields();
        jsc.add("//-- initialize attribute descriptors");
        jsc.add("");
        int i = 0;
        while (i < atts.length) {
            FieldInfo member = atts[i];
            if (!member.isTransient()) {
                if (base != null && base.getAttributeField(member.getNodeName()) != null) {
                    DescriptorSourceFactory.createRestrictedDescriptor(member, jsc);
                } else {
                    DescriptorSourceFactory.createDescriptor(classDesc, member, localClassName, nsURI, jsc);
                }
            }
            ++i;
        }
        FieldInfo[] elements = classInfo.getElementFields();
        jsc.add("//-- initialize element descriptors");
        jsc.add("");
        int i2 = 0;
        while (i2 < elements.length) {
            FieldInfo member = elements[i2];
            if (!member.isTransient()) {
                if (base != null && base.getElementField(member.getNodeName()) != null) {
                    DescriptorSourceFactory.createRestrictedDescriptor(member, jsc);
                } else {
                    DescriptorSourceFactory.createDescriptor(classDesc, member, localClassName, nsURI, jsc);
                }
            }
            ++i2;
        }
        return classDesc;
    }

    private static void createRestrictedDescriptor(FieldInfo member, JSourceCode jsc) {
        jsc.add("desc = (org.exolab.castor.xml.util.XMLFieldDescriptorImpl) getFieldDescriptor(\"");
        jsc.append(member.getNodeName());
        jsc.append("\"");
        if (member.getNodeType() == 1) {
            jsc.append(", org.exolab.castor.xml.NodeType.Element);");
        } else if (member.getNodeType() == 0) {
            jsc.append(", org.exolab.castor.xml.NodeType.Attribute);");
        }
        DescriptorSourceFactory.validationCode(member, jsc);
    }

    private static void createDescriptor(DescriptorJClass classDesc, FieldInfo member, String localClassName, String nsURI, JSourceCode jsc) {
        XSType xsType = member.getSchemaType();
        boolean any = false;
        boolean isElement = member.getNodeType() == 1;
        boolean isAttribute = member.getNodeType() == 0;
        boolean isText = member.getNodeType() == 2;
        jsc.add("//-- ");
        jsc.append(member.getName());
        if (member.getName().equals("_anyObject")) {
            any = true;
        }
        if (xsType.getType() == 45) {
            xsType = ((CollectionInfo)member).getContent().getSchemaType();
        }
        String nodeName = member.getNodeName();
        String nodeNameParam = null;
        if (nodeName != null && !isText) {
            nodeNameParam = "\"" + nodeName + "\"";
            if (SourceGenerator.classDescFieldNames()) {
                nodeNameParam = member.getNodeName().toUpperCase();
                JModifiers publicStaticFinal = new JModifiers();
                publicStaticFinal.makePublic();
                publicStaticFinal.setStatic(true);
                publicStaticFinal.setFinal(true);
                JField jField = new JField(SGTypes.String, nodeNameParam);
                jField.setModifiers(publicStaticFinal);
                jField.setInitString("\"" + nodeName + "\"");
                classDesc.addMember(jField);
            }
        }
        jsc.add("desc = new org.exolab.castor.xml.util.XMLFieldDescriptorImpl(");
        jsc.append(DescriptorSourceFactory.classType(xsType.getJType()));
        jsc.append(", \"");
        jsc.append(member.getName());
        jsc.append("\", ");
        if (nodeNameParam != null) {
            jsc.append(nodeNameParam);
        } else if (isText) {
            jsc.append("\"PCDATA\"");
        } else {
            jsc.append("(String)null");
        }
        if (isElement) {
            jsc.append(", org.exolab.castor.xml.NodeType.Element);");
        } else if (isAttribute) {
            jsc.append(", org.exolab.castor.xml.NodeType.Attribute);");
        } else if (isText) {
            jsc.append(", org.exolab.castor.xml.NodeType.Text);");
        }
        switch (xsType.getType()) {
            case 1: {
                jsc.add("desc.setImmutable(true);");
                break;
            }
            case 26: {
                jsc.add("desc.setReference(true);");
                break;
            }
            case 25: {
                jsc.add("this.identity = desc;");
                break;
            }
            case 18: {
                jsc.add("desc.setSchemaType(\"QName\");");
            }
        }
        if (member.getXMLFieldHandler() != null) {
            String handler = member.getXMLFieldHandler();
            jsc.add("desc.setHandler(new " + handler + "());");
        } else {
            DescriptorSourceFactory.createXMLFieldHandler(member, xsType, localClassName, jsc);
        }
        if (member.isContainer()) {
            jsc.add("desc.setContainer(true);");
            String className = xsType.getName();
            if (className.equals(localClassName)) {
                jsc.add("desc.setClassDescriptor(this);");
            } else {
                jsc.add("desc.setClassDescriptor(new " + className + DESCRIPTOR_NAME + "());");
            }
        }
        if ((nsURI = member.getNamespaceURI()) != null) {
            jsc.add("desc.setNameSpaceURI(\"");
            jsc.append(nsURI);
            jsc.append("\");");
        }
        if (any && member.getNamespaceURI() == null) {
            nsURI = null;
        }
        if (member.isRequired()) {
            jsc.add("desc.setRequired(true);");
        }
        if (any) {
            jsc.add("desc.setMatches(\"*\");");
        }
        if (isElement) {
            jsc.add("desc.setMultivalued(" + member.isMultivalued());
            jsc.append(");");
        }
        jsc.add("addFieldDescriptor(desc);");
        jsc.add("");
        DescriptorSourceFactory.validationCode(member, jsc);
    }

    private static void createXMLFieldHandler(FieldInfo member, XSType xsType, String localClassName, JSourceCode jsc) {
        boolean isContent;
        boolean any = false;
        boolean isEnumerated = false;
        if (member.getName().equals("_anyObject")) {
            any = true;
        }
        boolean isAttribute = member.getNodeType() == 0;
        boolean bl = isContent = member.getNodeType() == 2;
        if (xsType.getType() == 0) {
            isEnumerated = ((XSClass)xsType).isEnumerated();
        }
        jsc.add("handler = (new org.exolab.castor.xml.XMLFieldHandler() {");
        jsc.indent();
        jsc.add("public java.lang.Object getValue( java.lang.Object object ) ");
        jsc.indent();
        jsc.add("throws IllegalStateException");
        jsc.unindent();
        jsc.add("{");
        jsc.indent();
        jsc.add(localClassName);
        jsc.append(" target = (");
        jsc.append(localClassName);
        jsc.append(") object;");
        if (!xsType.isEnumerated() && xsType.getJType().isPrimitive() && !member.isMultivalued()) {
            jsc.add("if(!target." + member.getHasMethodName() + "())");
            jsc.indent();
            jsc.add("return null;");
            jsc.unindent();
        }
        jsc.add("return ");
        String value = "target." + member.getReadMethodName() + "()";
        if (member.isMultivalued()) {
            jsc.append(value);
        } else {
            jsc.append(xsType.createToJavaObjectCode(value));
        }
        jsc.append(";");
        jsc.unindent();
        jsc.add("}");
        jsc.add("public void setValue( java.lang.Object object, java.lang.Object value) ");
        jsc.indent();
        jsc.add("throws IllegalStateException, IllegalArgumentException");
        jsc.unindent();
        jsc.add("{");
        jsc.indent();
        jsc.add("try {");
        jsc.indent();
        jsc.add(localClassName);
        jsc.append(" target = (");
        jsc.append(localClassName);
        jsc.append(") object;");
        if (xsType.isPrimitive() && !SourceGenerator.usePrimitiveWrapper()) {
            if (!(member.isRequired() || xsType.isEnumerated() || member.isMultivalued())) {
                jsc.add("// if null, use delete method for optional primitives ");
                jsc.add("if (value == null) {");
                jsc.indent();
                jsc.add("target.");
                jsc.append(member.getDeleteMethodName());
                jsc.append("();");
                jsc.add("return;");
                jsc.unindent();
                jsc.add("}");
            } else {
                jsc.add("// ignore null values for non optional primitives");
                jsc.add("if (value == null) return;");
                jsc.add("");
            }
        }
        jsc.add("target.");
        jsc.append(member.getWriteMethodName());
        jsc.append("( ");
        if (xsType.isPrimitive() && !SourceGenerator.usePrimitiveWrapper()) {
            jsc.append(xsType.createFromJavaObjectCode("value"));
        } else if (any) {
            jsc.append(" value ");
        } else {
            jsc.append("(");
            jsc.append(xsType.getJType().toString());
            if (isAttribute | isContent && xsType.isDateTime() && xsType.getType() != 3) {
                jsc.append(".parse");
                jsc.append(JavaNaming.toJavaClassName(xsType.getName()));
                jsc.append("((String) value))");
            } else {
                jsc.append(") value");
            }
        }
        jsc.append(");");
        jsc.unindent();
        jsc.add("}");
        jsc.add("catch (java.lang.Exception ex) {");
        jsc.indent();
        jsc.add("throw new IllegalStateException(ex.toString());");
        jsc.unindent();
        jsc.add("}");
        jsc.unindent();
        jsc.add("}");
        jsc.add("public java.lang.Object newInstance( java.lang.Object parent ) {");
        jsc.indent();
        jsc.add("return ");
        boolean isAbstract = false;
        if (member.getDeclaringClassInfo() != null) {
            isAbstract = member.getDeclaringClassInfo().isAbstract();
        }
        if (any || isEnumerated || xsType.isPrimitive() || xsType.getJType().isArray() || xsType.getType() == 1 || isAbstract) {
            jsc.append("null;");
        } else {
            jsc.append(xsType.newInstanceCode());
        }
        jsc.unindent();
        jsc.add("}");
        jsc.unindent();
        jsc.add("} );");
        if (isEnumerated) {
            jsc.add("desc.setHandler( new org.exolab.castor.xml.handlers.EnumFieldHandler(");
            jsc.append(DescriptorSourceFactory.classType(xsType.getJType()));
            jsc.append(", handler));");
            jsc.add("desc.setImmutable(true);");
        } else if (xsType.getType() == 3) {
            jsc.add("desc.setHandler( new org.exolab.castor.xml.handlers.DateFieldHandler(");
            jsc.append("handler));");
            jsc.add("desc.setImmutable(true);");
        } else if (xsType.getType() == 16) {
            jsc.add("desc.setHandler(handler);");
            jsc.add("desc.setImmutable(true);");
        } else if (member.getSchemaType().getType() == 45) {
            switch (xsType.getType()) {
                case 30: 
                case 31: {
                    jsc.add("desc.setHandler( new org.exolab.castor.xml.handlers.CollectionFieldHandler(");
                    jsc.append("handler, new org.exolab.castor.xml.validators.NameValidator(org.exolab.castor.xml.validators.NameValidator.NMTOKEN)));");
                    break;
                }
                case 18: {
                    jsc.add("desc.setHandler( new org.exolab.castor.xml.handlers.CollectionFieldHandler(");
                    jsc.append("handler, null));");
                    break;
                }
                case 26: 
                case 27: {
                    jsc.add("desc.setMultivalued(" + member.isMultivalued());
                    jsc.append(");");
                }
                default: {
                    jsc.add("desc.setHandler(handler);");
                    break;
                }
            }
        } else {
            jsc.add("desc.setHandler(handler);");
        }
    }

    private static void validationCode(FieldInfo member, JSourceCode jsc) {
        if (member == null) {
            return;
        }
        if (jsc == null) {
            return;
        }
        jsc.add("//-- validation code for: ");
        jsc.append(member.getName());
        String validator = member.getValidator();
        if (validator != null && validator.length() > 0) {
            jsc.add("fieldValidator = new " + validator + "();");
        } else {
            jsc.add("fieldValidator = new org.exolab.castor.xml.FieldValidator();");
            if (member.getName().equals("_anyObject")) {
                jsc.add("desc.setValidator(fieldValidator);");
                return;
            }
            XSType xsType = member.getSchemaType();
            if (xsType.getType() == 45) {
                XSList xsList = (XSList)xsType;
                CollectionInfo cInfo = (CollectionInfo)member;
                FieldInfo content = cInfo.getContent();
                jsc.add("fieldValidator.setMinOccurs(");
                jsc.append(Integer.toString(xsList.getMinimumSize()));
                jsc.append(");");
                if (xsList.getMaximumSize() > 0) {
                    jsc.add("fieldValidator.setMaxOccurs(");
                    jsc.append(Integer.toString(xsList.getMaximumSize()));
                    jsc.append(");");
                }
                if ((xsType = ((CollectionInfo)member).getContent().getSchemaType()).getType() == 30) {
                    return;
                }
            } else if (member.isRequired()) {
                jsc.add("fieldValidator.setMinOccurs(1);");
            }
            jsc.add("{ //-- local scope");
            jsc.indent();
            xsType.validationCode(jsc, member.getFixedValue(), FIELD_VALIDATOR_NAME);
            jsc.unindent();
            jsc.add("}");
        }
        jsc.add("desc.setValidator(fieldValidator);");
    }

    private static String classType(JType jType) {
        if (jType.isPrimitive()) {
            if (jType == JType.Int) {
                return "java.lang.Integer.TYPE";
            }
            if (jType == JType.Double) {
                return "java.lang.Double.TYPE";
            }
            if (jType == JType.Boolean) {
                return "java.lang.Boolean.TYPE";
            }
        }
        return jType.toString() + ".class";
    }
}

