/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.persist;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.transaction.xa.Xid;
import org.exolab.castor.jdo.ClassNotPersistenceCapableException;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.jdo.DuplicateIdentityException;
import org.exolab.castor.jdo.LockNotGrantedException;
import org.exolab.castor.jdo.ObjectDeletedException;
import org.exolab.castor.jdo.ObjectModifiedException;
import org.exolab.castor.jdo.ObjectNotFoundException;
import org.exolab.castor.jdo.ObjectNotPersistentException;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.jdo.QueryException;
import org.exolab.castor.jdo.TransactionAbortedException;
import org.exolab.castor.mapping.AccessMode;
import org.exolab.castor.persist.ClassMolder;
import org.exolab.castor.persist.LockEngine;
import org.exolab.castor.persist.OID;
import org.exolab.castor.persist.ObjectDeletedWaitingForLockException;
import org.exolab.castor.persist.ObjectLock;
import org.exolab.castor.persist.PersistenceInfoGroup;
import org.exolab.castor.persist.QueryResults;
import org.exolab.castor.persist.TxSynchronizable;
import org.exolab.castor.persist.spi.CallbackInterceptor;
import org.exolab.castor.persist.spi.InstanceFactory;
import org.exolab.castor.persist.spi.PersistenceQuery;
import org.exolab.castor.util.Messages;

public abstract class TransactionContext {
    public static int OBJECT_STATE_TRANSIENT = 0;
    public static int OBJECT_STATE_HOLLOW = 1;
    public static int OBJECT_STATE_READ_ONLY = 2;
    public static int OBJECT_STATE_PERSISTENT = 3;
    public static int OBJECT_STATE_PERSISTENT_NEW = 4;
    public static int OBJECT_STATE_PERSISTENT_DELETED = 5;
    public static int OBJECT_STATE_PERSISTENT_NEW_DELETED = 6;
    private ObjectLock _waitOnLock;
    private final Vector _objects = new Vector();
    private final Hashtable _engineOids = new Hashtable();
    private final Hashtable _readOnlyObjects = new Hashtable();
    private int _status;
    private int _lockTimeout = 30;
    private final Xid _xid;
    private int _txTimeout = 30;
    private ObjectEntry _deletedList;
    private Database _db;
    private boolean _autoStore;
    private CallbackInterceptor _callback;
    private InstanceFactory _instanceFactory;
    private boolean _creating;
    private ArrayList _synchronizeList = new ArrayList();

    public TransactionContext(Database db) {
        this._xid = null;
        this._status = 0;
        this._db = db;
    }

    public TransactionContext(Database db, Xid xid) {
        this._xid = xid;
        this._status = 0;
        this._db = db;
    }

    public void addTxSynchronizable(TxSynchronizable synchronizable) {
        this._synchronizeList.add(synchronizable);
    }

    public void removeTxSynchronizable(TxSynchronizable synchronizable) {
        ((AbstractCollection)this._synchronizeList).remove(synchronizable);
    }

    protected void txcommitted() {
        int i = 0;
        while (i < this._synchronizeList.size()) {
            TxSynchronizable sync = (TxSynchronizable)this._synchronizeList.get(i);
            try {
                sync.committed(this);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
    }

    protected void txrolledback() {
        int i = 0;
        while (i < this._synchronizeList.size()) {
            TxSynchronizable sync = (TxSynchronizable)this._synchronizeList.get(i);
            try {
                sync.rolledback(this);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
    }

    public void setAutoStore(boolean autoStore) {
        this._autoStore = autoStore;
    }

    public boolean isAutoStore() {
        return this._autoStore;
    }

    public void setCallback(CallbackInterceptor callback) {
        this._callback = callback;
    }

    public void setInstanceFactory(InstanceFactory factory) {
        this._instanceFactory = factory;
    }

    public PersistenceInfoGroup getScope() {
        return this._db.getScope();
    }

    public void setTransactionTimeout(int timeout) {
        this._txTimeout = timeout;
    }

    public int getTransactionTimeout() {
        return this._txTimeout;
    }

    public int getLockTimeout() {
        return this._lockTimeout;
    }

    public void setLockTimeout(int timeout) {
        this._lockTimeout = timeout >= 0 ? timeout : 0;
    }

    public abstract Object getConnection(LockEngine var1) throws PersistenceException;

    protected abstract void commitConnections() throws TransactionAbortedException;

    protected abstract void closeConnections() throws TransactionAbortedException;

    protected abstract void rollbackConnections();

    public synchronized Object fetch(LockEngine engine, ClassMolder molder, Object identity, AccessMode suggestedAccessMode) throws ObjectNotFoundException, LockNotGrantedException, PersistenceException {
        ObjectEntry entry = null;
        if (identity == null) {
            throw new PersistenceException("Identities can't be null!");
        }
        OID oid = new OID(engine, molder, identity);
        AccessMode accessMode = molder.getAccessMode(suggestedAccessMode);
        if (accessMode == AccessMode.ReadOnly) {
            entry = this.getReadOnlyObjectEntry(oid);
        }
        if (entry == null) {
            entry = this.getObjectEntry(engine, oid);
        }
        if (entry != null) {
            if (entry.engine != engine) {
                throw new PersistenceException(Messages.format("persist.multipleLoad", molder.getName(), identity));
            }
            if (entry.deleted) {
                return null;
            }
            if (!molder.isAssignableFrom(entry.object.getClass())) {
                throw new PersistenceException(Messages.format("persist.typeMismatch", molder.getName(), identity));
            }
            if (entry.created) {
                return entry.object;
            }
            if (!(accessMode != AccessMode.Exclusive && accessMode != AccessMode.DbLocked || entry.oid.isDbLock())) {
                throw new PersistenceException(Messages.format("persist.lockConflict", molder.getName(), identity));
            }
            return entry.object;
        }
        return null;
    }

    public synchronized Object load(LockEngine engine, ClassMolder molder, Object identity, Object objectToBeLoaded, AccessMode suggestedAccessMode) throws ObjectNotFoundException, LockNotGrantedException, PersistenceException {
        return this.load(engine, molder, identity, objectToBeLoaded, suggestedAccessMode, null);
    }

    public synchronized Object load(LockEngine engine, ClassMolder molder, Object identity, Object objectToBeLoaded, AccessMode suggestedAccessMode, QueryResults results) throws ObjectNotFoundException, LockNotGrantedException, PersistenceException {
        ObjectEntry entry = null;
        Object object = null;
        if (identity == null) {
            throw new PersistenceException("Identities can't be null!");
        }
        OID oid = new OID(engine, molder, identity);
        if (objectToBeLoaded != null && !molder.getJavaClass(this._db.getClassLoader()).isAssignableFrom(objectToBeLoaded.getClass())) {
            throw new PersistenceException(Messages.format("persist.typeMismatch", molder.getName(), objectToBeLoaded.getClass()));
        }
        AccessMode accessMode = molder.getAccessMode(suggestedAccessMode);
        if (accessMode == AccessMode.ReadOnly) {
            entry = this.getReadOnlyObjectEntry(oid);
        }
        if (entry == null) {
            entry = this.getObjectEntry(engine, oid);
        }
        if (entry != null) {
            if (objectToBeLoaded != null && objectToBeLoaded != entry.object) {
                throw new PersistenceException(Messages.format("persist.multipleLoad", molder.getName(), identity));
            }
            if (entry.engine != engine) {
                throw new PersistenceException(Messages.format("persist.multipleLoad", molder.getName(), identity));
            }
            if (entry.deleted) {
                throw new ObjectNotFoundException("Object is deleted" + molder.getName() + identity);
            }
            if (!molder.getJavaClass(this._db.getClassLoader()).isAssignableFrom(entry.object.getClass())) {
                throw new PersistenceException(Messages.format("persist.typeMismatch", molder.getName(), entry.object.getClass()));
            }
            if (entry.created) {
                return entry.object;
            }
            if (!(accessMode != AccessMode.Exclusive && accessMode != AccessMode.DbLocked || entry.oid.isDbLock())) {
                throw new PersistenceException(Messages.format("persist.lockConflict", molder.getName(), identity));
            }
            return entry.object;
        }
        try {
            object = objectToBeLoaded != null ? objectToBeLoaded : (this._instanceFactory != null ? this._instanceFactory.newInstance(molder.getName(), this._db.getClassLoader()) : molder.newInstance(this._db.getClassLoader()));
            entry = this.addObjectEntry(oid, object);
            oid = engine.load(this, oid, object, suggestedAccessMode, this._lockTimeout, results);
            entry = this.rehash(object, oid);
        }
        catch (ObjectNotFoundException except) {
            this.removeObjectEntry(object);
            throw except;
        }
        catch (LockNotGrantedException except) {
            this.removeObjectEntry(object);
            throw except;
        }
        catch (ClassNotPersistenceCapableException except) {
            this.removeObjectEntry(object);
            throw new PersistenceException(Messages.format("persist.nested", except));
        }
        try {
            if (this._callback != null) {
                this._callback.using(object, this._db);
                this._callback.loaded(object, TransactionContext.toDatabaseAccessMode(accessMode));
            } else if (molder.getCallback() != null) {
                molder.getCallback().using(object, this._db);
                molder.getCallback().loaded(object, TransactionContext.toDatabaseAccessMode(accessMode));
            }
        }
        catch (Exception except) {
            this.release(object);
            throw new PersistenceException(Messages.format("persist.nested", except));
        }
        if (accessMode == AccessMode.ReadOnly) {
            this.makeReadOnly(object);
        }
        return object;
    }

    public synchronized QueryResults query(LockEngine engine, PersistenceQuery query, AccessMode accessMode, boolean scrollable) throws QueryException, PersistenceException {
        query.execute(this.getConnection(engine), accessMode, scrollable);
        return new QueryResults(this, engine, query, accessMode, this._db);
    }

    public synchronized QueryResults query(LockEngine engine, PersistenceQuery query, AccessMode accessMode) throws QueryException, PersistenceException {
        return this.query(engine, query, accessMode, false);
    }

    public synchronized void markCreate(LockEngine engine, ClassMolder molder, Object object, OID depended) throws DuplicateIdentityException, PersistenceException {
        if (object == null) {
            throw new NullPointerException();
        }
        Object identity = molder.getIdentity(this, object);
        ObjectEntry entry = this.getObjectEntry(object);
        if (this._autoStore && entry != null && entry.object == object) {
            return;
        }
        if (entry != null && !entry.deleted) {
            throw new PersistenceException(Messages.format("persist.objectAlreadyPersistent", object.getClass().getName(), entry.oid.getIdentity()));
        }
        OID oid = new OID(engine, molder, depended, identity);
        entry = this.getObjectEntry(engine, oid);
        if (identity != null && entry != null) {
            if (!entry.deleted || entry.object != object) {
                throw new DuplicateIdentityException(Messages.format("persist.duplicateIdentity", object.getClass().getName(), identity));
            }
            if (this._deletedList != null) {
                if (this._deletedList == entry) {
                    this._deletedList = entry.nextDeleted;
                } else {
                    ObjectEntry deleted = this._deletedList;
                    while (deleted.nextDeleted != null && deleted.nextDeleted != entry) {
                        deleted = deleted.nextDeleted;
                    }
                    if (deleted.nextDeleted == entry) {
                        deleted.nextDeleted = entry.nextDeleted;
                    } else {
                        throw new PersistenceException(Messages.format("persist.deletedNotFound", identity));
                    }
                }
            }
        }
        try {
            entry = this.addObjectEntry(oid, object);
            entry.creating = true;
            if (this._callback != null) {
                this._callback.creating(entry.object, this._db);
            } else if (entry.molder.getCallback() != null) {
                entry.molder.getCallback().creating(entry.object, this._db);
            }
            engine.markCreate(this, oid, object);
        }
        catch (LockNotGrantedException lneg) {
            this.removeObjectEntry(object);
            throw new DuplicateIdentityException("");
        }
        catch (PersistenceException pe) {
            this.removeObjectEntry(object);
            throw pe;
        }
        catch (Exception e) {
            this.removeObjectEntry(object);
            throw new PersistenceException(Messages.format("persist.nested", e));
        }
    }

    public synchronized void create(LockEngine engine, ClassMolder molder, Object object, OID depended) throws DuplicateIdentityException, PersistenceException {
        ObjectEntry enumEntry;
        Enumeration enumeration;
        boolean walk = false;
        if (!this._creating) {
            walk = true;
            this._creating = true;
        }
        try {
            this.markCreate(engine, molder, object, depended);
        }
        catch (DuplicateIdentityException e) {
            if (walk) {
                this._creating = false;
            }
            throw e;
        }
        catch (PersistenceException e) {
            if (walk) {
                this._creating = false;
            }
            throw e;
        }
        int priority = 0;
        int nextPrior = 0;
        boolean nextCreate = walk;
        while (nextCreate) {
            enumeration = this._objects.elements();
            nextCreate = false;
            while (enumeration.hasMoreElements()) {
                enumEntry = (ObjectEntry)enumeration.nextElement();
                try {
                    if (!enumEntry.creating || enumEntry.deleted) continue;
                    if (enumEntry.molder.getPriority() <= priority) {
                        OID oid = enumEntry.engine.create(this, enumEntry.oid, enumEntry.object);
                        if (oid.getIdentity() == null) {
                            throw new IllegalStateException("oid.getIdentity() is null after create!");
                        }
                        ObjectEntry entry = this.rehash(enumEntry.object, oid);
                        entry.created = true;
                        entry.creating = false;
                        if (this._callback != null) {
                            this._callback.using(entry.object, this._db);
                            this._callback.created(entry.object);
                            continue;
                        }
                        if (enumEntry.molder.getCallback() == null) continue;
                        enumEntry.molder.getCallback().using(entry.object, this._db);
                        enumEntry.molder.getCallback().created(entry.object);
                        continue;
                    }
                    nextPrior = Math.min(priority + 1, enumEntry.molder.getPriority());
                    nextCreate = true;
                }
                catch (Exception except) {
                    if (this._callback != null) {
                        this._callback.releasing(enumEntry.object, false);
                    } else if (molder.getCallback() != null) {
                        molder.getCallback().releasing(enumEntry.object, false);
                    }
                    this.removeObjectEntry(enumEntry.object);
                    if (except instanceof DuplicateIdentityException) {
                        throw (DuplicateIdentityException)except;
                    }
                    if (except instanceof PersistenceException) {
                        throw (PersistenceException)except;
                    }
                    throw new PersistenceException(Messages.format("persist.nested", except));
                }
            }
            priority = nextPrior;
        }
        if (walk) {
            enumeration = this._objects.elements();
            while (enumeration.hasMoreElements()) {
                enumEntry = (ObjectEntry)enumeration.nextElement();
                if (!enumEntry.created || !enumEntry.updateCacheNeeded) continue;
                enumEntry.engine.updateCache(this, enumEntry.oid, enumEntry.object);
                enumEntry.updateCacheNeeded = false;
            }
            this._creating = false;
        }
    }

    public boolean markUpdate(LockEngine engine, ClassMolder molder, Object object, OID depended) throws DuplicateIdentityException, ObjectModifiedException, ClassNotPersistenceCapableException, PersistenceException {
        if (object == null) {
            throw new NullPointerException();
        }
        Object identity = molder.getActualIdentity(this, object);
        if (molder.isDefaultIdentity(identity)) {
            identity = null;
        }
        OID oid = new OID(engine, molder, depended, identity);
        ObjectEntry entry = this.getObjectEntry(engine, oid);
        if (this._autoStore && entry != null && entry.object == object) {
            return false;
        }
        if (entry != null) {
            if (entry.deleted) {
                throw new ObjectDeletedException(Messages.format("persist.objectDeleted", object.getClass(), identity));
            }
            throw new DuplicateIdentityException("update object which is already in the transaction");
        }
        try {
            entry = this.addObjectEntry(oid, object);
            entry.creating = entry.engine.update(this, oid, object, null, 0);
        }
        catch (DuplicateIdentityException lneg) {
            this.removeObjectEntry(object);
            throw lneg;
        }
        catch (PersistenceException pe) {
            this.removeObjectEntry(object);
            throw pe;
        }
        catch (Exception e) {
            this.removeObjectEntry(object);
            throw new PersistenceException(Messages.format("persist.nested", e));
        }
        if (!entry.creating) {
            try {
                if (this._callback != null) {
                    this._callback.using(object, this._db);
                    this._callback.updated(object);
                } else if (molder.getCallback() != null) {
                    molder.getCallback().using(object, this._db);
                    molder.getCallback().updated(object);
                }
            }
            catch (Exception except) {
                this.release(object);
                if (except instanceof PersistenceException) {
                    throw (PersistenceException)except;
                }
                throw new PersistenceException(except.getMessage(), except);
            }
            return false;
        }
        return true;
    }

    public synchronized void update(LockEngine engine, ClassMolder molder, Object object, OID depended) throws DuplicateIdentityException, ObjectModifiedException, ClassNotPersistenceCapableException, PersistenceException {
        ObjectEntry enumEntry;
        Enumeration enumeration;
        boolean walk = false;
        if (!this._creating) {
            walk = true;
            this._creating = true;
        }
        try {
            this.markUpdate(engine, molder, object, depended);
        }
        catch (DuplicateIdentityException e) {
            if (walk) {
                this._creating = false;
            }
            throw e;
        }
        catch (PersistenceException e) {
            if (walk) {
                this._creating = false;
            }
            throw e;
        }
        int priority = 0;
        int nextPrior = 0;
        boolean nextCreate = walk;
        while (nextCreate) {
            enumeration = this._objects.elements();
            nextCreate = false;
            while (enumeration.hasMoreElements()) {
                enumEntry = (ObjectEntry)enumeration.nextElement();
                try {
                    if (!enumEntry.creating || enumEntry.deleted) continue;
                    if (enumEntry.molder.getPriority() <= priority) {
                        if (this._callback != null) {
                            this._callback.creating(enumEntry.object, this._db);
                        } else if (enumEntry.molder.getCallback() != null) {
                            enumEntry.molder.getCallback().creating(enumEntry.object, this._db);
                        }
                        OID oid = enumEntry.engine.create(this, enumEntry.oid, enumEntry.object);
                        if (oid.getIdentity() == null) {
                            throw new IllegalStateException("oid.getIdentity() is null after create!");
                        }
                        ObjectEntry entry = this.rehash(enumEntry.object, oid);
                        entry.created = true;
                        entry.creating = false;
                        if (this._callback != null) {
                            this._callback.using(entry.object, this._db);
                            this._callback.created(entry.object);
                            continue;
                        }
                        if (enumEntry.molder.getCallback() == null) continue;
                        enumEntry.molder.getCallback().using(entry.object, this._db);
                        enumEntry.molder.getCallback().created(entry.object);
                        continue;
                    }
                    nextPrior = Math.min(priority + 1, enumEntry.molder.getPriority());
                    nextCreate = true;
                }
                catch (Exception except) {
                    if (this._callback != null) {
                        this._callback.releasing(enumEntry.object, false);
                    } else if (molder.getCallback() != null) {
                        molder.getCallback().releasing(enumEntry.object, false);
                    }
                    this.removeObjectEntry(enumEntry.object);
                    if (except instanceof DuplicateIdentityException) {
                        throw (DuplicateIdentityException)except;
                    }
                    if (except instanceof PersistenceException) {
                        throw (PersistenceException)except;
                    }
                    except.printStackTrace();
                    throw new PersistenceException(Messages.format("persist.nested", except));
                }
            }
            priority = nextPrior;
        }
        if (walk) {
            enumeration = this._objects.elements();
            while (enumeration.hasMoreElements()) {
                enumEntry = (ObjectEntry)enumeration.nextElement();
                if (!enumEntry.created || !enumEntry.updateCacheNeeded) continue;
                enumEntry.engine.updateCache(this, enumEntry.oid, enumEntry.object);
                enumEntry.updateCacheNeeded = false;
            }
            this._creating = false;
        }
    }

    public synchronized void delete(Object object) throws ObjectNotPersistentException, LockNotGrantedException, PersistenceException {
        if (object == null) {
            throw new PersistenceException("Object to be deleted is null!");
        }
        ObjectEntry entry = this.getObjectEntry(object);
        if (entry == null) {
            throw new ObjectNotPersistentException(Messages.format("persist.objectNotPersistent", object.getClass().getName()));
        }
        if (entry.deleted) {
            throw new ObjectDeletedException(Messages.format("persist.objectDeleted", object.getClass().getName(), entry.oid.getIdentity()));
        }
        try {
            if (this._callback != null) {
                this._callback.removing(entry.object);
            } else if (entry.molder.getCallback() != null) {
                entry.molder.getCallback().removing(entry.object);
            }
        }
        catch (Exception except) {
            throw new PersistenceException(Messages.format("persist.nested", except));
        }
        try {
            entry.deleted = true;
            entry.engine.softLock(this, entry.oid, this._lockTimeout);
            entry.engine.markDelete(this, entry.oid, object, this._lockTimeout);
            if (this._deletedList == null) {
                this._deletedList = entry;
            } else {
                ObjectEntry deleted = this._deletedList;
                while (deleted.nextDeleted != null) {
                    deleted = deleted.nextDeleted;
                }
                deleted.nextDeleted = entry;
            }
            try {
                if (this._callback != null) {
                    this._callback.removed(entry.object);
                } else if (entry.molder.getCallback() != null) {
                    entry.molder.getCallback().removed(entry.object);
                }
            }
            catch (Exception except) {
                throw new PersistenceException(Messages.format("persist.nested", except));
            }
        }
        catch (ObjectDeletedException except) {
            this.removeObjectEntry(object);
        }
    }

    public synchronized void writeLock(Object object, int timeout) throws ObjectNotPersistentException, LockNotGrantedException, PersistenceException {
        if (object == null) {
            throw new PersistenceException("Object to acquire lock is null!");
        }
        ObjectEntry entry = this.getObjectEntry(object);
        if (entry == null) {
            throw new ObjectNotPersistentException(Messages.format("persist.objectNotPersistent", object.getClass().getName()));
        }
        if (entry.deleted) {
            throw new ObjectDeletedException(Messages.format("persist.objectDeleted", object.getClass(), entry.oid.getIdentity()));
        }
        try {
            entry.engine.writeLock(this, entry.oid, timeout);
        }
        catch (ObjectDeletedException except) {
            this.removeObjectEntry(object);
            throw new ObjectNotPersistentException(Messages.format("persist.objectNotPersistent", object.getClass().getName()));
        }
        catch (LockNotGrantedException except) {
            throw except;
        }
    }

    public synchronized void markModified(Object object, boolean updatePersist, boolean updateCache) {
        ObjectEntry entry = this.getObjectEntry(object);
        if (entry != null) {
            if (updatePersist) {
                entry.updatePersistNeeded = true;
            }
            if (updateCache) {
                entry.updateCacheNeeded = true;
            }
            if (updatePersist || updateCache) {
                // empty if block
            }
        }
    }

    public synchronized void softLock(Object object, int timeout) throws LockNotGrantedException, ObjectNotPersistentException {
        if (object == null) {
            throw new ObjectNotPersistentException("Object to acquire lock is null!");
        }
        ObjectEntry entry = this.getObjectEntry(object);
        if (entry == null) {
            throw new ObjectNotPersistentException(Messages.format("persist.objectNotPersistent", object.getClass().getName()));
        }
        if (entry.deleted) {
            throw new ObjectDeletedException(Messages.format("persist.objectDeleted", object.getClass().getName(), entry.oid.getIdentity()));
        }
        try {
            entry.engine.softLock(this, entry.oid, timeout);
        }
        catch (ObjectDeletedWaitingForLockException except) {
            this.removeObjectEntry(object);
            throw except;
        }
        catch (LockNotGrantedException except) {
            throw except;
        }
    }

    public synchronized void release(Object object) throws ObjectNotPersistentException, PersistenceException {
        if (object == null) {
            throw new PersistenceException("Object to release lock is null!");
        }
        ObjectEntry entry = this.getObjectEntry(object);
        if (entry == null || entry.deleted) {
            throw new ObjectNotPersistentException(Messages.format("persist.objectNotPersistent", object.getClass().getName().getClass()));
        }
        entry.engine.releaseLock(this, entry.oid);
        this.removeObjectEntry(object);
        if (this._callback != null) {
            this._callback.releasing(object, false);
        } else if (entry.molder.getCallback() != null) {
            entry.molder.getCallback().releasing(object, false);
        }
    }

    public synchronized boolean prepare() throws TransactionAbortedException {
        if (this._status == 1) {
            throw new TransactionAbortedException("persist.markedRollback");
        }
        if (this._status != 0) {
            throw new IllegalStateException(Messages.message("persist.noTransaction"));
        }
        try {
            ObjectEntry entry;
            Enumeration enumeration;
            if (this._objects.size() == 0) {
                this._status = 2;
                return false;
            }
            Vector<ObjectEntry> done = new Vector<ObjectEntry>();
            while (this._objects.size() != done.size()) {
                Vector<ObjectEntry> todo = new Vector<ObjectEntry>();
                enumeration = this._objects.elements();
                while (enumeration.hasMoreElements()) {
                    entry = (ObjectEntry)enumeration.nextElement();
                    if (done.contains(entry)) continue;
                    todo.addElement(entry);
                }
                enumeration = todo.elements();
                while (enumeration.hasMoreElements()) {
                    OID oid;
                    entry = (ObjectEntry)enumeration.nextElement();
                    if (!entry.deleted && !entry.creating && (oid = entry.engine.preStore(this, entry.oid, entry.object, this._lockTimeout)) != null) {
                        entry.oid = oid;
                        entry.updateCacheNeeded = true;
                    }
                    done.addElement(entry);
                }
            }
            int priority = 0;
            int nextPrior = 0;
            boolean nextCreate = true;
            while (nextCreate) {
                enumeration = this._objects.elements();
                nextCreate = false;
                while (enumeration.hasMoreElements()) {
                    ObjectEntry enumEntry = (ObjectEntry)enumeration.nextElement();
                    try {
                        if (!enumEntry.creating || enumEntry.deleted || enumEntry.created) continue;
                        if (enumEntry.molder.getPriority() <= priority) {
                            if (this._callback != null) {
                                this._callback.creating(enumEntry.object, this._db);
                            } else if (enumEntry.molder.getCallback() != null) {
                                enumEntry.molder.getCallback().creating(enumEntry.object, this._db);
                            }
                            OID oid = enumEntry.engine.create(this, enumEntry.oid, enumEntry.object);
                            if (oid.getIdentity() == null) {
                                throw new IllegalStateException("oid.getIdentity() is null after create!");
                            }
                            entry = this.rehash(enumEntry.object, oid);
                            entry.created = true;
                            if (this._callback != null) {
                                this._callback.using(entry.object, this._db);
                                this._callback.created(entry.object);
                                continue;
                            }
                            if (enumEntry.molder.getCallback() == null) continue;
                            enumEntry.molder.getCallback().using(entry.object, this._db);
                            enumEntry.molder.getCallback().created(entry.object);
                            continue;
                        }
                        nextPrior = Math.min(priority + 1, enumEntry.molder.getPriority());
                        nextCreate = true;
                    }
                    catch (Exception except) {
                        if (this._callback != null) {
                            this._callback.releasing(enumEntry.object, false);
                        } else if (enumEntry.molder.getCallback() != null) {
                            enumEntry.molder.getCallback().releasing(enumEntry.object, false);
                        }
                        this.removeObjectEntry(enumEntry.object);
                        if (except instanceof DuplicateIdentityException) {
                            throw (DuplicateIdentityException)except;
                        }
                        if (except instanceof PersistenceException) {
                            throw (PersistenceException)except;
                        }
                        throw new PersistenceException(Messages.format("persist.nested", except));
                    }
                }
                priority = nextPrior;
            }
            enumeration = this._objects.elements();
            while (enumeration.hasMoreElements()) {
                entry = (ObjectEntry)enumeration.nextElement();
                if (!entry.deleted && !entry.creating && entry.updatePersistNeeded) {
                    entry.engine.store(this, entry.oid, entry.object);
                }
                if (!entry.deleted && !entry.creating && entry.updateCacheNeeded) {
                    entry.engine.softLock(this, entry.oid, this._lockTimeout);
                }
                if (!entry.deleted && this._callback != null) {
                    try {
                        this._callback.storing(entry.object, entry.updateCacheNeeded);
                        continue;
                    }
                    catch (Exception except) {
                        throw new TransactionAbortedException(Messages.format("persist.nested", except), except);
                    }
                }
                if (entry.deleted || entry.molder.getCallback() == null) continue;
                try {
                    entry.molder.getCallback().storing(entry.object, entry.updateCacheNeeded);
                }
                catch (Exception except) {
                    throw new TransactionAbortedException(Messages.format("persist.nested", except), except);
                }
            }
            this._status = 7;
            entry = this._deletedList;
            int maxPriority = 0;
            while (entry != null) {
                maxPriority = Math.max(maxPriority, entry.molder.getPriority());
                entry = entry.nextDeleted;
            }
            int i = maxPriority;
            while (i >= 0) {
                entry = this._deletedList;
                while (entry != null) {
                    if (entry.molder.getPriority() == i) {
                        entry.engine.delete(this, entry.oid, entry.object);
                    }
                    entry = entry.nextDeleted;
                }
                --i;
            }
            this._deletedList = null;
            this._status = 2;
            return true;
        }
        catch (Exception except) {
            this._status = 1;
            if (except instanceof TransactionAbortedException) {
                throw (TransactionAbortedException)except;
            }
            throw new TransactionAbortedException(Messages.format("persist.nested", except), except);
        }
    }

    public synchronized void commit() throws TransactionAbortedException {
        if (this._status == 1) {
            throw new TransactionAbortedException("persist.markedRollback");
        }
        if (this._status != 2) {
            throw new IllegalStateException(Messages.message("persist.missingPrepare"));
        }
        try {
            this._status = 8;
            this.commitConnections();
        }
        catch (Exception except) {
            this._status = 1;
            throw new TransactionAbortedException(Messages.format("persist.nested", except), except);
        }
        Enumeration enumeration = this._objects.elements();
        while (enumeration.hasMoreElements()) {
            ObjectEntry entry = (ObjectEntry)enumeration.nextElement();
            if (entry.deleted) {
                entry.engine.forgetObject(this, entry.oid);
                entry.molder.setFieldsNull(entry.object);
            } else {
                if (entry.updateCacheNeeded) {
                    entry.engine.updateCache(this, entry.oid, entry.object);
                }
                entry.engine.releaseLock(this, entry.oid);
            }
            if (this._callback != null) {
                this._callback.releasing(entry.object, true);
                continue;
            }
            if (entry.molder.getCallback() == null) continue;
            entry.molder.getCallback().releasing(entry.object, true);
        }
        this._objects.removeAllElements();
        this._engineOids.clear();
        this._readOnlyObjects.clear();
        this.txcommitted();
        this._status = 3;
    }

    public synchronized void rollback() {
        ObjectEntry entry;
        if (this._status != 0 && this._status != 2 && this._status != 1) {
            throw new IllegalStateException(Messages.message("persist.noTransaction"));
        }
        this.rollbackConnections();
        Enumeration enumeration = this._objects.elements();
        while (enumeration.hasMoreElements()) {
            entry = (ObjectEntry)enumeration.nextElement();
            if (!entry.deleted) continue;
            entry.deleted = false;
        }
        enumeration = this._objects.elements();
        while (enumeration.hasMoreElements()) {
            entry = (ObjectEntry)enumeration.nextElement();
            try {
                if (!entry.creating) {
                    if (entry.created) {
                        entry.engine.revertObject(this, entry.oid, entry.object);
                        entry.engine.forgetObject(this, entry.oid);
                    } else {
                        entry.engine.revertObject(this, entry.oid, entry.object);
                        entry.engine.releaseLock(this, entry.oid);
                    }
                }
                if (this._callback != null) {
                    this._callback.releasing(entry.object, false);
                    continue;
                }
                if (entry.molder.getCallback() == null) continue;
                entry.molder.getCallback().releasing(entry.object, false);
            }
            catch (Exception except) {
                except.printStackTrace();
            }
        }
        this._objects.removeAllElements();
        this._engineOids.clear();
        this._readOnlyObjects.clear();
        while (this._deletedList != null) {
            entry = this._deletedList;
            this._deletedList = entry.nextDeleted;
            entry.nextDeleted = null;
        }
        this.txrolledback();
        this._status = 4;
    }

    public synchronized void close() throws TransactionAbortedException {
        if (this._status != 0 && this._status != 1) {
            throw new IllegalStateException(Messages.message("persist.missingEnd"));
        }
        try {
            this.closeConnections();
        }
        catch (Exception except) {
            this._status = 1;
            throw new TransactionAbortedException(Messages.format("persist.nested", except), except);
        }
    }

    public boolean isPersistent(Object object) {
        ObjectEntry entry = this.getObjectEntry(object);
        return entry != null && !entry.deleted;
    }

    public boolean isRecorded(Object object) {
        ObjectEntry entry = this.getObjectEntry(object);
        return entry != null;
    }

    public boolean isDepended(OID master, Object dependent) {
        ObjectEntry entry = this.getObjectEntry(dependent);
        if (entry == null) {
            return false;
        }
        OID depends = entry.oid.getDepends();
        if (depends == null) {
            return false;
        }
        return depends.equals(master);
    }

    public Object getIdentity(Object object) {
        ObjectEntry entry = this.getObjectEntry(object);
        if (entry != null) {
            return entry.oid.getIdentity();
        }
        return null;
    }

    public int getStatus() {
        return this._status;
    }

    public boolean isOpen() {
        return this._status == 0 || this._status == 1;
    }

    protected Xid getXid() {
        return this._xid;
    }

    void setWaitOnLock(ObjectLock lock) {
        this._waitOnLock = lock;
    }

    ObjectLock getWaitOnLock() {
        return this._waitOnLock;
    }

    public boolean isDeleted(Object object) {
        ObjectEntry entry = this.getObjectEntry(object);
        if (entry != null) {
            return entry.deleted;
        }
        return false;
    }

    public boolean isDeletedByOID(OID oid) {
        ObjectEntry entry = this.getObjectEntry(oid.getLockEngine(), oid);
        if (entry != null) {
            return entry.deleted;
        }
        return false;
    }

    public int getObjectState(Object object) {
        ObjectEntry entry = this.getObjectEntry(object);
        if (entry != null) {
            if (entry.created && !entry.deleted) {
                return OBJECT_STATE_PERSISTENT_NEW;
            }
            if (entry.created && entry.deleted) {
                return OBJECT_STATE_PERSISTENT_NEW_DELETED;
            }
            if (entry.deleted) {
                return OBJECT_STATE_PERSISTENT_DELETED;
            }
            return OBJECT_STATE_PERSISTENT;
        }
        Iterator values = this._readOnlyObjects.values().iterator();
        while (values.hasNext()) {
            if (object != ((ObjectEntry)values.next()).object) continue;
            return OBJECT_STATE_READ_ONLY;
        }
        return OBJECT_STATE_TRANSIENT;
    }

    public ClassLoader getClassLoader() {
        return this._db.getClassLoader();
    }

    void markDelete(LockEngine engine, Class type, Object identity) throws LockNotGrantedException, PersistenceException {
        ObjectEntry entry = this.getObjectEntry(engine, new OID(engine, engine.getClassMolder(type), identity));
        if (entry != null && !entry.deleted) {
            try {
                if (entry.molder != null && this._callback != null) {
                    this._callback.removing(entry.object);
                } else if (entry.molder != null && entry.molder.getCallback() != null) {
                    entry.molder.getCallback().removing(entry.object);
                }
            }
            catch (Exception except) {
                throw new PersistenceException(Messages.format("persist.nested", except));
            }
            try {
                entry.deleted = true;
                entry.engine.softLock(this, entry.oid, this._lockTimeout);
                entry.engine.markDelete(this, entry.oid, null, this._lockTimeout);
                if (this._deletedList == null) {
                    this._deletedList = entry;
                } else {
                    ObjectEntry deleted = this._deletedList;
                    while (deleted.nextDeleted != null) {
                        deleted = deleted.nextDeleted;
                    }
                    deleted.nextDeleted = entry;
                }
                try {
                    if (this._callback != null) {
                        this._callback.removed(entry.object);
                    } else if (entry.molder.getCallback() != null) {
                        entry.molder.getCallback().removed(entry.object);
                    }
                }
                catch (Exception except) {
                    throw new PersistenceException(Messages.format("persist.nested", except));
                }
            }
            catch (ObjectDeletedException except) {
                this.removeObjectEntry(entry.object);
            }
        }
    }

    ObjectEntry addObjectEntry(OID oid, Object object) {
        if (oid == null) {
            throw new IllegalArgumentException("oid cannot be null");
        }
        if (object == null) {
            throw new IllegalArgumentException("object cannot be null");
        }
        LockEngine engine = oid.getLockEngine();
        ClassMolder molder = oid.getMolder();
        this.removeObjectEntry(object);
        ObjectEntry entry = new ObjectEntry(engine, molder, oid, object);
        entry.oid = oid;
        this._objects.addElement(entry);
        Hashtable<OID, ObjectEntry> engineOids = (Hashtable<OID, ObjectEntry>)this._engineOids.get(engine);
        if (engineOids == null) {
            engineOids = new Hashtable<OID, ObjectEntry>();
            this._engineOids.put(engine, engineOids);
        }
        engineOids.put(oid, entry);
        return entry;
    }

    ObjectEntry getObjectEntry(LockEngine engine, OID oid) {
        Hashtable engineOids = (Hashtable)this._engineOids.get(engine);
        if (engineOids == null) {
            return null;
        }
        return (ObjectEntry)engineOids.get(oid);
    }

    ObjectEntry rehash(Object object, OID oid) {
        ObjectEntry entry = this.getObjectEntry(object);
        if (entry == null) {
            throw new IllegalArgumentException("ObjectEntry to be rehash is not found");
        }
        Hashtable engineOids = (Hashtable)this._engineOids.get(entry.engine);
        engineOids.remove(entry.oid);
        engineOids.put(oid, entry);
        entry.oid = oid;
        return entry;
    }

    ObjectEntry getObjectEntry(Object object) {
        Enumeration enumeration = this._objects.elements();
        while (enumeration.hasMoreElements()) {
            ObjectEntry entry = (ObjectEntry)enumeration.nextElement();
            if (entry.object != object) continue;
            return entry;
        }
        return null;
    }

    ObjectEntry removeObjectEntry(Object object) {
        int size = this._objects.size();
        int i = 0;
        while (i < size) {
            ObjectEntry entry = (ObjectEntry)this._objects.elementAt(i);
            if (entry.object == object) {
                this._objects.removeElementAt(i);
                ((Hashtable)this._engineOids.get(entry.engine)).remove(entry.oid);
                return entry;
            }
            ++i;
        }
        return null;
    }

    void makeReadOnly(Object object) {
        ObjectEntry entry = this.removeObjectEntry(object);
        if (entry == null) {
            throw new IllegalStateException(Messages.format("persist.internal", "Attempt to make read-only object that is not in transaction"));
        }
        this._readOnlyObjects.put(entry.oid, entry);
        entry.engine.releaseLock(this, entry.oid);
    }

    ObjectEntry getReadOnlyObjectEntry(OID oid) {
        return (ObjectEntry)this._readOnlyObjects.get(oid);
    }

    public boolean isReadOnly(Object object) {
        return this.getObjectState(object) == OBJECT_STATE_READ_ONLY;
    }

    static short toDatabaseAccessMode(AccessMode mode) {
        if (mode == AccessMode.Shared) {
            return 1;
        }
        if (mode == AccessMode.ReadOnly) {
            return 0;
        }
        if (mode == AccessMode.DbLocked) {
            return 3;
        }
        if (mode == AccessMode.Exclusive) {
            return 2;
        }
        return -1;
    }

    public Database getDatabase() {
        return this._db;
    }

    static final class ObjectEntry {
        final LockEngine engine;
        final ClassMolder molder;
        final Object object;
        OID oid;
        boolean deleted;
        boolean created;
        boolean creating;
        boolean updateCacheNeeded;
        boolean updatePersistNeeded;
        ObjectEntry nextDeleted;

        ObjectEntry(LockEngine engine, ClassMolder molder, OID oid, Object object) {
            this.engine = engine;
            this.molder = molder;
            this.oid = oid;
            this.object = object;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.oid);
            sb.append('\t');
            sb.append("deleted: ");
            sb.append(this.deleted);
            sb.append('\t');
            sb.append("creating: ");
            sb.append(this.creating);
            sb.append('\t');
            sb.append("created: ");
            sb.append(this.created);
            sb.append('\t');
            sb.append("deleted: ");
            sb.append(this.deleted);
            return sb.toString();
        }
    }
}

