/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.thumbnail.impl;

import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.ArrayList;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.ecm.utils.text.Text;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.cms.link.NodeFinder;
import org.exoplatform.services.cms.thumbnail.ThumbnailPlugin;
import org.exoplatform.services.cms.thumbnail.ThumbnailService;
import org.exoplatform.services.cms.thumbnail.impl.ThumbnailUtils;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/thumbnailImage/")
public class ThumbnailRESTService
implements ResourceContainer {
    private static final String LASTMODIFIED = "Last-Modified";
    private final RepositoryService repositoryService_;
    private final ThumbnailService thumbnailService_;
    private final NodeFinder nodeFinder_;
    private final LinkManager linkManager_;

    public ThumbnailRESTService(RepositoryService repositoryService, ThumbnailService thumbnailService, NodeFinder nodeFinder, LinkManager linkManager) {
        this.repositoryService_ = repositoryService;
        this.thumbnailService_ = thumbnailService;
        this.nodeFinder_ = nodeFinder;
        this.linkManager_ = linkManager;
    }

    @Path(value="/medium/{repoName}/{workspaceName}/{nodePath:.*}/")
    @GET
    public Response getThumbnailImage(@PathParam(value="repoName") String repoName, @PathParam(value="workspaceName") String wsName, @PathParam(value="nodePath") String nodePath) throws Exception {
        return this.getThumbnailByType(repoName, wsName, nodePath, ThumbnailService.MEDIUM_SIZE);
    }

    @Path(value="/big/{repoName}/{workspaceName}/{nodePath:.*}/")
    @GET
    public Response getCoverImage(@PathParam(value="repoName") String repoName, @PathParam(value="workspaceName") String wsName, @PathParam(value="nodePath") String nodePath) throws Exception {
        return this.getThumbnailByType(repoName, wsName, nodePath, ThumbnailService.BIG_SIZE);
    }

    @Path(value="/small/{repoName}/{workspaceName}/{nodePath:.*}/")
    @GET
    public Response getSmallImage(@PathParam(value="repoName") String repoName, @PathParam(value="workspaceName") String wsName, @PathParam(value="nodePath") String nodePath) throws Exception {
        return this.getThumbnailByType(repoName, wsName, nodePath, ThumbnailService.SMALL_SIZE);
    }

    @Path(value="/origin/{repoName}/{workspaceName}/{nodePath:.*}/")
    @GET
    public Response getOriginImage(@PathParam(value="repoName") String repoName, @PathParam(value="workspaceName") String wsName, @PathParam(value="nodePath") String nodePath) throws Exception {
        if (!this.thumbnailService_.isEnableThumbnail()) {
            return Response.ok().build();
        }
        Node showingNode = this.getShowingNode(repoName, wsName, this.getNodePath(nodePath));
        Node targetNode = this.getTargetNode(showingNode);
        if (targetNode.getPrimaryNodeType().getName().equals("nt:file")) {
            Node content = targetNode.getNode("jcr:content");
            String mimeType = content.getProperty("jcr:mimeType").getString();
            for (ComponentPlugin plugin : this.thumbnailService_.getComponentPlugins()) {
                ThumbnailPlugin thumbnailPlugin;
                if (!(plugin instanceof ThumbnailPlugin) || !(thumbnailPlugin = (ThumbnailPlugin)plugin).getMimeTypes().contains(mimeType)) continue;
                String lastModified = content.getProperty("jcr:lastModified").getDate().getTime().toString();
                InputStream inputStream = content.getProperty("jcr:data").getStream();
                return Response.ok((Object)inputStream, (String)"image").header(LASTMODIFIED, (Object)lastModified).build();
            }
        }
        return Response.ok().build();
    }

    private Response getThumbnailByType(String repoName, String wsName, String nodePath, String propertyName) throws Exception {
        if (!this.thumbnailService_.isEnableThumbnail()) {
            return Response.ok().build();
        }
        Node showingNode = this.getShowingNode(repoName, wsName, this.getNodePath(nodePath));
        Node parentNode = showingNode.getParent();
        String identifier = ((NodeImpl)showingNode).getInternalIdentifier();
        Node targetNode = this.getTargetNode(showingNode);
        if (targetNode.getPrimaryNodeType().getName().equals("nt:file")) {
            Node content = targetNode.getNode("jcr:content");
            String mimeType = content.getProperty("jcr:mimeType").getString();
            for (ComponentPlugin plugin : this.thumbnailService_.getComponentPlugins()) {
                ThumbnailPlugin thumbnailPlugin;
                if (!(plugin instanceof ThumbnailPlugin) || !(thumbnailPlugin = (ThumbnailPlugin)plugin).getMimeTypes().contains(mimeType)) continue;
                Node thumbnailFolder = ThumbnailUtils.getThumbnailFolder(parentNode);
                Node thumbnailNode = ThumbnailUtils.getThumbnailNode(thumbnailFolder, identifier);
                if (!thumbnailNode.hasProperty(propertyName)) {
                    BufferedImage image = thumbnailPlugin.getBufferedImage(content, targetNode.getPath());
                    this.thumbnailService_.addThumbnailImage(thumbnailNode, image, propertyName);
                }
                String lastModified = null;
                if (thumbnailNode.hasProperty(ThumbnailService.THUMBNAIL_LAST_MODIFIED)) {
                    lastModified = thumbnailNode.getProperty(ThumbnailService.THUMBNAIL_LAST_MODIFIED).getString();
                }
                InputStream inputStream = null;
                if (thumbnailNode.hasProperty(propertyName)) {
                    inputStream = thumbnailNode.getProperty(propertyName).getStream();
                }
                return Response.ok(inputStream, (String)"image").header(LASTMODIFIED, (Object)lastModified).build();
            }
        }
        return this.getThumbnailRes(parentNode, identifier, propertyName);
    }

    private Response getThumbnailRes(Node parentNode, String identifier, String propertyName) throws Exception {
        Node thumbnailNode;
        Node thumbnailFolder;
        if (parentNode.hasNode(ThumbnailService.EXO_THUMBNAILS_FOLDER) && (thumbnailFolder = parentNode.getNode(ThumbnailService.EXO_THUMBNAILS_FOLDER)).hasNode(identifier) && (thumbnailNode = thumbnailFolder.getNode(identifier)).hasProperty(propertyName)) {
            InputStream inputStream = thumbnailNode.getProperty(propertyName).getStream();
            return Response.ok((Object)inputStream, (String)"image").build();
        }
        return Response.ok().build();
    }

    private String getNodePath(String nodePath) throws Exception {
        ArrayList<String> encodeNameArr = new ArrayList<String>();
        if (!nodePath.equals("/")) {
            for (String name : nodePath.split("/")) {
                if (name.length() <= 0) continue;
                encodeNameArr.add(Text.escapeIllegalJcrChars(name));
            }
            StringBuilder encodedPath = new StringBuilder();
            for (String encodedName : encodeNameArr) {
                encodedPath.append("/").append(encodedName);
            }
            nodePath = encodedPath.toString();
        }
        return nodePath;
    }

    private Node getTargetNode(Node showingNode) throws Exception {
        Node targetNode = null;
        if (this.linkManager_.isLink((Item)showingNode)) {
            try {
                targetNode = this.linkManager_.getTarget(showingNode);
            }
            catch (ItemNotFoundException e) {
                targetNode = showingNode;
            }
        } else {
            targetNode = showingNode;
        }
        return targetNode;
    }

    private Node getShowingNode(String repoName, String wsName, String nodePath) throws Exception {
        ManageableRepository repository = this.repositoryService_.getRepository(repoName);
        Session session = this.getSystemProvider().getSession(wsName, repository);
        Node showingNode = null;
        Node root = session.getRootNode();
        root.getNodes();
        showingNode = nodePath.equals("/") ? session.getRootNode() : (Node)this.nodeFinder_.getItem(session, nodePath);
        return showingNode;
    }

    private SessionProvider getSystemProvider() {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        SessionProviderService service = (SessionProviderService)container.getComponentInstanceOfType(SessionProviderService.class);
        return service.getSystemSessionProvider(null);
    }
}

