/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.gatein.common.net.URLTools;
import org.gatein.common.util.LoaderResource;
import org.gatein.common.util.ResourceLoader;

public class CLResourceLoader
implements ResourceLoader {
    private final ClassLoader loader;

    public CLResourceLoader(ClassLoader loader) {
        if (loader == null) {
            throw new IllegalArgumentException("No classloader provided");
        }
        this.loader = loader;
    }

    public CLResourceLoader() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public InputStream load(String location) {
        return this.loader.getResourceAsStream(location);
    }

    public LoaderResource getResource(String location) {
        if (location == null) {
            throw new IllegalArgumentException("Location is null");
        }
        URL url = this.loader.getResource(location);
        return new URLResource(location, url);
    }

    private static class URLResource
    extends LoaderResource {
        private final URL url;

        public URLResource(String location, URL url) {
            super(location);
            this.url = url;
        }

        public boolean exists() {
            return URLTools.exists(this.url);
        }

        public InputStream asInputStream() throws IllegalStateException {
            if (!this.exists()) {
                throw new IllegalStateException("Resource " + this.location + " does not exist");
            }
            try {
                return this.url.openStream();
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot open resource stream " + this.location);
            }
        }

        public String toString() {
            return "Resource[" + this.location + "," + this.url + "]";
        }
    }
}

