/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.nodetype.selector;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.webui.nodetype.selector.UINodeTypeSearch;
import org.exoplatform.ecm.webui.selector.ComponentSelector;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormStringInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/ecm/webui/nodetype/selector/UINodeTypeSelector.gtmpl", events={@EventConfig(listeners={SearchNodeTypeActionListener.class}), @EventConfig(listeners={SaveActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={RefreshActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ShowPageActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={OnChangeActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CloseActionListener.class}, phase=Event.Phase.DECODE)})
public class UINodeTypeSelector
extends UIForm
implements ComponentSelector {
    private UIPageIterator uiPageIterator_;
    private UIComponent sourceUIComponent;
    private String returnFieldName = null;
    private String repositoryName = null;
    private List<String> selectedNodetypes = new ArrayList<String>();
    private List<String> documentNodetypes = new ArrayList<String>();
    private static final String ALL_DOCUMENT_TYPES = "ALL_DOCUMENT_TYPES";
    private List<NodeType> lstNodetype;
    private String[] actions_ = new String[]{"Save", "Refresh", "Close"};

    public String[] getActions() {
        return this.actions_;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    public String getResource(String key) {
        try {
            return Utils.getResourceBundle("locale.portlet.i18n.WebUIDms", key, this.getClass().getClassLoader());
        }
        catch (Exception e) {
            return key;
        }
    }

    public List<String> getDocumentNodetypes() {
        return this.documentNodetypes;
    }

    public void setDocumentNodetypes(List<String> documentNodetypes) {
        this.documentNodetypes = documentNodetypes;
    }

    public UINodeTypeSelector() throws Exception {
        this.addChild(UINodeTypeSearch.class, null, "SearchNodeType");
        this.uiPageIterator_ = (UIPageIterator)this.addChild(UIPageIterator.class, null, "UINodeTypeSelectorIterator");
    }

    public String getReturnFieldName() {
        return this.returnFieldName;
    }

    public void setReturnFieldName(String name) {
        this.returnFieldName = name;
    }

    @Override
    public UIComponent getSourceComponent() {
        return this.sourceUIComponent;
    }

    @Override
    public void setSourceComponent(UIComponent uicomponent, String[] initParams) {
        this.sourceUIComponent = uicomponent;
        if (initParams == null || initParams.length < 0) {
            return;
        }
        for (int i = 0; i < initParams.length; ++i) {
            if (initParams[i].indexOf("returnField") > -1) {
                String[] array = initParams[i].split("=");
                this.returnFieldName = array[1];
                break;
            }
            this.returnFieldName = initParams[0];
        }
    }

    public UIPageIterator getUIPageIterator() {
        return this.uiPageIterator_;
    }

    public List<NodeType> getNodeTypeList() throws Exception {
        return this.uiPageIterator_.getCurrentPageData();
    }

    public List<NodeType> getAllNodeTypes() throws Exception {
        ArrayList<NodeType> nodeList = new ArrayList<NodeType>();
        ManageableRepository mRepository = ((RepositoryService)this.getApplicationComponent(RepositoryService.class)).getRepository(this.repositoryName);
        ExtendedNodeTypeManager ntManager = mRepository.getNodeTypeManager();
        NodeTypeIterator nodeTypeIter = ntManager.getAllNodeTypes();
        while (nodeTypeIter.hasNext()) {
            nodeList.add(nodeTypeIter.nextNodeType());
        }
        Collections.sort(nodeList, new Utils.NodeTypeNameComparator());
        return nodeList;
    }

    private boolean getCheckedValue(List<String> values, String name) {
        return values.contains(name);
    }

    public void init(int currentPage, List<String> values) throws Exception {
        this.lstNodetype = this.getAllNodeTypes();
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        this.documentNodetypes = templateService.getAllDocumentNodeTypes(this.getRepositoryName());
        ((UINodeTypeSearch)this.getChild(UINodeTypeSearch.class)).init();
        this.init(currentPage, values, this.lstNodetype);
    }

    private void init(int currentPage, List<String> values, List<NodeType> lstNodetype) throws Exception {
        if (lstNodetype == null) {
            return;
        }
        ObjectPageList pageList = new ObjectPageList(lstNodetype, 5);
        this.uiPageIterator_.setPageList((PageList)pageList);
        if (currentPage > this.uiPageIterator_.getAvailablePage()) {
            this.uiPageIterator_.setCurrentPage(currentPage - 1);
        } else {
            this.uiPageIterator_.setCurrentPage(currentPage);
        }
        UIFormCheckBoxInput uiCheckbox = new UIFormCheckBoxInput(ALL_DOCUMENT_TYPES, null, (Object)ALL_DOCUMENT_TYPES);
        uiCheckbox.setOnChange("OnChange");
        if (values != null) {
            if (values.containsAll(this.getDocumentNodetypes()) && !values.contains(ALL_DOCUMENT_TYPES)) {
                values.add(ALL_DOCUMENT_TYPES);
            }
            if (values.contains(uiCheckbox.getValue())) {
                uiCheckbox.setChecked(true);
                if (!this.getSelectedNodetypes().contains(uiCheckbox.getValue())) {
                    this.getSelectedNodetypes().add((String)uiCheckbox.getValue());
                }
            }
        }
        this.addChild((UIComponent)uiCheckbox);
        for (NodeType nt : lstNodetype) {
            String ntName = nt.getName();
            uiCheckbox = new UIFormCheckBoxInput(ntName, ntName, (Object)ntName);
            uiCheckbox.setOnChange("OnChange");
            if (values != null && values.contains(ntName)) {
                uiCheckbox.setChecked(true);
                if (!this.getSelectedNodetypes().contains(ntName)) {
                    this.getSelectedNodetypes().add(ntName);
                }
            }
            this.removeChildById(ntName);
            this.addChild((UIComponent)uiCheckbox);
        }
        if (values == null) {
            this.getSelectedNodetypes().clear();
        }
    }

    public void setSelectedNodetypes(List<String> selectedNodetypes) {
        this.selectedNodetypes = selectedNodetypes;
    }

    public List<String> getSelectedNodetypes() {
        return this.selectedNodetypes;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RefreshActionListener
    extends EventListener<UINodeTypeSelector> {
        public void execute(Event<UINodeTypeSelector> event) throws Exception {
            UINodeTypeSelector uiNodeTypeSelect = (UINodeTypeSelector)event.getSource();
            ArrayList listCheckbox = new ArrayList();
            uiNodeTypeSelect.findComponentOfType(listCheckbox, UIFormCheckBoxInput.class);
            for (int i = 0; i < listCheckbox.size(); ++i) {
                ((UIFormCheckBoxInput)listCheckbox.get(i)).setChecked(false);
                uiNodeTypeSelect.getSelectedNodetypes().clear();
            }
            UIPopupWindow uiPopup = (UIPopupWindow)((UINodeTypeSelector)event.getSource()).getAncestorOfType(UIPopupWindow.class);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopup);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CloseActionListener
    extends EventListener<UINodeTypeSelector> {
        public void execute(Event<UINodeTypeSelector> event) throws Exception {
            UIPopupWindow uiPopup = (UIPopupWindow)((UINodeTypeSelector)event.getSource()).getAncestorOfType(UIPopupWindow.class);
            uiPopup.setShow(false);
            uiPopup.setRendered(false);
            UIComponent component = ((UINodeTypeSelector)event.getSource()).getSourceComponent().getParent();
            if (component != null) {
                event.getRequestContext().addUIComponentToUpdateByAjax(component);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OnChangeActionListener
    extends EventListener<UINodeTypeSelector> {
        private void updateCheckBox(List<String> selectedNodetypes, UIFormCheckBoxInput uiCheckBox) {
            if (uiCheckBox.isChecked()) {
                if (!selectedNodetypes.contains(uiCheckBox.getValue().toString())) {
                    selectedNodetypes.add(uiCheckBox.getValue().toString());
                }
            } else {
                selectedNodetypes.remove(uiCheckBox.getValue().toString());
            }
        }

        public void execute(Event<UINodeTypeSelector> event) throws Exception {
            UINodeTypeSelector uiNodeTypeSelect = (UINodeTypeSelector)event.getSource();
            List<String> selectedNodetypes = uiNodeTypeSelect.getSelectedNodetypes();
            ArrayList<String> preSelectedNodetypes = new ArrayList<String>();
            preSelectedNodetypes.addAll(selectedNodetypes);
            List<NodeType> lstNodeType = uiNodeTypeSelect.getNodeTypeList();
            UIFormCheckBoxInput uiCheckBox = (UIFormCheckBoxInput)uiNodeTypeSelect.getChildById(UINodeTypeSelector.ALL_DOCUMENT_TYPES);
            this.updateCheckBox(selectedNodetypes, uiCheckBox);
            for (NodeType nodetype : lstNodeType) {
                uiCheckBox = (UIFormCheckBoxInput)uiNodeTypeSelect.getChildById(nodetype.getName());
                this.updateCheckBox(selectedNodetypes, uiCheckBox);
            }
            if (selectedNodetypes.contains(UINodeTypeSelector.ALL_DOCUMENT_TYPES) && !preSelectedNodetypes.contains(UINodeTypeSelector.ALL_DOCUMENT_TYPES)) {
                for (String nodeTypeName : uiNodeTypeSelect.getDocumentNodetypes()) {
                    ((UIFormCheckBoxInput)uiNodeTypeSelect.getChildById(nodeTypeName)).setChecked(true);
                    if (selectedNodetypes.contains(nodeTypeName)) continue;
                    selectedNodetypes.add(nodeTypeName);
                }
            } else if (!selectedNodetypes.contains(UINodeTypeSelector.ALL_DOCUMENT_TYPES) && preSelectedNodetypes.contains(UINodeTypeSelector.ALL_DOCUMENT_TYPES) && selectedNodetypes.containsAll(uiNodeTypeSelect.getDocumentNodetypes())) {
                for (String nodeTypeName : uiNodeTypeSelect.getDocumentNodetypes()) {
                    ((UIFormCheckBoxInput)uiNodeTypeSelect.getChildById(nodeTypeName)).setChecked(false);
                    selectedNodetypes.remove(nodeTypeName);
                }
            }
            UIPopupWindow uiPopup = (UIPopupWindow)((UINodeTypeSelector)event.getSource()).getAncestorOfType(UIPopupWindow.class);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopup);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ShowPageActionListener
    extends EventListener<UIPageIterator> {
        public void execute(Event<UIPageIterator> event) throws Exception {
            UINodeTypeSelector uiNodeTypeSelect = (UINodeTypeSelector)((UIPageIterator)event.getSource()).getAncestorOfType(UINodeTypeSelector.class);
            List<String> selectedNodetypes = uiNodeTypeSelect.getSelectedNodetypes();
            ArrayList listCheckbox = new ArrayList();
            uiNodeTypeSelect.findComponentOfType(listCheckbox, UIFormCheckBoxInput.class);
            for (UIFormCheckBoxInput uiCheckBox : listCheckbox) {
                if (selectedNodetypes.contains(uiCheckBox.getValue().toString())) {
                    uiCheckBox.setChecked(true);
                    continue;
                }
                uiCheckBox.setChecked(false);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveActionListener
    extends EventListener<UINodeTypeSelector> {
        public void execute(Event<UINodeTypeSelector> event) throws Exception {
            UIComponent component;
            UINodeTypeSelector uiNodeTypeSelect = (UINodeTypeSelector)event.getSource();
            List<String> selectedNodetypes = uiNodeTypeSelect.getSelectedNodetypes();
            String returnField = uiNodeTypeSelect.getReturnFieldName();
            if (selectedNodetypes.contains(UINodeTypeSelector.ALL_DOCUMENT_TYPES)) {
                selectedNodetypes.remove(UINodeTypeSelector.ALL_DOCUMENT_TYPES);
                for (String docNodeType : uiNodeTypeSelect.getDocumentNodetypes()) {
                    if (selectedNodetypes.contains(docNodeType) || !((UIFormCheckBoxInput)uiNodeTypeSelect.findComponentById(docNodeType)).isChecked()) continue;
                    selectedNodetypes.add(docNodeType);
                }
            }
            ((UISelectable)uiNodeTypeSelect.getSourceComponent()).doSelect(returnField, selectedNodetypes);
            selectedNodetypes.clear();
            UIPopupWindow uiPopup = (UIPopupWindow)((UINodeTypeSelector)event.getSource()).getAncestorOfType(UIPopupWindow.class);
            if (uiPopup != null) {
                uiPopup.setShow(false);
                uiPopup.setRendered(false);
            }
            if ((component = ((UINodeTypeSelector)event.getSource()).getSourceComponent().getParent()) != null) {
                event.getRequestContext().addUIComponentToUpdateByAjax(component);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SearchNodeTypeActionListener
    extends EventListener<UINodeTypeSelector> {
        public void execute(Event<UINodeTypeSelector> event) throws Exception {
            UINodeTypeSelector uiNodeTypeSelect = (UINodeTypeSelector)event.getSource();
            UIFormStringInput uiInputNodeType = (UIFormStringInput)uiNodeTypeSelect.findComponentById("NodeTypeText");
            String nodeTypeName = (String)uiInputNodeType.getValue();
            if (nodeTypeName == null || nodeTypeName.length() == 0) {
                return;
            }
            nodeTypeName = nodeTypeName.contains("*") && !nodeTypeName.contains(".*") ? nodeTypeName.replace("*", ".*") : nodeTypeName;
            Pattern p = Pattern.compile(".*".concat(nodeTypeName.trim()).concat(".*"), 2);
            if (uiNodeTypeSelect.lstNodetype == null) {
                uiNodeTypeSelect.lstNodetype = uiNodeTypeSelect.getAllNodeTypes();
            }
            ArrayList<NodeType> lstNodetype = new ArrayList<NodeType>();
            for (NodeType nodeType : uiNodeTypeSelect.lstNodetype) {
                if (!p.matcher(nodeType.getName()).find()) continue;
                lstNodetype.add(nodeType);
            }
            uiNodeTypeSelect.init(1, uiNodeTypeSelect.getSelectedNodetypes(), lstNodetype);
            UIPopupWindow uiPopup = (UIPopupWindow)((UINodeTypeSelector)event.getSource()).getAncestorOfType(UIPopupWindow.class);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopup);
        }
    }
}

