/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.templates.impl;

import java.io.Serializable;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeType;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.cms.impl.DMSRepositoryConfiguration;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.cms.templates.ContentTypeFilterPlugin;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.cms.templates.impl.TemplatePlugin;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.access.SystemIdentity;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.services.resources.Orientation;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.security.MembershipEntry;
import org.picocontainer.Startable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateServiceImpl
implements TemplateService,
Startable {
    private RepositoryService repositoryService_;
    private IdentityRegistry identityRegistry_;
    private String cmsTemplatesBasePath_;
    private List<TemplatePlugin> plugins_ = new ArrayList<TemplatePlugin>();
    private Map<String, HashMap<String, List<String>>> foldersFilterMap = new HashMap<String, HashMap<String, List<String>>>();
    private Map<String, List<String>> managedDocumentTypesMap = new HashMap<String, List<String>>();
    private org.exoplatform.groovyscript.text.TemplateService templateService;
    private LocaleConfigService localeConfigService_;
    private static final Log LOG = ExoLogger.getLogger((String)TemplateService.class.getName());
    private DMSConfiguration dmsConfiguration_;
    private static String NODETYPE_LIST = "nodeTypeList";
    private ExoCache nodeTypeListCached;

    public TemplateServiceImpl(RepositoryService jcrService, NodeHierarchyCreator nodeHierarchyCreator, IdentityRegistry identityRegistry, org.exoplatform.groovyscript.text.TemplateService templateService, DMSConfiguration dmsConfiguration, LocaleConfigService localeConfigService, CacheService caService) throws Exception {
        this.identityRegistry_ = identityRegistry;
        this.repositoryService_ = jcrService;
        this.cmsTemplatesBasePath_ = nodeHierarchyCreator.getJcrPath("templatesPath");
        this.templateService = templateService;
        this.dmsConfiguration_ = dmsConfiguration;
        this.localeConfigService_ = localeConfigService;
        this.nodeTypeListCached = caService.getCacheInstance(TemplateService.class.getName());
    }

    public void start() {
        try {
            for (TemplatePlugin plugin : this.plugins_) {
                plugin.init();
            }
            for (RepositoryEntry repositoryEntry : this.repositoryService_.getConfig().getRepositoryConfigurations()) {
                String repositoryName = repositoryEntry.getName();
                List<String> managedContentTypes = this.getAllDocumentNodeTypes(repositoryEntry.getName());
                if (managedContentTypes.size() == 0) continue;
                this.managedDocumentTypesMap.put(repositoryName, managedContentTypes);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"An unexpected exception occurs when init plugins", (Throwable)e);
        }
    }

    public void stop() {
    }

    @Override
    public void addContentTypeFilterPlugin(ContentTypeFilterPlugin filterPlugin) {
        String repository = filterPlugin.getRepository();
        HashMap<String, List<String>> folderFilterMap = this.foldersFilterMap.get(repository);
        if (folderFilterMap == null) {
            folderFilterMap = new HashMap();
        }
        for (ContentTypeFilterPlugin.FolderFilterConfig filterConfig : filterPlugin.getFolderFilterConfigList()) {
            String folderType = filterConfig.getFolderType();
            ArrayList<String> contentTypes = filterConfig.getContentTypes();
            List<String> value = folderFilterMap.get(folderType);
            if (value == null) {
                folderFilterMap.put(folderType, contentTypes);
                continue;
            }
            value.addAll(contentTypes);
            folderFilterMap.put(folderType, value);
        }
        this.foldersFilterMap.put(repository, folderFilterMap);
    }

    @Override
    public Set<String> getAllowanceFolderType(String repository) {
        Map folderFilterMap = this.foldersFilterMap.get(repository);
        if (folderFilterMap == null) {
            folderFilterMap = this.foldersFilterMap.get("repository");
        }
        return folderFilterMap.keySet();
    }

    public void addTemplates(ComponentPlugin plugin) {
        if (plugin instanceof TemplatePlugin) {
            this.plugins_.add((TemplatePlugin)plugin);
        }
    }

    @Override
    public void init(String repository) throws Exception {
        for (TemplatePlugin plugin : this.plugins_) {
            plugin.init(repository);
        }
    }

    @Override
    public Node getTemplatesHome(String repository, SessionProvider provider) throws Exception {
        try {
            Session session = this.getSession(repository, provider);
            return (Node)session.getItem(this.cmsTemplatesBasePath_);
        }
        catch (AccessDeniedException ace) {
            LOG.error((Object)"Access denied. You can not access to this template");
            return null;
        }
    }

    @Override
    public List<String> getCreationableContentTypes(Node node) throws Exception {
        List<String> list;
        String folderType = node.getPrimaryNodeType().getName();
        String repository = ((ManageableRepository)node.getSession().getRepository()).getConfiguration().getName();
        List<String> testContentTypes = null;
        HashMap<String, List<String>> folderFilterMap = this.foldersFilterMap.get(repository);
        if (folderFilterMap != null && (list = folderFilterMap.get(folderType)) != null && list.size() != 0) {
            testContentTypes = list;
        }
        if (testContentTypes == null) {
            testContentTypes = this.getDocumentTemplates(repository);
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String contentType : testContentTypes) {
            if (!this.isChildNodePrimaryTypeAllowed(node, contentType) || folderType.equals(contentType)) continue;
            result.add(contentType);
        }
        return result;
    }

    public boolean isChildNodePrimaryTypeAllowed(Node parent, String childNodeTypeName) throws Exception {
        NodeType childNodeType = parent.getSession().getWorkspace().getNodeTypeManager().getNodeType(childNodeTypeName);
        if (childNodeType.isMixin()) {
            return true;
        }
        ArrayList<NodeType> allNodeTypes = new ArrayList<NodeType>();
        allNodeTypes.add(parent.getPrimaryNodeType());
        for (NodeType mixin : parent.getMixinNodeTypes()) {
            allNodeTypes.add(mixin);
        }
        for (NodeType nodetype : allNodeTypes) {
            if (!((NodeTypeImpl)nodetype).isChildNodePrimaryTypeAllowed(childNodeTypeName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isManagedNodeType(String nodeTypeName, String repository) throws Exception {
        List<String> managedDocumentTypes = this.managedDocumentTypesMap.get(repository);
        if (managedDocumentTypes != null && managedDocumentTypes.contains(nodeTypeName)) {
            return true;
        }
        SessionProvider provider = SessionProvider.createSystemProvider();
        Session session = this.getSession(repository, provider);
        Node systemTemplatesHome = (Node)session.getItem(this.cmsTemplatesBasePath_);
        boolean b = false;
        if (systemTemplatesHome.hasNode(nodeTypeName)) {
            b = true;
        }
        provider.close();
        return b;
    }

    @Override
    public String getTemplatePath(Node node, boolean isDialog) throws Exception {
        String userId = node.getSession().getUserID();
        String repository = ((ManageableRepository)node.getSession().getRepository()).getConfiguration().getName();
        String templateType = null;
        templateType = node.isNodeType("exo:presentationable") && node.hasProperty("exo:presentationType") ? node.getProperty("exo:presentationType").getString() : node.getPrimaryNodeType().getName();
        if (this.isManagedNodeType(templateType, repository)) {
            return this.getTemplatePathByUser(isDialog, templateType, userId, repository);
        }
        throw new Exception("The content type: " + templateType + " doesn't be supported by any template");
    }

    @Override
    public NodeIterator getAllTemplatesOfNodeType(boolean isDialog, String nodeTypeName, String repository, SessionProvider provider) throws Exception {
        Node nodeTypeHome = this.getTemplatesHome(repository, provider).getNode(nodeTypeName);
        if (isDialog) {
            return nodeTypeHome.getNode(DIALOGS).getNodes();
        }
        return nodeTypeHome.getNode(VIEWS).getNodes();
    }

    @Override
    public String getDefaultTemplatePath(boolean isDialog, String nodeTypeName) {
        if (isDialog) {
            return this.cmsTemplatesBasePath_ + "/" + nodeTypeName + DEFAULT_DIALOGS_PATH;
        }
        return this.cmsTemplatesBasePath_ + "/" + nodeTypeName + DEFAULT_VIEWS_PATH;
    }

    @Override
    public Node getTemplateNode(String type, String nodeTypeName, String templateName, String repository, SessionProvider provider) throws Exception {
        Node nodeTypeNode = this.getTemplatesHome(repository, provider).getNode(nodeTypeName);
        return nodeTypeNode.getNode(type).getNode(templateName);
    }

    @Override
    public String getTemplatePathByUser(boolean isDialog, String nodeTypeName, String userName, String repository) throws Exception {
        if (SystemIdentity.ANONIM.equals(userName) || userName == null) {
            return this.getTemplatePathByAnonymous(isDialog, nodeTypeName, repository);
        }
        Session session = this.getSession(repository);
        Node templateHomeNode = (Node)session.getItem(this.cmsTemplatesBasePath_);
        String type = DIALOGS;
        if (!isDialog) {
            type = VIEWS;
        }
        Node nodeTypeNode = templateHomeNode.getNode(nodeTypeName);
        NodeIterator templateIter = nodeTypeNode.getNode(type).getNodes();
        while (templateIter.hasNext()) {
            Node node = templateIter.nextNode();
            Value[] roles = node.getProperty(EXO_ROLES_PROP).getValues();
            if (!this.hasPermission(userName, roles, this.identityRegistry_)) continue;
            String templatePath = node.getPath();
            session.logout();
            return templatePath;
        }
        session.logout();
        throw new AccessControlException("You don't have permission to access any template");
    }

    @Override
    public String getTemplatePath(boolean isDialog, String nodeTypeName, String templateName, String repository) throws Exception {
        Session session = this.getSession(repository);
        String type = DIALOGS;
        if (!isDialog) {
            type = VIEWS;
        }
        Node templateNode = this.getTemplateNode(session, type, nodeTypeName, templateName);
        String path = templateNode.getPath();
        session.logout();
        return path;
    }

    @Override
    public String getTemplateLabel(String nodeTypeName, String repository) throws Exception {
        SessionProvider provider = SessionProvider.createSystemProvider();
        Node templateHome = this.getTemplatesHome(repository, provider);
        Node nodeType = templateHome.getNode(nodeTypeName);
        String label = "";
        if (nodeType.hasProperty("label")) {
            label = nodeType.getProperty("label").getString();
        }
        provider.close();
        return label;
    }

    @Override
    public String getTemplate(String type, String nodeTypeName, String templateName, String repository) throws Exception {
        Session session = this.getSession(repository);
        Node templateNode = this.getTemplateNode(session, type, nodeTypeName, templateName);
        String template = templateNode.getProperty(EXO_TEMPLATE_FILE_PROP).getString();
        session.logout();
        return template;
    }

    @Override
    public String getTemplateRoles(String type, String nodeTypeName, String templateName, String repository) throws Exception {
        Session session = this.getSession(repository);
        Node templateNode = this.getTemplateNode(session, type, nodeTypeName, templateName);
        Value[] values = templateNode.getProperty(EXO_ROLES_PROP).getValues();
        StringBuffer roles = new StringBuffer();
        for (int i = 0; i < values.length; ++i) {
            if (roles.length() > 0) {
                roles.append("; ");
            }
            roles.append(values[i].getString());
        }
        session.logout();
        return roles.toString();
    }

    @Override
    public void removeTemplate(String type, String nodeTypeName, String templateName, String repository) throws Exception {
        Session session = this.getSession(repository);
        Node templatesHome = (Node)session.getItem(this.cmsTemplatesBasePath_);
        Node nodeTypeHome = templatesHome.getNode(nodeTypeName);
        Node specifiedTemplatesHome = nodeTypeHome.getNode(type);
        Node contentNode = specifiedTemplatesHome.getNode(templateName);
        contentNode.remove();
        nodeTypeHome.save();
        session.save();
        session.logout();
    }

    @Override
    public void removeManagedNodeType(String nodeTypeName, String repository) throws Exception {
        Session session = this.getSession(repository);
        Node templatesHome = (Node)session.getItem(this.cmsTemplatesBasePath_);
        Node managedNodeType = templatesHome.getNode(nodeTypeName);
        managedNodeType.remove();
        session.save();
        session.logout();
        List<String> managedDocumentTypes = this.managedDocumentTypesMap.get(repository);
        managedDocumentTypes.remove(nodeTypeName);
        this.removeTemplateNodeTypeList();
    }

    @Override
    @Deprecated
    public String addTemplate(boolean isDialog, String nodeTypeName, String label, boolean isDocumentTemplate, String templateName, String[] roles, String templateFile, String repository) throws Exception {
        Session session = this.getSession(repository);
        Node templatesHome = (Node)session.getItem(this.cmsTemplatesBasePath_);
        String templateType = DIALOGS;
        if (!isDialog) {
            templateType = VIEWS;
        }
        Node contentNode = this.getContentNode(templateType, templatesHome, nodeTypeName, label, isDocumentTemplate, templateName);
        contentNode.setProperty(EXO_ROLES_PROP, roles);
        contentNode.setProperty(EXO_TEMPLATE_FILE_PROP, templateFile);
        templatesHome.save();
        session.save();
        session.logout();
        this.removeCacheTemplate(contentNode.getPath());
        this.removeTemplateNodeTypeList();
        this.updateDocumentsTemplate(isDocumentTemplate, repository, nodeTypeName);
        return contentNode.getPath();
    }

    @Override
    public String addTemplate(String templateType, String nodeTypeName, String label, boolean isDocumentTemplate, String templateName, String[] roles, String templateFile, String repository) throws Exception {
        Session session = this.getSession(repository);
        Node templatesHome = (Node)session.getItem(this.cmsTemplatesBasePath_);
        Node contentNode = this.getContentNode(templateType, templatesHome, nodeTypeName, label, isDocumentTemplate, templateName);
        contentNode.setProperty(EXO_ROLES_PROP, roles);
        contentNode.setProperty(EXO_TEMPLATE_FILE_PROP, templateFile);
        templatesHome.save();
        session.save();
        session.logout();
        this.removeCacheTemplate(contentNode.getPath());
        this.removeTemplateNodeTypeList();
        this.updateDocumentsTemplate(isDocumentTemplate, repository, nodeTypeName);
        return contentNode.getPath();
    }

    @Override
    public List<String> getDocumentTemplates(String repository) throws Exception {
        List<String> templates = this.managedDocumentTypesMap.get(repository);
        if (templates != null) {
            return templates;
        }
        templates = this.getAllDocumentNodeTypes(repository);
        this.managedDocumentTypesMap.put(repository, templates);
        return templates;
    }

    @Override
    public String getTemplatePathByAnonymous(boolean isDialog, String nodeTypeName, String repository) throws Exception {
        Session session = this.getSession(repository);
        String type = DIALOGS;
        if (!isDialog) {
            type = VIEWS;
        }
        Node homeNode = (Node)session.getItem(this.cmsTemplatesBasePath_);
        Node nodeTypeNode = homeNode.getNode(nodeTypeName);
        NodeIterator templateIter = nodeTypeNode.getNode(type).getNodes();
        while (templateIter.hasNext()) {
            Node node = templateIter.nextNode();
            Value[] roles = node.getProperty(EXO_ROLES_PROP).getValues();
            if (!this.hasPublicTemplate(roles)) continue;
            String templatePath = node.getPath();
            session.logout();
            return templatePath;
        }
        session.logout();
        return null;
    }

    @Override
    public void removeCacheTemplate(String name) throws Exception {
        this.templateService.getTemplatesCache().remove((Serializable)((Object)name));
    }

    @Override
    public void removeAllTemplateCached() {
        this.templateService.reloadTemplates();
    }

    @Override
    public List<String> getAllDocumentNodeTypes(String repository) throws Exception {
        List nodeTypeList = (List)this.nodeTypeListCached.get((Serializable)((Object)NODETYPE_LIST));
        if (nodeTypeList != null && nodeTypeList.size() > 0) {
            return nodeTypeList;
        }
        ArrayList<String> contentTypes = new ArrayList<String>();
        Session session = this.getSession(repository);
        Node templatesHome = (Node)session.getItem(this.cmsTemplatesBasePath_);
        NodeIterator templateIter = templatesHome.getNodes();
        while (templateIter.hasNext()) {
            Node template = templateIter.nextNode();
            if (!template.getProperty(DOCUMENT_TEMPLATE_PROP).getBoolean()) continue;
            contentTypes.add(template.getName());
        }
        session.logout();
        this.nodeTypeListCached.put((Serializable)((Object)NODETYPE_LIST), contentTypes);
        return contentTypes;
    }

    @Override
    public String getSkinPath(String nodeTypeName, String skinName, String locale, String repository) throws Exception {
        Session session = this.getSession(repository);
        Node homeNode = (Node)session.getItem(this.cmsTemplatesBasePath_);
        Node nodeTypeNode = homeNode.getNode(nodeTypeName);
        Orientation orientation = this.getOrientation(locale);
        Node skinNode = null;
        if (orientation.isLT()) {
            try {
                skinNode = nodeTypeNode.getNode(SKINS).getNode(skinName + "-lt");
            }
            catch (PathNotFoundException pne) {
                StringBuilder templateData = new StringBuilder("/**");
                templateData.append("LTR stylesheet for " + nodeTypeNode.getName() + " template").append("*/");
                skinNode = this.addNewSkinNode(homeNode, nodeTypeNode, skinName, "-lt", templateData.toString());
            }
        } else if (orientation.isRT()) {
            try {
                skinNode = nodeTypeNode.getNode(SKINS).getNode(skinName + "-rt");
            }
            catch (PathNotFoundException pne) {
                StringBuilder templateData = new StringBuilder("/**");
                templateData.append("RTL stylesheet for " + nodeTypeNode.getName() + " template").append("*/");
                skinNode = this.addNewSkinNode(homeNode, nodeTypeNode, skinName, "-rt", templateData.toString());
            }
        }
        session.logout();
        return skinNode.getPath();
    }

    @Override
    public String buildDialogForm(String nodeTypeName, String repository) throws Exception {
        if (this.plugins_ == null && this.plugins_.size() == 0) {
            throw new Exception("Cannot find plugin for template");
        }
        TemplatePlugin templatePlugin = this.plugins_.get(0);
        ManageableRepository manageRepo = this.repositoryService_.getRepository(repository);
        NodeType nodeType = manageRepo.getNodeTypeManager().getNodeType(nodeTypeName);
        return templatePlugin.buildDialogForm(nodeType);
    }

    @Override
    public String buildViewForm(String nodeTypeName, String repository) throws Exception {
        if (this.plugins_ == null && this.plugins_.size() == 0) {
            throw new Exception("Cannot find plugin for template");
        }
        TemplatePlugin templatePlugin = this.plugins_.get(0);
        ManageableRepository manageRepo = this.repositoryService_.getRepository(repository);
        NodeType nodeType = manageRepo.getNodeTypeManager().getNodeType(nodeTypeName);
        return templatePlugin.buildViewForm(nodeType);
    }

    @Override
    public String buildStyleSheet(String nodeTypeName, String repository) throws Exception {
        if (this.plugins_ == null && this.plugins_.size() == 0) {
            throw new Exception("Cannot find plugin for template");
        }
        TemplatePlugin templatePlugin = this.plugins_.get(0);
        return templatePlugin.buildStyleSheet(null);
    }

    private Node getTemplateNode(Session session, String type, String nodeTypeName, String templateName) throws Exception {
        Node homeNode = (Node)session.getItem(this.cmsTemplatesBasePath_);
        Node nodeTypeNode = homeNode.getNode(nodeTypeName);
        return nodeTypeNode.getNode(type).getNode(templateName);
    }

    private Node getContentNode(String templateType, Node templatesHome, String nodeTypeName, String label, boolean isDocumentTemplate, String templateName) throws Exception {
        Node nodeTypeHome = null;
        if (!templatesHome.hasNode(nodeTypeName)) {
            nodeTypeHome = Utils.makePath(templatesHome, nodeTypeName, NT_UNSTRUCTURED);
            if (isDocumentTemplate) {
                nodeTypeHome.setProperty(DOCUMENT_TEMPLATE_PROP, true);
            } else {
                nodeTypeHome.setProperty(DOCUMENT_TEMPLATE_PROP, false);
            }
            nodeTypeHome.setProperty(TEMPLATE_LABEL, label);
        } else {
            nodeTypeHome = templatesHome.getNode(nodeTypeName);
        }
        Node specifiedTemplatesHome = null;
        try {
            specifiedTemplatesHome = nodeTypeHome.getNode(templateType);
        }
        catch (PathNotFoundException e) {
            specifiedTemplatesHome = Utils.makePath(nodeTypeHome, templateType, NT_UNSTRUCTURED);
        }
        Node contentNode = null;
        contentNode = specifiedTemplatesHome.hasNode(templateName) ? specifiedTemplatesHome.getNode(templateName) : specifiedTemplatesHome.addNode(templateName, EXO_TEMPLATE);
        return contentNode;
    }

    private void updateDocumentsTemplate(boolean isDocumentTemplate, String repository, String nodeTypeName) {
        if (isDocumentTemplate) {
            List<String> documentList = this.managedDocumentTypesMap.get(repository);
            if (documentList == null) {
                documentList = new ArrayList<String>();
                documentList.add(nodeTypeName);
                this.managedDocumentTypesMap.put(repository, documentList);
            } else if (!documentList.contains(nodeTypeName)) {
                documentList.add(nodeTypeName);
                this.managedDocumentTypesMap.put(repository, documentList);
            }
        }
    }

    private Session getSession(String repository) throws Exception {
        ManageableRepository manageableRepository = this.repositoryService_.getRepository(repository);
        DMSRepositoryConfiguration dmsRepoConfig = this.dmsConfiguration_.getConfig(repository);
        return manageableRepository.getSystemSession(dmsRepoConfig.getSystemWorkspace());
    }

    private Session getSession(String repository, SessionProvider provider) throws Exception {
        ManageableRepository manageableRepository = this.repositoryService_.getRepository(repository);
        DMSRepositoryConfiguration dmsRepoConfig = this.dmsConfiguration_.getConfig(repository);
        return provider.getSession(dmsRepoConfig.getSystemWorkspace(), manageableRepository);
    }

    private boolean hasPermission(String userId, Value[] roles, IdentityRegistry identityRegistry) throws Exception {
        if (SystemIdentity.SYSTEM.equalsIgnoreCase(userId)) {
            return true;
        }
        Identity identity = identityRegistry.getIdentity(userId);
        if (identity == null) {
            return false;
        }
        for (int i = 0; i < roles.length; ++i) {
            String role = roles[i].getString();
            if ("*".equalsIgnoreCase(role)) {
                return true;
            }
            MembershipEntry membershipEntry = MembershipEntry.parse((String)role);
            if (!identity.isMemberOf(membershipEntry)) continue;
            return true;
        }
        return false;
    }

    private boolean hasPublicTemplate(Value[] roles) throws Exception {
        for (int i = 0; i < roles.length; ++i) {
            String role = roles[i].getString();
            if (!"*".equalsIgnoreCase(role)) continue;
            return true;
        }
        return false;
    }

    private Orientation getOrientation(String locale) throws Exception {
        return this.localeConfigService_.getLocaleConfig(locale).getOrientation();
    }

    private Node addNewSkinNode(Node templatesHome, Node nodeTypeNode, String skinName, String orientation, String templateData) throws Exception {
        String label = nodeTypeNode.getProperty(TEMPLATE_LABEL).getString();
        Node contentNode = this.getContentNode(SKINS, templatesHome, nodeTypeNode.getName(), label, true, skinName + orientation);
        contentNode.setProperty(EXO_ROLES_PROP, new String[]{"*"});
        contentNode.setProperty(EXO_TEMPLATE_FILE_PROP, templateData);
        nodeTypeNode.getSession().save();
        return nodeTypeNode.getNode(SKINS).getNode(skinName + orientation);
    }

    private void removeTemplateNodeTypeList() throws Exception {
        this.nodeTypeListCached.clearCache();
    }
}

