/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.query.InvalidQueryException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.WildcardQuery;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.services.document.DocumentReaderService;
import org.exoplatform.services.jcr.config.QueryHandlerEntry;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeDataManager;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.ItemStateChangesLog;
import org.exoplatform.services.jcr.dataflow.persistent.MandatoryItemsPersistenceListener;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.NamespaceRegistryImpl;
import org.exoplatform.services.jcr.impl.core.SessionDataManager;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.query.AbstractQueryImpl;
import org.exoplatform.services.jcr.impl.core.query.DefaultChangesFilter;
import org.exoplatform.services.jcr.impl.core.query.IndexException;
import org.exoplatform.services.jcr.impl.core.query.IndexerChangesFilter;
import org.exoplatform.services.jcr.impl.core.query.IndexingTree;
import org.exoplatform.services.jcr.impl.core.query.QueryHandler;
import org.exoplatform.services.jcr.impl.core.query.QueryHandlerContext;
import org.exoplatform.services.jcr.impl.core.query.RepositoryIndexSearcherHolder;
import org.exoplatform.services.jcr.impl.core.query.SystemSearchManagerHolder;
import org.exoplatform.services.jcr.impl.core.query.lucene.FieldNames;
import org.exoplatform.services.jcr.impl.core.query.lucene.LuceneVirtualTableResolver;
import org.exoplatform.services.jcr.impl.core.query.lucene.QueryHits;
import org.exoplatform.services.jcr.impl.core.query.lucene.ScoreNode;
import org.exoplatform.services.jcr.impl.core.query.lucene.SearchIndex;
import org.exoplatform.services.jcr.impl.core.value.NameValue;
import org.exoplatform.services.jcr.impl.core.value.PathValue;
import org.exoplatform.services.jcr.impl.core.value.ValueFactoryImpl;
import org.exoplatform.services.jcr.impl.dataflow.persistent.WorkspacePersistentDataManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.jboss.cache.factories.annotations.NonVolatile;
import org.picocontainer.Startable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonVolatile
public class SearchManager
implements Startable,
MandatoryItemsPersistenceListener {
    private static final Log log = ExoLogger.getLogger(SearchManager.class);
    protected final QueryHandlerEntry config;
    protected final DocumentReaderService extractor;
    protected QueryHandler handler;
    protected final ItemDataConsumer itemMgr;
    protected final NamespaceRegistryImpl nsReg;
    protected final NodeTypeDataManager nodeTypeDataManager;
    protected final SearchManager parentSearchManager;
    protected IndexingTree indexingTree;
    private final ConfigurationManager cfm;
    protected LuceneVirtualTableResolver virtualTableResolver;
    protected IndexerChangesFilter changesFilter;

    public SearchManager(QueryHandlerEntry config, NamespaceRegistryImpl nsReg, NodeTypeDataManager ntReg, WorkspacePersistentDataManager itemMgr, SystemSearchManagerHolder parentSearchManager, DocumentReaderService extractor, ConfigurationManager cfm, RepositoryIndexSearcherHolder indexSearcherHolder) throws RepositoryException, RepositoryConfigurationException {
        this.extractor = extractor;
        indexSearcherHolder.addIndexSearcher(this);
        this.config = config;
        this.nodeTypeDataManager = ntReg;
        this.nsReg = nsReg;
        this.itemMgr = itemMgr;
        this.cfm = cfm;
        this.virtualTableResolver = new LuceneVirtualTableResolver(this.nodeTypeDataManager, nsReg);
        SearchManager searchManager = this.parentSearchManager = parentSearchManager != null ? parentSearchManager.get() : null;
        if (parentSearchManager != null) {
            ((WorkspacePersistentDataManager)this.itemMgr).addItemPersistenceListener(this);
        }
    }

    public void createNewOrAdd(String key, ItemState state, Map<String, List<ItemState>> updatedNodes) {
        List<ItemState> list = updatedNodes.get(key);
        if (list == null) {
            list = new ArrayList<ItemState>();
            updatedNodes.put(key, list);
        }
        list.add(state);
    }

    public javax.jcr.query.Query createQuery(SessionImpl session, SessionDataManager sessionDataManager, Node node) throws InvalidQueryException, RepositoryException {
        AbstractQueryImpl query = this.createQueryInstance();
        query.init(session, sessionDataManager, this.handler, node);
        return query;
    }

    public javax.jcr.query.Query createQuery(SessionImpl session, SessionDataManager sessionDataManager, String statement, String language) throws InvalidQueryException, RepositoryException {
        AbstractQueryImpl query = this.createQueryInstance();
        query.init(session, sessionDataManager, this.handler, statement, language);
        return query;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Set<String> getFieldNames() throws IndexException {
        HashSet<String> fildsSet = new HashSet<String>();
        if (!(this.handler instanceof SearchIndex)) return fildsSet;
        IndexReader reader = null;
        try {
            try {
                reader = ((SearchIndex)this.handler).getIndexReader();
                Collection fields = reader.getFieldNames(IndexReader.FieldOption.ALL);
                for (Object field : fields) {
                    fildsSet.add((String)field);
                }
                Object var7_7 = null;
            }
            catch (IOException e) {
                throw new IndexException(e.getLocalizedMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                if (reader == null) throw throwable;
                reader.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new IndexException(e.getLocalizedMessage(), e);
            }
        }
        try {}
        catch (IOException e) {
            throw new IndexException(e.getLocalizedMessage(), e);
        }
        if (reader == null) return fildsSet;
        reader.close();
        return fildsSet;
    }

    public QueryHandler getHandler() {
        return this.handler;
    }

    public Set<String> getNodesByNodeType(InternalQName nodeType) throws RepositoryException {
        return this.getNodes(this.virtualTableResolver.resolve(nodeType, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getNodesByUri(String uri) throws RepositoryException {
        Set<String> result;
        int defaultClauseCount = BooleanQuery.getMaxClauseCount();
        try {
            ValueFactoryImpl valueFactory = new ValueFactoryImpl(new LocationFactory(this.nsReg));
            BooleanQuery.setMaxClauseCount((int)Integer.MAX_VALUE);
            BooleanQuery query = new BooleanQuery();
            String prefix = this.nsReg.getNamespacePrefixByURI(uri);
            query.add((Query)new WildcardQuery(new Term(FieldNames.LABEL, prefix + ":*")), BooleanClause.Occur.SHOULD);
            query.add((Query)new WildcardQuery(new Term(FieldNames.PROPERTIES_SET, prefix + ":*")), BooleanClause.Occur.SHOULD);
            result = this.getNodes((Query)query);
            try {
                Set<String> props = this.getFieldNames();
                query = new BooleanQuery();
                for (String fieldName : props) {
                    if (FieldNames.PROPERTIES_SET.equals(fieldName)) continue;
                    query.add((Query)new WildcardQuery(new Term(fieldName, "*" + prefix + ":*")), BooleanClause.Occur.SHOULD);
                }
            }
            catch (IndexException e) {
                throw new RepositoryException(e.getLocalizedMessage(), (Throwable)((Object)e));
            }
            Set<String> propSet = this.getNodes((Query)query);
            for (String uuid : propSet) {
                if (!this.isPrefixMatch(valueFactory, uuid, prefix)) continue;
                result.add(uuid);
            }
            Object var11_11 = null;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            BooleanQuery.setMaxClauseCount((int)defaultClauseCount);
            throw throwable;
        }
        BooleanQuery.setMaxClauseCount((int)defaultClauseCount);
        return result;
    }

    @Override
    public void onSaveItems(ItemStateChangesLog itemStates) {
        if (itemStates.getSize() > 0 && this.changesFilter != null) {
            this.changesFilter.onSaveItems(itemStates);
        }
    }

    public void start() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"start");
        }
        try {
            if (this.indexingTree == null) {
                ArrayList<QPath> excludedPath = new ArrayList<QPath>();
                excludedPath.add(Constants.JCR_SYSTEM_PATH);
                String excludedNodeIdentifer = this.config.getParameterValue("excluded-node-identifers", null);
                if (excludedNodeIdentifer != null) {
                    StringTokenizer stringTokenizer = new StringTokenizer(excludedNodeIdentifer);
                    while (stringTokenizer.hasMoreTokens()) {
                        try {
                            ItemData excludeData = this.itemMgr.getItemData(stringTokenizer.nextToken());
                            if (excludeData == null) continue;
                            excludedPath.add(excludeData.getQPath());
                        }
                        catch (RepositoryException e) {
                            log.warn((Object)e.getLocalizedMessage());
                        }
                    }
                }
                NodeData indexingRootData = null;
                String rootNodeIdentifer = this.config.getParameterValue("root-node-id", null);
                if (rootNodeIdentifer != null) {
                    try {
                        ItemData indexingRootDataItem = this.itemMgr.getItemData(rootNodeIdentifer);
                        if (indexingRootDataItem != null && indexingRootDataItem.isNode()) {
                            indexingRootData = (NodeData)indexingRootDataItem;
                        }
                    }
                    catch (RepositoryException e) {
                        log.warn((Object)(e.getLocalizedMessage() + " Indexing root set to " + Constants.ROOT_PATH.getAsString()));
                    }
                } else {
                    try {
                        indexingRootData = (NodeData)this.itemMgr.getItemData("00exo0jcr0root0uuid0000000000000");
                    }
                    catch (RepositoryException e) {
                        log.error((Object)"Fail to load root node data");
                    }
                }
                this.indexingTree = new IndexingTree(indexingRootData, excludedPath);
            }
            this.initializeQueryHandler();
        }
        catch (RepositoryException e) {
            log.error((Object)e.getLocalizedMessage());
            this.handler = null;
            throw new RuntimeException(e.getLocalizedMessage(), e.getCause());
        }
        catch (RepositoryConfigurationException e) {
            log.error((Object)e.getLocalizedMessage());
            this.handler = null;
            throw new RuntimeException(e.getLocalizedMessage(), e.getCause());
        }
    }

    public void stop() {
        this.handler.close();
        log.info((Object)"Search manager stopped");
    }

    public void updateIndex(final Set<String> removedNodes, final Set<String> addedNodes) throws RepositoryException, IOException {
        if (this.handler != null) {
            Iterator<NodeData> addedStates = new Iterator<NodeData>(){
                private final Iterator<String> iter;
                {
                    this.iter = addedNodes.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.iter.hasNext();
                }

                @Override
                public NodeData next() {
                    do {
                        String id = this.iter.next();
                        try {
                            ItemData item = SearchManager.this.itemMgr.getItemData(id);
                            if (item != null) {
                                if (item.isNode()) {
                                    if (SearchManager.this.indexingTree.isExcluded(item)) continue;
                                    return (NodeData)item;
                                }
                                log.warn((Object)("Node not found, but property " + id + ", " + item.getQPath().getAsString() + " found. "));
                                continue;
                            }
                            log.warn((Object)("Unable to index node with id " + id + ", node does not exist."));
                        }
                        catch (RepositoryException e) {
                            log.error((Object)("Can't read next node data " + id), (Throwable)e);
                        }
                    } while (this.iter.hasNext());
                    return null;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
            Iterator<String> removedIds = new Iterator<String>(){
                private final Iterator<String> iter;
                {
                    this.iter = removedNodes.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.iter.hasNext();
                }

                @Override
                public String next() {
                    return this.nextNodeId();
                }

                public String nextNodeId() throws NoSuchElementException {
                    return this.iter.next();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
            if (removedNodes.size() > 0 || addedNodes.size() > 0) {
                this.handler.updateNodes(removedIds, addedStates);
            }
        }
    }

    protected QueryHandlerContext createQueryHandlerContext(QueryHandler parentHandler) throws RepositoryConfigurationException {
        QueryHandlerContext context = new QueryHandlerContext(this.itemMgr, this.indexingTree, this.nodeTypeDataManager, this.nsReg, parentHandler, this.getIndexDir(), this.extractor, true, this.virtualTableResolver);
        return context;
    }

    protected AbstractQueryImpl createQueryInstance() throws RepositoryException {
        try {
            String queryImplClassName = this.handler.getQueryClass();
            Object obj = Class.forName(queryImplClassName).newInstance();
            if (obj instanceof AbstractQueryImpl) {
                return (AbstractQueryImpl)obj;
            }
            throw new IllegalArgumentException(queryImplClassName + " is not of type " + AbstractQueryImpl.class.getName());
        }
        catch (Throwable t) {
            throw new RepositoryException("Unable to create query: " + t.toString(), t);
        }
    }

    protected String getIndexDir() throws RepositoryConfigurationException {
        String dir = this.config.getParameterValue("index-dir", null);
        if (dir == null) {
            log.warn((Object)"index-dir parameter not found. Using outdated parameter name indexDir");
            dir = this.config.getParameterValue("indexDir");
        }
        return dir;
    }

    protected IndexingTree getIndexingTree() {
        return this.indexingTree;
    }

    protected IndexerChangesFilter initializeChangesFilter() throws RepositoryException, RepositoryConfigurationException {
        IndexerChangesFilter newChangesFilter = null;
        Class changesFilterClass = DefaultChangesFilter.class;
        String changesFilterClassName = this.config.getParameterValue("changesfilter-class", null);
        try {
            if (changesFilterClassName != null) {
                changesFilterClass = Class.forName(changesFilterClassName, true, this.getClass().getClassLoader());
            }
            Constructor constuctor = changesFilterClass.getConstructor(SearchManager.class, SearchManager.class, QueryHandlerEntry.class, IndexingTree.class, IndexingTree.class, QueryHandler.class, QueryHandler.class, ConfigurationManager.class);
            if (this.parentSearchManager != null) {
                newChangesFilter = (IndexerChangesFilter)constuctor.newInstance(this, this.parentSearchManager, this.config, this.indexingTree, this.parentSearchManager.getIndexingTree(), this.handler, this.parentSearchManager.getHandler(), this.cfm);
            }
        }
        catch (SecurityException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        return newChangesFilter;
    }

    protected void initializeQueryHandler() throws RepositoryException, RepositoryConfigurationException {
        String className = this.config.getType();
        if (className == null) {
            throw new RepositoryConfigurationException("Content hanler       configuration fail");
        }
        try {
            Class<?> qHandlerClass = Class.forName(className, true, this.getClass().getClassLoader());
            Constructor<?> constuctor = qHandlerClass.getConstructor(QueryHandlerEntry.class, ConfigurationManager.class);
            this.handler = (QueryHandler)constuctor.newInstance(this.config, this.cfm);
            QueryHandler parentHandler = this.parentSearchManager != null ? this.parentSearchManager.getHandler() : null;
            QueryHandlerContext context = this.createQueryHandlerContext(parentHandler);
            this.handler.setContext(context);
            if (this.parentSearchManager != null) {
                this.changesFilter = this.initializeChangesFilter();
            }
        }
        catch (SecurityException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
    }

    private Set<String> getNodes(Query query) throws RepositoryException {
        HashSet<String> result = new HashSet<String>();
        try {
            ScoreNode sn;
            QueryHits hits = this.handler.executeQuery(query);
            while ((sn = hits.nextScoreNode()) != null) {
                result.add(sn.getNodeId());
            }
        }
        catch (IOException e) {
            throw new RepositoryException(e.getLocalizedMessage(), (Throwable)e);
        }
        return result;
    }

    private boolean isPrefixMatch(InternalQName value, String prefix) throws RepositoryException {
        return value.getNamespace().equals(this.nsReg.getNamespaceURIByPrefix(prefix));
    }

    private boolean isPrefixMatch(QPath value, String prefix) throws RepositoryException {
        for (int i = 0; i < value.getEntries().length; ++i) {
            if (!this.isPrefixMatch(value.getEntries()[i], prefix)) continue;
            return true;
        }
        return false;
    }

    private boolean isPrefixMatch(ValueFactoryImpl valueFactory, String uuid, String prefix) throws RepositoryException {
        ItemData node = this.itemMgr.getItemData(uuid);
        if (node != null && node.isNode()) {
            List<PropertyData> props = this.itemMgr.getChildPropertiesData((NodeData)node);
            for (PropertyData propertyData : props) {
                if (propertyData.getType() != 8 && propertyData.getType() != 7) continue;
                for (ValueData vdata : propertyData.getValues()) {
                    Value val = valueFactory.loadValue(vdata, propertyData.getType());
                    if (!(propertyData.getType() == 8 ? this.isPrefixMatch(((PathValue)val).getQPath(), prefix) : propertyData.getType() == 7 && this.isPrefixMatch(((NameValue)val).getQName(), prefix))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean isTXAware() {
        return false;
    }
}

