/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.chromattic.api.ChromatticIOException;
import org.chromattic.common.CloneableInputStream;
import org.chromattic.common.jcr.Path;
import org.chromattic.core.EntityContext;
import org.chromattic.core.EntityContextState;
import org.chromattic.core.EventBroadcaster;
import org.chromattic.core.ListType;
import org.chromattic.core.NameKind;
import org.chromattic.core.jcr.info.NodeTypeInfo;
import org.chromattic.core.vt.ValueType;
import org.chromattic.spi.instrument.MethodHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ObjectContext
implements MethodHandler {
    public abstract Object getObject();

    public abstract EntityContext getEntity();

    public abstract NodeTypeInfo getTypeInfo();

    public final <V> V getPropertyValue(String propertyName, ValueType<V> type) {
        EntityContext ctx = this.getEntity();
        EntityContextState state = ctx.state;
        propertyName = state.getSession().domain.encodeName(ctx, propertyName, NameKind.PROPERTY);
        Path.validateName((String)propertyName);
        NodeTypeInfo typeInfo = this.getTypeInfo();
        return state.getPropertyValue(typeInfo, propertyName, type);
    }

    public final <V> List<V> getPropertyValues(String propertyName, ValueType<V> simpleType, ListType listType) {
        EntityContext ctx = this.getEntity();
        EntityContextState state = ctx.state;
        propertyName = state.getSession().domain.encodeName(ctx, propertyName, NameKind.PROPERTY);
        Path.validateName((String)propertyName);
        NodeTypeInfo typeInfo = this.getTypeInfo();
        return state.getPropertyValues(typeInfo, propertyName, simpleType, listType);
    }

    public final <V> void setPropertyValue(String propertyName, ValueType<V> type, V o) {
        EntityContext ctx = this.getEntity();
        EntityContextState state = ctx.state;
        propertyName = state.getSession().domain.encodeName(ctx, propertyName, NameKind.PROPERTY);
        Path.validateName((String)propertyName);
        Object object = this.getObject();
        EventBroadcaster broadcaster = state.getSession().broadcaster;
        NodeTypeInfo typeInfo = this.getTypeInfo();
        if (o instanceof InputStream && broadcaster.hasStateChangeListeners()) {
            CloneableInputStream in;
            try {
                in = new CloneableInputStream((InputStream)o);
            }
            catch (IOException e) {
                throw new ChromatticIOException("Could not read stream", e);
            }
            CloneableInputStream v = in;
            state.setPropertyValue(typeInfo, propertyName, type, v);
            broadcaster.propertyChanged(state.getId(), object, propertyName, in.clone());
        } else {
            state.setPropertyValue(typeInfo, propertyName, type, o);
            broadcaster.propertyChanged(state.getId(), object, propertyName, o);
        }
    }

    public final <V> void setPropertyValues(String propertyName, ValueType<V> type, ListType listType, List<V> objects) {
        EntityContext ctx = this.getEntity();
        EntityContextState state = ctx.state;
        propertyName = state.getSession().domain.encodeName(ctx, propertyName, NameKind.PROPERTY);
        Path.validateName((String)propertyName);
        NodeTypeInfo typeInfo = this.getTypeInfo();
        state.setPropertyValues(typeInfo, propertyName, type, listType, objects);
    }
}

