/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.protocol.conversion.xstream;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.thoughtworks.xstream.mapper.Mapper;
import com.thoughtworks.xstream.mapper.MapperWrapper;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.shindig.protocol.conversion.xstream.ClassFieldMapping;
import org.apache.shindig.protocol.conversion.xstream.ImplicitCollectionFieldMapping;
import org.apache.shindig.protocol.conversion.xstream.WriterStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterfaceClassMapper
extends MapperWrapper {
    private static final Logger log = Logger.getLogger(InterfaceClassMapper.class.getName());
    private Map<String, Class<?>> elementClassMap = Maps.newHashMap();
    private ThreadLocal<Class<?>> firstChild = new ThreadLocal();
    private Multimap<String, Class<?>> omitMMap;
    private List<ClassFieldMapping> elementMappingList;
    private List<ClassFieldMapping> listElementMappingList;
    private WriterStack writerStack;
    private List<ImplicitCollectionFieldMapping> itemFieldMappings;

    public InterfaceClassMapper(WriterStack writerStack, Mapper wrapped, List<ClassFieldMapping> elementMappingList, List<ClassFieldMapping> listElementMappingList, List<ImplicitCollectionFieldMapping> itemFieldMappings, Multimap<String, Class<?>> omitMMap, Map<String, Class<?>> elementClassMap) {
        super(wrapped);
        this.elementClassMap = elementClassMap;
        this.elementMappingList = elementMappingList;
        this.listElementMappingList = listElementMappingList;
        this.omitMMap = omitMMap;
        this.writerStack = writerStack;
        this.itemFieldMappings = itemFieldMappings;
    }

    public void setBaseObject(Object base) {
        this.firstChild.set(null);
        if (Collection.class.isAssignableFrom(base.getClass())) {
            Collection c = (Collection)base;
            Class<?> clazz = null;
            for (Object o : c) {
                if (clazz == null) {
                    clazz = o.getClass();
                    continue;
                }
                if (clazz.equals(o.getClass())) continue;
                clazz = null;
                break;
            }
            this.firstChild.set(clazz);
            if (log.isLoggable(Level.FINE)) {
                log.fine("First Child set to " + clazz);
            }
        }
    }

    public String serializedClass(Class type) {
        String parentElementName = this.writerStack.peek();
        if (Collection.class.isAssignableFrom(type) && this.firstChild.get() != null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Converting Child to " + this.firstChild.get());
            }
            type = this.firstChild.get();
            this.firstChild.set(null);
            if (log.isLoggable(Level.FINE)) {
                log.fine("serializedClass(" + type + ") is a collection member " + Collection.class.isAssignableFrom(type));
            }
            for (ClassFieldMapping cfm : this.listElementMappingList) {
                if (!cfm.matches(parentElementName, type)) continue;
                return cfm.getElementName();
            }
            return "list.container";
        }
        this.firstChild.set(null);
        if (log.isLoggable(Level.FINE)) {
            log.fine("serializedClass(" + type + ')');
        }
        for (ClassFieldMapping cfm : this.elementMappingList) {
            if (!cfm.matches(parentElementName, type)) continue;
            if (log.isLoggable(Level.FINE)) {
                log.fine("From MAP serializedClass(" + type + ")  ==" + cfm.getElementName());
            }
            return cfm.getElementName();
        }
        String fieldName = super.serializedClass(type);
        if (log.isLoggable(Level.FINE)) {
            log.fine("--- From Super serializedClass(" + type + ")  ==" + fieldName);
        }
        return fieldName;
    }

    public boolean shouldSerializeMember(Class definedIn, String fieldName) {
        for (Class omit : this.omitMMap.get((Object)fieldName)) {
            if (!omit.isAssignableFrom(definedIn)) continue;
            return false;
        }
        return super.shouldSerializeMember(definedIn, fieldName);
    }

    public Class realClass(String elementName) {
        Class clazz = this.elementClassMap.get(elementName);
        if (clazz == null) {
            clazz = super.realClass(elementName);
        }
        return clazz;
    }

    public Mapper.ImplicitCollectionMapping getImplicitCollectionDefForFieldName(Class itemType, String fieldName) {
        for (ImplicitCollectionFieldMapping ifm : this.itemFieldMappings) {
            if (!ifm.matches(itemType, fieldName)) continue;
            return ifm;
        }
        return super.getImplicitCollectionDefForFieldName(itemType, fieldName);
    }
}

