/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.ext.MessageBodyWriter;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.web.AbstractHttpServlet;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.Connector;
import org.exoplatform.services.rest.ContainerResponseWriter;
import org.exoplatform.services.rest.GenericContainerResponse;
import org.exoplatform.services.rest.RequestHandler;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.services.rest.impl.EnvironmentContext;
import org.exoplatform.services.rest.impl.header.HeaderHelper;
import org.exoplatform.services.rest.servlet.ServletContainerRequest;

public class RestServlet
extends AbstractHttpServlet
implements Connector {
    private static final Log LOG = ExoLogger.getLogger((String)RestServlet.class.getName());
    private static final long serialVersionUID = 2152962763071591181L;

    protected void onService(ExoContainer container, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
        RequestHandler requestHandler = (RequestHandler)container.getComponentInstanceOfType(RequestHandler.class);
        EnvironmentContext env = new EnvironmentContext();
        env.put(HttpServletRequest.class, httpRequest);
        env.put(HttpServletResponse.class, httpResponse);
        env.put(ServletConfig.class, this.config);
        env.put(ServletContext.class, this.getServletContext());
        try {
            EnvironmentContext.setCurrent(env);
            ServletContainerRequest request = new ServletContainerRequest(httpRequest);
            ContainerResponse response = new ContainerResponse(new ServletContainerResponseWriter(httpResponse));
            requestHandler.handleRequest(request, response);
        }
        catch (Exception e) {
            LOG.error((Object)e);
            throw new ServletException((Throwable)e);
        }
        finally {
            EnvironmentContext.setCurrent(null);
        }
    }

    class ServletContainerResponseWriter
    implements ContainerResponseWriter {
        private HttpServletResponse servletResponse;

        ServletContainerResponseWriter(HttpServletResponse response) {
            this.servletResponse = response;
        }

        public void writeBody(GenericContainerResponse response, MessageBodyWriter entityWriter) throws IOException {
            Object entity = response.getEntity();
            if (entity != null) {
                ServletOutputStream out = this.servletResponse.getOutputStream();
                entityWriter.writeTo(entity, entity.getClass(), response.getEntityType(), null, response.getContentType(), response.getHttpHeaders(), (OutputStream)out);
                out.flush();
            }
        }

        public void writeHeaders(GenericContainerResponse response) throws IOException {
            if (this.servletResponse.isCommitted()) {
                return;
            }
            this.servletResponse.setStatus(response.getStatus());
            if (response.getHttpHeaders() != null) {
                for (Map.Entry e : response.getHttpHeaders().entrySet()) {
                    String name = (String)e.getKey();
                    for (Object o : (List)e.getValue()) {
                        String value = null;
                        if (o == null || (value = HeaderHelper.getHeaderAsString(o)) == null) continue;
                        this.servletResponse.addHeader(name, value);
                    }
                }
            }
        }
    }
}

