/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.navigation;

import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIMaskWorkspace;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.portal.webui.workspace.UIWorkingWorkspace;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.UIRepeater;
import org.exoplatform.webui.core.UIVirtualList;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfigs(value={@ComponentConfig(template="system:/groovy/portal/webui/navigation/UIAddGroupNavigation.gtmpl", events={@EventConfig(listeners={UIMaskWorkspace.CloseActionListener.class}), @EventConfig(listeners={AddNavigationActionListener.class})}), @ComponentConfig(id="UIAddGroupNavigationGrid", type=UIRepeater.class, template="system:/groovy/portal/webui/navigation/UIGroupGrid.gtmpl")})
public class UIAddGroupNavigation
extends UIContainer {
    public UIAddGroupNavigation() throws Exception {
        UIVirtualList virtualList = (UIVirtualList)this.addChild(UIVirtualList.class, null, "AddGroupNavList");
        virtualList.setPageSize(6);
        UIRepeater repeater = (UIRepeater)this.createUIComponent(UIRepeater.class, "UIAddGroupNavigationGrid", null);
        virtualList.setUIComponent((UIComponent)repeater);
        UIPopupWindow editGroup = (UIPopupWindow)this.addChild(UIPopupWindow.class, null, "EditGroup");
    }

    public void loadGroups() throws Exception {
        PortalRequestContext pContext = Util.getPortalRequestContext();
        UserPortalConfigService dataService = (UserPortalConfigService)this.getApplicationComponent(UserPortalConfigService.class);
        UserACL userACL = (UserACL)this.getApplicationComponent(UserACL.class);
        OrganizationService orgService = (OrganizationService)this.getApplicationComponent(OrganizationService.class);
        ArrayList<String> listGroup = null;
        if (userACL.isUserInGroup(userACL.getAdminGroups()) && !userACL.getSuperUser().equals(pContext.getRemoteUser())) {
            List temp = (List)orgService.getGroupHandler().findGroupsOfUser(pContext.getRemoteUser());
            if (temp != null) {
                listGroup = new ArrayList();
                for (Object group : temp) {
                    Group m = (Group)group;
                    String groupId = m.getId().trim();
                    listGroup.add(groupId);
                }
            }
        } else {
            listGroup = dataService.getMakableNavigations(pContext.getRemoteUser(), false);
        }
        if (listGroup == null) {
            listGroup = new ArrayList<String>();
        }
        UserPortalConfigService configService = (UserPortalConfigService)this.getApplicationComponent(UserPortalConfigService.class);
        Set groupIdsHavingNavigation = configService.findGroupHavingNavigation();
        listGroup.removeAll(groupIdsHavingNavigation);
        UIVirtualList virtualList = (UIVirtualList)this.getChild(UIVirtualList.class);
        virtualList.dataBind((PageList)new ObjectPageList(listGroup, listGroup.size()));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddNavigationActionListener
    extends EventListener<UIAddGroupNavigation> {
        public void execute(Event<UIAddGroupNavigation> event) throws Exception {
            WebuiRequestContext ctx = event.getRequestContext();
            UIAddGroupNavigation uicomp = (UIAddGroupNavigation)((Object)event.getSource());
            String ownerId = event.getRequestContext().getRequestParameter("objectId");
            ownerId = URLDecoder.decode(ownerId);
            PageNavigation pageNav = new PageNavigation();
            pageNav.setPriority(1);
            pageNav.setModifiable(true);
            pageNav.setOwnerId(ownerId);
            pageNav.setOwnerType("group");
            UIPortalApplication uiPortalApp = (UIPortalApplication)Util.getUIPortal().getAncestorOfType(UIPortalApplication.class);
            DataStorage dataService = (DataStorage)uicomp.getApplicationComponent(DataStorage.class);
            if (dataService.getPageNavigation(pageNav.getOwnerType(), pageNav.getOwnerId()) != null) {
                uiPortalApp.addMessage(new ApplicationMessage("UIPageNavigationForm.msg.existPageNavigation", (Object[])new String[]{pageNav.getOwnerId()}));
                return;
            }
            if (dataService.getPortalConfig("group", ownerId) == null) {
                UserPortalConfigService configService = (UserPortalConfigService)uicomp.getApplicationComponent(UserPortalConfigService.class);
                configService.createGroupSite(ownerId);
            }
            dataService.create(pageNav);
            UIPortal uiPortal = Util.getUIPortal();
            uiPortal.getNavigations().add(pageNav);
            ctx.addUIComponentToUpdateByAjax((UIComponent)uicomp);
            UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)uiPortalApp.getChild(UIWorkingWorkspace.class);
            uiWorkingWS.updatePortletsByName("GroupNavigationPortlet");
            uiWorkingWS.updatePortletsByName("UserToolbarGroupPortlet");
        }
    }
}

