/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.graph.exe;

import org.jbpm.context.exe.ContextInstance;
import org.jbpm.graph.def.Action;
import org.jbpm.graph.def.Event;
import org.jbpm.graph.def.GraphElement;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.def.Transition;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;
import org.jbpm.module.def.ModuleDefinition;
import org.jbpm.module.exe.ModuleInstance;
import org.jbpm.scheduler.exe.SchedulerInstance;
import org.jbpm.taskmgmt.def.Task;
import org.jbpm.taskmgmt.exe.TaskInstance;
import org.jbpm.taskmgmt.exe.TaskMgmtInstance;

public class ExecutionContext {
    protected Token token = null;
    protected Event event = null;
    protected GraphElement eventSource = null;
    protected Action action = null;
    protected Throwable exception = null;
    protected Transition transition = null;
    protected Node transitionSource = null;
    protected Task task = null;
    protected TaskInstance taskInstance = null;

    public ExecutionContext(Token token) {
        this.token = token;
    }

    public ExecutionContext(ExecutionContext other) {
        this.token = other.token;
        this.event = other.event;
        this.action = other.action;
    }

    public Node getNode() {
        return this.token.getNode();
    }

    public ProcessDefinition getProcessDefinition() {
        ProcessInstance processInstance = this.getProcessInstance();
        return processInstance != null ? processInstance.getProcessDefinition() : null;
    }

    public void setAction(Action action) {
        this.action = action;
        if (action != null) {
            this.event = action.getEvent();
        }
    }

    public ProcessInstance getProcessInstance() {
        return this.token.getProcessInstance();
    }

    public String toString() {
        return "ExecutionContext[" + this.token + "]";
    }

    public void setVariable(String name, Object value) {
        this.getContextInstance().setVariable(name, value, this.token);
    }

    public Object getVariable(String name) {
        return this.getContextInstance().getVariable(name, this.token);
    }

    public void leaveNode() {
        this.getNode().leave(this);
    }

    public void leaveNode(String transitionName) {
        this.getNode().leave(this, transitionName);
    }

    public void leaveNode(Transition transition) {
        this.getNode().leave(this, transition);
    }

    public ModuleDefinition getDefinition(Class clazz) {
        return this.getProcessDefinition().getDefinition(clazz);
    }

    public ModuleInstance getInstance(Class clazz) {
        ProcessInstance processInstance = this.token != null ? this.token.getProcessInstance() : null;
        return processInstance != null ? processInstance.getInstance(clazz) : null;
    }

    public ContextInstance getContextInstance() {
        return (ContextInstance)this.getInstance(ContextInstance.class);
    }

    public TaskMgmtInstance getTaskMgmtInstance() {
        return (TaskMgmtInstance)this.getInstance(TaskMgmtInstance.class);
    }

    public SchedulerInstance getSchedulerInstance() {
        return (SchedulerInstance)this.getInstance(SchedulerInstance.class);
    }

    public Token getToken() {
        return this.token;
    }

    public Action getAction() {
        return this.action;
    }

    public Event getEvent() {
        return this.event;
    }

    public void setEvent(Event event) {
        this.event = event;
    }

    public Throwable getException() {
        return this.exception;
    }

    public void setException(Throwable exception) {
        this.exception = exception;
    }

    public Transition getTransition() {
        return this.transition;
    }

    public void setTransition(Transition transition) {
        this.transition = transition;
    }

    public Node getTransitionSource() {
        return this.transitionSource;
    }

    public void setTransitionSource(Node transitionSource) {
        this.transitionSource = transitionSource;
    }

    public GraphElement getEventSource() {
        return this.eventSource;
    }

    public void setEventSource(GraphElement eventSource) {
        this.eventSource = eventSource;
    }

    public Task getTask() {
        return this.task;
    }

    public void setTask(Task task) {
        this.task = task;
    }

    public TaskInstance getTaskInstance() {
        return this.taskInstance;
    }

    public void setTaskInstance(TaskInstance taskInstance) {
        this.taskInstance = taskInstance;
    }
}

