/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.graph.node;

import java.util.HashSet;
import java.util.Set;
import org.dom4j.Element;
import org.jbpm.context.def.VariableAccess;
import org.jbpm.context.exe.ContextInstance;
import org.jbpm.db.JbpmSession;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;
import org.jbpm.jpdl.xml.JpdlXmlReader;
import org.jbpm.jpdl.xml.Parsable;

public class ProcessState
extends Node
implements Parsable {
    private static final long serialVersionUID = 1L;
    protected transient String subProcessName = null;
    protected transient String subProcessVersion = null;
    protected ProcessDefinition subProcessDefinition = null;
    protected Set variableAccesses = null;
    public static final String[] supportedEventTypes = new String[]{"subprocess-created", "subprocess-end", "node-enter", "node-leave", "before-signal", "after-signal"};

    public String[] getSupportedEventTypes() {
        return supportedEventTypes;
    }

    public void read(Element processStateElement, JpdlXmlReader jpdlReader) {
        JbpmSession jbpmSession;
        Element subProcessElement = processStateElement.element("sub-process");
        if (subProcessElement != null) {
            this.subProcessName = subProcessElement.attributeValue("name");
            this.subProcessVersion = subProcessElement.attributeValue("version");
        }
        if ((jbpmSession = JbpmSession.getCurrentJbpmSession()) != null) {
            if (this.subProcessName != null) {
                if (this.subProcessVersion != null) {
                    try {
                        int version = Integer.parseInt(this.subProcessVersion);
                        this.subProcessDefinition = jbpmSession.getGraphSession().findProcessDefinition(this.subProcessName, version);
                    }
                    catch (NumberFormatException e) {
                        jpdlReader.addWarning("version in process-state was not a number: " + processStateElement.asXML());
                    }
                } else {
                    this.subProcessDefinition = jbpmSession.getGraphSession().findLatestProcessDefinition(this.subProcessName);
                }
            } else {
                jpdlReader.addWarning("no sub-process name specified in process-state " + processStateElement.asXML());
            }
        }
        if (this.subProcessName != null && this.subProcessDefinition == null && this.subProcessVersion == null && this.subProcessName.equals(this.processDefinition.getName())) {
            this.subProcessDefinition = this.processDefinition;
        }
        this.variableAccesses = new HashSet(jpdlReader.readVariableAccesses(processStateElement));
    }

    public void execute(ExecutionContext executionContext) {
        Token superProcessToken = executionContext.getToken();
        ProcessInstance subProcessInstance = new ProcessInstance(this.subProcessDefinition);
        superProcessToken.setSubProcessInstance(subProcessInstance);
        subProcessInstance.setSuperProcessToken(superProcessToken);
        this.fireEvent("subprocess-created", executionContext);
        if (this.variableAccesses != null && !this.variableAccesses.isEmpty()) {
            ContextInstance superContextInstance = executionContext.getContextInstance();
            ContextInstance subContextInstance = subProcessInstance.getContextInstance();
            for (VariableAccess variableAccess : this.variableAccesses) {
                if (!variableAccess.isReadable()) continue;
                String variableName = variableAccess.getVariableName();
                Object value = superContextInstance.getVariable(variableName, superProcessToken);
                String mappedName = variableAccess.getMappedName();
                subContextInstance.setVariable(mappedName, value);
            }
        }
        subProcessInstance.signal();
    }

    public void notifySubProcessEnd(ProcessInstance subProcessInstance) {
        Token superProcessToken = subProcessInstance.getSuperProcessToken();
        ExecutionContext executionContext = new ExecutionContext(superProcessToken);
        if (this.variableAccesses != null && !this.variableAccesses.isEmpty()) {
            ContextInstance superContextInstance = executionContext.getContextInstance();
            ContextInstance subContextInstance = subProcessInstance.getContextInstance();
            for (VariableAccess variableAccess : this.variableAccesses) {
                if (!variableAccess.isWritable()) continue;
                String mappedName = variableAccess.getMappedName();
                Object value = subContextInstance.getVariable(mappedName);
                String variableName = variableAccess.getVariableName();
                superContextInstance.setVariable(variableName, value, superProcessToken);
            }
        }
        this.fireEvent("subprocess-end", executionContext);
        superProcessToken.setSubProcessInstance(null);
        super.leave(executionContext, this.getDefaultLeavingTransition());
    }

    public ProcessDefinition getSubProcessDefinition() {
        return this.subProcessDefinition;
    }

    public void setSubProcessDefinition(ProcessDefinition subProcessDefinition) {
        this.subProcessDefinition = subProcessDefinition;
    }
}

