/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jpdl.xml;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.jbpm.jpdl.xml.Problem;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class SchemaValidationHelper {
    private static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private Reader reader;
    private String schemaName;
    private String subject;
    private List errors = new ArrayList();
    private Document document;
    private boolean valid = true;
    private static final Log log = LogFactory.getLog(SchemaValidationHelper.class);

    public SchemaValidationHelper(Reader reader, String schemaName, String subject) {
        this.reader = reader;
        this.schemaName = schemaName;
        this.subject = subject;
    }

    public boolean isValid() {
        try {
            SAXReader saxReader = new SAXReader();
            saxReader.setErrorHandler((ErrorHandler)new Handler());
            saxReader.setEntityResolver((EntityResolver)new Resolver());
            try {
                saxReader.setFeature("http://apache.org/xml/features/validation/schema", true);
                saxReader.setFeature("http://apache.org/xml/features/validation/schema-full-checking", true);
                saxReader.setFeature("http://apache.org/xml/features/validation/dynamic", true);
                saxReader.setProperty(JAXP_SCHEMA_LANGUAGE, (Object)W3C_XML_SCHEMA);
                saxReader.setProperty("http://apache.org/xml/properties/schema/external-schemaLocation", (Object)"http://jbpm.org/3/jpdl jpdl-3.0.xsd");
            }
            catch (SAXException se) {
                log.warn((Object)"Unable to validate using schema.  Make sure Xerces is first in your class path.");
            }
            this.document = saxReader.read(this.reader);
        }
        catch (DocumentException de) {
            log.error((Object)"Parsing problems", (Throwable)de);
        }
        return this.valid;
    }

    public List getProblems() {
        return this.errors;
    }

    public Document getDocument() {
        return this.document;
    }

    class Resolver
    implements EntityResolver {
        Resolver() {
        }

        public InputSource resolveEntity(String publicId, String SystemId) throws SAXException, IOException {
            return new InputSource(this.getClass().getResourceAsStream(SchemaValidationHelper.this.schemaName));
        }
    }

    class Handler
    extends DefaultHandler {
        Handler() {
        }

        public void warning(SAXParseException pe) {
            SchemaValidationHelper.this.errors.add(new Problem(3, SchemaValidationHelper.this.subject + " line " + pe.getLineNumber() + ": " + pe.getMessage()));
        }

        public void error(SAXParseException pe) {
            SchemaValidationHelper.this.errors.add(new Problem(2, SchemaValidationHelper.this.subject + " line " + pe.getLineNumber() + ": " + pe.getMessage()));
            SchemaValidationHelper.this.valid = false;
        }

        public void fatalError(SAXParseException pe) {
            SchemaValidationHelper.this.errors.add(new Problem(1, SchemaValidationHelper.this.subject + " line " + pe.getLineNumber() + ": " + pe.getMessage()));
            SchemaValidationHelper.this.valid = false;
        }
    }
}

