/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.workflow.impl.jbpm;

import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.exoplatform.services.workflow.impl.jbpm.ExoSchedulerThread;
import org.jbpm.db.JbpmSessionFactory;
import org.jbpm.scheduler.exe.Timer;
import org.jbpm.scheduler.impl.SchedulerHistoryLog;
import org.jbpm.scheduler.impl.SchedulerListener;

public class ExoScheduler {
    ExoSchedulerThread schedulerThread = null;
    LinkedList historyLogs = new LinkedList();
    int interval = 5000;
    int historyMaxSize = 30;
    private JbpmSessionFactory jbpmSessionFactory;
    private String containerName;

    public ExoScheduler(String containerName) {
        this.containerName = containerName;
    }

    public void start() {
        this.schedulerThread = new ExoSchedulerThread(this.containerName);
        this.schedulerThread.setInterval(this.interval);
        this.schedulerThread.addListener(new HistoryListener());
        this.schedulerThread.start();
    }

    public void stop() {
        if (this.isRunning()) {
            this.schedulerThread.keepRunning = false;
            this.schedulerThread.interrupt();
            this.schedulerThread = null;
        }
    }

    public boolean isRunning() {
        return this.schedulerThread != null && this.schedulerThread.isAlive();
    }

    public List getSchedulerHistoryLogs() {
        return this.historyLogs;
    }

    public void clearSchedulerHistoryLogs() {
        this.historyLogs.clear();
    }

    public int getHistoryMaxSize() {
        return this.historyMaxSize;
    }

    public void setHistoryMaxSize(int historyMaxSize) {
        this.historyMaxSize = historyMaxSize;
    }

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    class HistoryListener
    implements SchedulerListener {
        HistoryListener() {
        }

        public void timerExecuted(Date date, Timer timer) {
            ExoScheduler.this.historyLogs.add(new SchedulerHistoryLog(date, timer));
            if (ExoScheduler.this.historyLogs.size() > ExoScheduler.this.historyMaxSize) {
                ExoScheduler.this.historyLogs.removeLast();
            }
        }
    }
}

