/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.filters;

import java.io.IOException;
import java.util.Stack;
import org.icepdf.core.io.BitStream;
import org.icepdf.core.pobjects.filters.ChunkingInputStream;

public class LZWDecode
extends ChunkingInputStream {
    private BitStream inb;
    private int code;
    private int old_code;
    private boolean firstTime;
    private int code_len;
    private int last_code;
    private Code[] codes;

    public LZWDecode(BitStream bitStream) {
        this.inb = bitStream;
        this.code = 0;
        this.old_code = 0;
        this.firstTime = true;
        this.initCodeTable();
        this.setBufferSize(4096);
    }

    protected int fillInternalBuffer() throws IOException {
        int n = 0;
        if (this.firstTime) {
            this.firstTime = false;
            this.old_code = this.code = this.inb.getBits(this.code_len);
        } else if (this.inb.atEndOfFile()) {
            return -1;
        }
        do {
            if (this.code == 256) {
                this.initCodeTable();
            } else {
                byte by;
                Code code;
                Stack stack;
                if (this.code == 257) break;
                if (this.codes[this.code] != null) {
                    stack = new Stack();
                    this.codes[this.code].getString(stack);
                    code = (Code)stack.pop();
                    this.addToBuffer(code.c, n);
                    ++n;
                    by = code.c;
                    while (!stack.empty()) {
                        code = (Code)stack.pop();
                        this.addToBuffer(code.c, n);
                        ++n;
                    }
                    this.codes[this.last_code++] = new Code(this.codes[this.old_code], by);
                } else {
                    if (this.code != this.last_code) {
                        throw new RuntimeException("LZWDecode failure");
                    }
                    stack = new Stack();
                    this.codes[this.old_code].getString(stack);
                    code = (Code)stack.pop();
                    this.addToBuffer(code.c, n);
                    ++n;
                    by = code.c;
                    while (!stack.empty()) {
                        code = (Code)stack.pop();
                        this.addToBuffer(code.c, n);
                        ++n;
                    }
                    this.addToBuffer(by, n);
                    ++n;
                    this.codes[this.code] = new Code(this.codes[this.old_code], by);
                    ++this.last_code;
                }
            }
            if (this.code_len < 12 && this.last_code == (1 << this.code_len) - 1) {
                ++this.code_len;
            }
            this.old_code = this.code;
            this.code = this.inb.getBits(this.code_len);
        } while (!this.inb.atEndOfFile() && n < this.buffer.length - 512);
        return n;
    }

    private void initCodeTable() {
        this.code_len = 9;
        this.last_code = 257;
        this.codes = new Code[4096];
        for (int i = 0; i < 256; ++i) {
            this.codes[i] = new Code(null, (byte)i);
        }
    }

    private void addToBuffer(byte by, int n) {
        if (n >= this.buffer.length) {
            byte[] byArray = new byte[this.buffer.length * 2];
            System.arraycopy(this.buffer, 0, byArray, 0, this.buffer.length);
            this.buffer = byArray;
        }
        this.buffer[n] = by;
    }

    public void close() throws IOException {
        super.close();
        if (this.inb != null) {
            this.inb.close();
            this.inb = null;
        }
    }

    private static class Code {
        Code prefix;
        byte c;

        Code(Code code, byte by) {
            this.prefix = code;
            this.c = by;
        }

        void getString(Stack stack) {
            stack.push(this);
            if (this.prefix != null) {
                this.prefix.getString(stack);
            }
        }
    }
}

