/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.examples.pdmodel;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.GregorianCalendar;
import java.util.HashMap;
import org.pdfbox.exceptions.COSVisitorException;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.pdmodel.PDDocumentNameDictionary;
import org.pdfbox.pdmodel.PDEmbeddedFilesNameTreeNode;
import org.pdfbox.pdmodel.PDPage;
import org.pdfbox.pdmodel.common.filespecification.PDComplexFileSpecification;
import org.pdfbox.pdmodel.common.filespecification.PDEmbeddedFile;
import org.pdfbox.pdmodel.edit.PDPageContentStream;
import org.pdfbox.pdmodel.font.PDType1Font;

public class EmbeddedFiles {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doIt(String file) throws IOException, COSVisitorException {
        PDDocument doc = null;
        try {
            doc = new PDDocument();
            PDPage page = new PDPage();
            doc.addPage(page);
            PDType1Font font = PDType1Font.HELVETICA_BOLD;
            PDPageContentStream contentStream = new PDPageContentStream(doc, page);
            contentStream.beginText();
            contentStream.setFont(font, 12.0f);
            contentStream.moveTextPositionByAmount(100.0f, 700.0f);
            contentStream.drawString("Go to Document->File Attachments to View Embedded Files");
            contentStream.endText();
            contentStream.close();
            PDEmbeddedFilesNameTreeNode efTree = new PDEmbeddedFilesNameTreeNode();
            PDComplexFileSpecification fs = new PDComplexFileSpecification();
            fs.setFile("Test.txt");
            byte[] data = "This is the contents of the embedded file".getBytes();
            ByteArrayInputStream fakeFile = new ByteArrayInputStream(data);
            PDEmbeddedFile ef = new PDEmbeddedFile(doc, fakeFile);
            ef.setSubtype("test/plain");
            ef.setSize(data.length);
            ef.setCreationDate(new GregorianCalendar());
            fs.setEmbeddedFile(ef);
            HashMap<String, PDComplexFileSpecification> efMap = new HashMap<String, PDComplexFileSpecification>();
            efMap.put("My first attachment", fs);
            efTree.setNames(efMap);
            PDDocumentNameDictionary names = new PDDocumentNameDictionary(doc.getDocumentCatalog());
            names.setEmbeddedFiles(efTree);
            doc.getDocumentCatalog().setNames(names);
            doc.save(file);
        }
        finally {
            if (doc != null) {
                doc.close();
            }
        }
    }

    public static void main(String[] args) {
        EmbeddedFiles app = new EmbeddedFiles();
        try {
            if (args.length != 1) {
                app.usage();
            } else {
                app.doIt(args[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void usage() {
        System.err.println("usage: " + this.getClass().getName() + " <output-file>");
    }
}

