/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.xml.importing.dataflow;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeData;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.impl.dataflow.TransientNodeData;
import org.exoplatform.services.jcr.impl.xml.importing.dataflow.ImportItemData;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportNodeData
extends TransientNodeData
implements ImportItemData {
    private static Log log = ExoLogger.getLogger((String)"jcr.ImportedNodeData");
    private String baseVersionIdentifier;
    private boolean isContainsVersionhistory;
    private boolean isMixReferenceable;
    private boolean isMixVersionable;
    private boolean newIdentifer;
    private final List<NodeTypeData> nodeTypes;
    private String predecessorsIdentifier;
    private String versionHistoryIdentifier;
    private String exoOwner;
    private List<String> exoPrivileges;

    public ImportNodeData(ItemData parent, InternalQName name, int index) {
        this.qpath = QPath.makeChildPath(parent.getQPath(), name, index);
        this.parentIdentifier = parent.getIdentifier();
        this.nodeTypes = new ArrayList<NodeTypeData>();
    }

    public ImportNodeData(QPath path, String identifier, int version, InternalQName primaryTypeName, InternalQName[] mixinTypeNames, int orderNum, String parentIdentifier, AccessControlList acl) {
        super(path, identifier, version, primaryTypeName, mixinTypeNames, orderNum, parentIdentifier, acl);
        this.nodeTypes = new ArrayList<NodeTypeData>();
    }

    public void addNodeType(NodeTypeData nt) {
        this.nodeTypes.add(nt);
    }

    public String getBaseVersionIdentifier() {
        return this.baseVersionIdentifier;
    }

    public String getExoOwner() {
        return this.exoOwner;
    }

    public List<String> getExoPrivileges() {
        return this.exoPrivileges;
    }

    @Override
    public InternalQName[] getMixinTypeNames() {
        if (this.mixinTypeNames == null) {
            return new InternalQName[0];
        }
        return this.mixinTypeNames;
    }

    public List<NodeTypeData> getNodeTypes() {
        return this.nodeTypes;
    }

    public String getPredecessorsIdentifier() {
        return this.predecessorsIdentifier;
    }

    public String getVersionHistoryIdentifier() {
        return this.versionHistoryIdentifier;
    }

    public boolean isContainsVersionhistory() {
        return this.isContainsVersionhistory;
    }

    public boolean isMixReferenceable() {
        return this.isMixReferenceable;
    }

    public boolean isMixVersionable() {
        return this.isMixVersionable;
    }

    public boolean isNewIdentifer() {
        return this.newIdentifer;
    }

    public void setBaseVersionIdentifier(String baseVersionIdentifier) {
        this.baseVersionIdentifier = baseVersionIdentifier;
    }

    public void setContainsVersionhistory(boolean isContainsVersionhistory) {
        this.isContainsVersionhistory = isContainsVersionhistory;
    }

    public void setExoOwner(String exoOwner) {
        this.exoOwner = exoOwner;
    }

    public boolean isExoOwneable() {
        return this.exoOwner != null;
    }

    public void setExoPrivileges(List<String> exoPrivileges) {
        this.exoPrivileges = exoPrivileges;
    }

    public boolean isExoPrivilegeable() {
        return this.exoPrivileges != null;
    }

    public void setOrderNumber(int orderNum) {
        this.orderNum = orderNum;
    }

    public void setMixinTypeNames(InternalQName[] mixinTypeNames) {
        this.mixinTypeNames = mixinTypeNames;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void setACL(AccessControlList acl) {
        this.acl = acl;
    }

    public void setIsNewIdentifer(boolean newIdentifer) {
        this.newIdentifer = newIdentifer;
    }

    public void setMixReferenceable(boolean isMixReferenceable) {
        this.isMixReferenceable = isMixReferenceable;
    }

    public void setMixVersionable(boolean isMixVersionable) {
        this.isMixVersionable = isMixVersionable;
    }

    @Override
    public void setParentIdentifer(String identifer) {
        this.parentIdentifier = identifer;
    }

    public void setPredecessorsIdentifier(String predecessorsIdentifier) {
        this.predecessorsIdentifier = predecessorsIdentifier;
    }

    public void setPrimaryTypeName(InternalQName name) {
        this.primaryTypeName = name;
    }

    @Override
    public void setQPath(QPath path) {
        this.qpath = path;
    }

    public void setVersionHistoryIdentifier(String versionHistoryIdentifier) {
        this.versionHistoryIdentifier = versionHistoryIdentifier;
    }

    public static ImportNodeData createCopy(NodeData source) {
        return new ImportNodeData(source.getQPath(), source.getIdentifier(), source.getPersistedVersion(), source.getPrimaryTypeName(), source.getMixinTypeNames(), source.getOrderNumber(), source.getParentIdentifier(), source.getACL());
    }
}

