/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.transaction.jbosscache;

import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import javax.transaction.xa.Xid;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.transaction.ExoResource;
import org.exoplatform.services.transaction.TransactionService;
import org.jboss.cache.transaction.TransactionManagerLookup;

public class GenericTransactionService
implements TransactionService {
    private static final Log LOG = ExoLogger.getLogger(GenericTransactionService.class);
    private static final int DEFAULT_TIME_OUT = 60;
    protected final TransactionManagerLookup tmLookup;
    protected final int defaultTimeout;
    protected final boolean forceTimeout;
    private volatile TransactionManager tm;

    public GenericTransactionService(TransactionManagerLookup tmLookup) {
        this(tmLookup, null);
    }

    public GenericTransactionService(TransactionManagerLookup tmLookup, InitParams params) {
        this.tmLookup = tmLookup;
        if (params != null && params.getValueParam("timeout") != null) {
            this.defaultTimeout = Integer.parseInt(params.getValueParam("timeout").getValue());
            this.forceTimeout = true;
        } else {
            this.defaultTimeout = 60;
            this.forceTimeout = false;
        }
    }

    public Xid createXid() {
        throw new UnsupportedOperationException("Method createXid() not supported");
    }

    public void delistResource(ExoResource exores) throws RollbackException, SystemException {
        TransactionManager tm = this.getTransactionManager();
        Transaction tx = tm.getTransaction();
        if (tx != null) {
            tx.delistResource(exores.getXAResource(), 0);
        } else {
            this.delistResourceOnTxMissing(tm, exores);
        }
    }

    public void enlistResource(ExoResource exores) throws RollbackException, SystemException {
        TransactionManager tm = this.getTransactionManager();
        Transaction tx = tm.getTransaction();
        if (tx != null) {
            tx.enlistResource(exores.getXAResource());
        } else {
            this.enlistResourceOnTxMissing(tm, exores);
        }
    }

    public int getDefaultTimeout() {
        return this.defaultTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionManager getTransactionManager() {
        if (this.tm == null) {
            GenericTransactionService genericTransactionService = this;
            synchronized (genericTransactionService) {
                if (this.tm == null) {
                    TransactionManager tm;
                    try {
                        tm = this.tmLookup.getTransactionManager();
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Transaction manager not found", e);
                    }
                    if (this.forceTimeout) {
                        tm = new TransactionManagerTxTimeoutAware(tm, this.defaultTimeout);
                    }
                    this.tm = tm;
                }
            }
        }
        return this.tm;
    }

    public UserTransaction getUserTransaction() {
        throw new UnsupportedOperationException("Method UserTransaction() not supported");
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        TransactionManager tm = this.getTransactionManager();
        tm.setTransactionTimeout(seconds);
    }

    protected void enlistResourceOnTxMissing(TransactionManager tm, ExoResource exores) throws RollbackException, SystemException {
    }

    protected void delistResourceOnTxMissing(TransactionManager tm, ExoResource exores) throws RollbackException, SystemException {
    }

    private static class TransactionManagerTxTimeoutAware
    implements TransactionManager {
        private final TransactionManager tm;
        private final int defaultTimeout;
        private final ThreadLocal<Boolean> timeoutHasBeenSet = new ThreadLocal();

        public TransactionManagerTxTimeoutAware(TransactionManager tm, int defaultTimeout) {
            this.tm = tm;
            this.defaultTimeout = defaultTimeout;
        }

        public void begin() throws NotSupportedException, SystemException {
            if (this.timeoutHasBeenSet.get() != null) {
                this.timeoutHasBeenSet.set(null);
            } else {
                try {
                    this.tm.setTransactionTimeout(this.defaultTimeout);
                }
                catch (Exception e) {
                    LOG.warn((Object)"Cannot set the transaction timeout", (Throwable)e);
                }
            }
            this.tm.begin();
        }

        public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
            this.tm.commit();
        }

        public int getStatus() throws SystemException {
            return this.tm.getStatus();
        }

        public Transaction getTransaction() throws SystemException {
            return this.tm.getTransaction();
        }

        public void resume(Transaction tx) throws InvalidTransactionException, IllegalStateException, SystemException {
            this.tm.resume(tx);
        }

        public void rollback() throws IllegalStateException, SecurityException, SystemException {
            this.tm.rollback();
        }

        public void setRollbackOnly() throws IllegalStateException, SystemException {
            this.tm.setRollbackOnly();
        }

        public void setTransactionTimeout(int timeout) throws SystemException {
            this.tm.setTransactionTimeout(timeout);
            this.timeoutHasBeenSet.set(true);
        }

        public Transaction suspend() throws SystemException {
            return this.tm.suspend();
        }
    }
}

