/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MapResourceBundle
extends ResourceBundle
implements Serializable {
    private static final String REGEXP = "#\\{.*\\}";
    private Map props = new HashMap();
    private Locale locale;

    public MapResourceBundle(Locale l) {
        this.locale = l;
    }

    public MapResourceBundle(ResourceBundle rB, Locale l) {
        this.locale = l;
        this.initMap(rB);
    }

    private void initMap(ResourceBundle rB) {
        Enumeration<String> e = rB.getKeys();
        while (e.hasMoreElements()) {
            String s = e.nextElement();
            try {
                if (this.props.get(s) != null) continue;
                String[] newArray = rB.getStringArray(s);
                this.props.put(s, newArray);
            }
            catch (ClassCastException ex) {
                this.props.put(s, rB.getObject(s));
            }
        }
    }

    protected Object handleGetObject(String key) {
        return this.props.get(key);
    }

    public Enumeration getKeys() {
        return new Vector(this.props.keySet()).elements();
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void add(String key, Object value) {
        this.props.put(key, value);
    }

    public void remove(String key) {
        this.props.remove(key);
    }

    public void merge(ResourceBundle bundle) {
        Enumeration<String> e = bundle.getKeys();
        while (e.hasMoreElements()) {
            String s = e.nextElement();
            Object value = bundle.getObject(s);
            try {
                String[] newArray = bundle.getStringArray(s);
                if (this.props.get(s) != null) continue;
                this.props.put(s, newArray);
            }
            catch (ClassCastException ex) {
                this.props.put(s, value);
            }
        }
    }

    public void resolveDependencies() {
        HashMap<String, String> tempMap = new HashMap<String, String>();
        Set keys = this.props.keySet();
        Pattern pattern = Pattern.compile(REGEXP);
        for (String element : keys) {
            String value = this.lookupKey(element, pattern);
            tempMap.put(element, value);
        }
        this.props = tempMap;
    }

    private String lookupKey(String key, Pattern pattern) {
        String s = (String)this.props.get(key);
        if (s == null) {
            return key;
        }
        Matcher matcher = pattern.matcher(s);
        if (matcher.find()) {
            return this.recursivedResolving(s, pattern);
        }
        return s;
    }

    private String recursivedResolving(String key, Pattern pattern) {
        String resolved = key;
        StringBuffer sB = new StringBuffer();
        while (resolved.indexOf("#{") != -1) {
            sB.setLength(0);
            int firstIndex = resolved.indexOf(35);
            int lastIndex = resolved.indexOf(125, firstIndex);
            String realKey = resolved.substring(firstIndex + 2, lastIndex);
            sB.append(resolved.substring(0, firstIndex));
            sB.append(this.lookupKey(realKey, pattern));
            sB.append(resolved.substring(lastIndex + 1));
            resolved = sB.toString();
        }
        return resolved;
    }
}

